/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.vm.internal;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.extensions.vm.api.QueueDefinition;
import org.mule.extensions.vm.internal.QueueDefinitionRepository;
import org.mule.extensions.vm.internal.VMConnector;
import org.mule.extensions.vm.internal.connection.VMConnection;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.config.QueueProfile;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMConnectorQueueManager
implements Initialisable,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VMConnectorQueueManager.class);
    @Inject
    @Named(value="_muleQueueManager")
    private QueueManager queueManager;
    private QueueDefinitionRepository definitionRepository;
    private Map<String, ComponentLocation> listenerQueues = new ConcurrentHashMap<String, ComponentLocation>();
    private Map<String, Queue> replyToQueues = new ConcurrentHashMap<String, Queue>();

    public void initialise() throws InitialisationException {
        this.definitionRepository = new QueueDefinitionRepository(this.queueManager);
    }

    public void stop() throws MuleException {
        this.replyToQueues.values().forEach(queue -> {
            try {
                queue.dispose();
            }
            catch (Exception e) {
                LOGGER.warn(String.format("Could not dispose temporal reply queue '%s'", queue.getName()), (Throwable)e);
            }
        });
        this.replyToQueues.clear();
        this.listenerQueues.clear();
    }

    public void createQueues(VMConnector config, Collection<QueueDefinition> definitions) throws InitialisationException {
        this.definitionRepository.createQueues(config, definitions);
    }

    public void unregisterQueues(VMConnector config) {
        this.definitionRepository.unregisterQueues(config);
    }

    public void validateQueue(String queueName, VMConnector config) {
        VMConnector owner = this.definitionRepository.findByName(queueName).map(Pair::getFirst).orElseThrow(() -> new IllegalArgumentException(String.format("queue '%s' is not defined", queueName)));
        if (!owner.getName().equals(config.getName())) {
            throw new IllegalArgumentException(String.format("queue '%s' cannot be accessed from component with config-ref '%s' because it was defined on config '%s", queueName, config.getName(), owner.getName()));
        }
    }

    public void registerListenerQueue(VMConnector config, String queueName, ComponentLocation location) throws InitialisationException {
        Pair<VMConnector, QueueDefinition> definitionPair = this.definitionRepository.findByName(queueName).orElseThrow(() -> new IllegalArgumentException(String.format("Flow '%s' declares a <vm:listener> listening to queue '%s', but such queue is not defined", location.getRootContainerName(), queueName)));
        if (!((VMConnector)definitionPair.getFirst()).getName().equals(config.getName())) {
            throw new IllegalArgumentException(String.format("Flow '%s' has a <vm:listener> with config-ref '%s', listening to queue '%s', but that queue is defined on config '%s'. Listeners can only access queues defined in their corresponding config", location.getRootContainerName(), config.getName(), queueName, ((VMConnector)definitionPair.getFirst()).getName()));
        }
        ComponentLocation previous = this.listenerQueues.get(queueName);
        if (previous != null) {
            throw new IllegalArgumentException(String.format("Flow '%s' has a <vm:listener> listening to queue '%s', but flow'%s' is trying to declare another listener to the same queue. Only one listener is allowed per queue.", previous.getRootContainerName(), queueName, location.getRootContainerName()));
        }
        this.listenerQueues.put(queueName, location);
    }

    public void unregisterListenerQueue(String queueName) {
        this.listenerQueues.remove(queueName);
    }

    public QueueConfiguration getQueueConfiguration(String queueName) {
        return (QueueConfiguration)this.queueManager.getQueueConfiguration(queueName).orElseThrow(() -> new IllegalArgumentException(String.format("There's no vm:listener associated to queue '%s'", queueName)));
    }

    public Queue createReplyToQueue(Queue originQueue, VMConnection connection) {
        QueueConfiguration conf = this.getQueueConfiguration(originQueue.getName());
        String tempQueueName = originQueue.getName() + "-temp-replyTo-" + UUID.getUUID();
        QueueProfile tempProfile = new QueueProfile(1, conf.isPersistent());
        try {
            tempProfile.configureQueue(tempQueueName, this.queueManager);
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create temporal reply-to queue for the '%s' queue", new Object[0]), (Object[])new Object[]{originQueue.getName()}), (Throwable)e);
        }
        Queue queue = connection.getQueue(tempQueueName);
        this.replyToQueues.put(tempQueueName, queue);
        return queue;
    }

    public void disposeReplyToQueue(Queue replyToQueue) {
        try {
            replyToQueue.dispose();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to dispose temporal replyTo queue " + replyToQueue.getName(), (Throwable)e);
        }
        finally {
            this.replyToQueues.remove(replyToQueue.getName());
        }
    }

    public void validateNoListenerOnQueue(String queueName, String operationName, ComponentLocation location) {
        ComponentLocation listenerLocation = this.listenerQueues.get(queueName);
        if (listenerLocation != null) {
            throw new IllegalArgumentException(String.format("Operation '<vm:%s>' in Flow '%s' is trying to consume from queue '%s', but Flow '%s' defines a <vm:listener> on that queue. It's not allowed to consume from a queue on which a listener already exists", operationName, location.getRootContainerName(), queueName, listenerLocation.getRootContainerName()));
        }
    }
}

