/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.vm.internal.connection;

import javax.transaction.xa.XAResource;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMConnection
implements XATransactionalConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(VMConnection.class);
    private final QueueSession queueSession;
    private boolean txBegun = false;

    public VMConnection(QueueSession queueSession) {
        this.queueSession = queueSession;
    }

    public Queue getQueue(String queueName) {
        return this.queueSession.getQueue(queueName);
    }

    public void begin() throws TransactionException {
        try {
            this.queueSession.begin();
            this.txBegun = true;
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not start transaction: " + e.getMessage())), (Throwable)e);
        }
    }

    public void commit() throws TransactionException {
        if (!this.txBegun) {
            return;
        }
        try {
            this.queueSession.commit();
            this.txBegun = false;
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not commit transaction: " + e.getMessage())), (Throwable)e);
        }
    }

    public void rollback() throws TransactionException {
        if (!this.txBegun) {
            return;
        }
        try {
            this.queueSession.rollback();
            this.txBegun = false;
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not rollback transaction: " + e.getMessage())), (Throwable)e);
        }
    }

    public XAResource getXAResource() {
        return this.queueSession;
    }

    public void close() {
        block3: {
            if (this.txBegun) {
                try {
                    this.rollback();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block3;
                    LOGGER.warn("Found exception while rolling back transaction due to connection close: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

