/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.command;

import java.util.concurrent.locks.Lock;
import org.mule.extension.file.common.api.FileSystem;
import org.mule.extension.file.common.api.exceptions.FileAlreadyExistsException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileCommand<F extends FileSystem, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileCommand.class);
    protected final F fileSystem;

    protected AbstractFileCommand(F fileSystem) {
        this.fileSystem = fileSystem;
    }

    protected abstract boolean exists(I var1);

    protected void assureParentFolderExists(I path, boolean createParentFolder) {
        if (this.exists(path)) {
            return;
        }
        I parentFolder = this.getParent(path);
        if (!this.exists(parentFolder)) {
            if (createParentFolder) {
                this.mkdirs(parentFolder);
            } else {
                throw new IllegalPathException(String.format("Cannot write to file '%s' because path to it doesn't exist. Consider setting the 'createParentDirectories' attribute to 'true'", this.pathToString(path)));
            }
        }
    }

    protected void mkdirs(I directoryPath) {
        Lock lock = this.fileSystem.createMuleLock(String.format("%s-mkdirs-%s", this.getClass().getName(), directoryPath));
        lock.lock();
        try {
            if (this.exists(directoryPath)) {
                return;
            }
            this.doMkDirs(directoryPath);
        }
        finally {
            lock.unlock();
        }
        LOGGER.debug("Directory '{}' created", directoryPath);
    }

    protected I resolvePath(String filePath) {
        I path = this.getBasePath((FileSystem)this.fileSystem);
        if (filePath != null) {
            path = this.resolvePath(path, filePath);
        }
        return this.getAbsolutePath(path);
    }

    protected boolean isVirtualDirectory(String fileName) {
        return ".".equals(fileName) || "..".equals(fileName);
    }

    protected I resolveExistingPath(String filePath) {
        I path = this.resolvePath(filePath);
        if (!this.exists(path)) {
            throw this.pathNotFoundException(path);
        }
        return path;
    }

    protected IllegalPathException cannotReadDirectoryException(I path) {
        return new IllegalPathException(String.format("Cannot read path '%s' since it's a directory", this.pathToString(path)));
    }

    protected IllegalPathException cannotListFileException(I path) {
        return new IllegalPathException(String.format("Cannot list path '%s' because it's a file. Only directories can be listed", this.pathToString(path)));
    }

    protected IllegalPathException pathNotFoundException(I path) {
        return new IllegalPathException(String.format("Path '%s' doesn't exist", this.pathToString(path)));
    }

    public FileAlreadyExistsException alreadyExistsException(I path) {
        return new FileAlreadyExistsException(String.format("'%s' already exists. Set the 'overwrite' parameter to 'true' to perform the operation anyway", this.pathToString(path)));
    }

    public RuntimeException exception(String message) {
        return new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message));
    }

    public RuntimeException exception(String message, Exception cause) {
        return new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)message), (Throwable)cause);
    }

    protected abstract I getParent(I var1);

    protected abstract I getBasePath(FileSystem var1);

    protected abstract I resolvePath(I var1, String var2);

    protected abstract I getAbsolutePath(I var1);

    protected abstract String pathToString(I var1);

    protected abstract void doMkDirs(I var1);
}

