/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.file.common.api.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.PatternSyntaxException;
import org.mule.extension.file.common.api.exceptions.IllegalPathException;
import org.mule.runtime.api.exception.MuleRuntimeException;

public final class UriUtils {
    private static String SEPARATOR = "/";
    private static final char EOL = '\u0000';
    private static final String regexMetaChars = ".^$+{[]|()";
    private static final String globMetaChars = "\\*?[{";

    private UriUtils() {
    }

    public static URI createUri(String path) {
        return UriUtils.createUri(path, "");
    }

    public static URI createUri(String basePath, String filePath) {
        try {
            String fullPath = filePath.length() > 0 ? (UriUtils.isAbsolute(filePath).booleanValue() ? filePath : UriUtils.addSeparator(basePath) + filePath) : UriUtils.removeSeparator(basePath);
            if (fullPath.split("\\r?\\n").length != 1) {
                throw new IllegalPathException("Path contains newline character: " + fullPath);
            }
            return new URI(null, null, fullPath, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalPathException("Cannot convert given path into a valid Uri", e);
        }
    }

    private static String addSeparator(String path) {
        return path.endsWith(SEPARATOR) || path.length() == 1 ? path : path + SEPARATOR;
    }

    private static String removeSeparator(String path) {
        return !path.endsWith(SEPARATOR) || path.length() == 1 ? path : path.substring(0, path.length() - 1);
    }

    private static Boolean isAbsolute(String path) {
        return path.length() > 0 && path.startsWith(SEPARATOR);
    }

    public static URI normalizeUri(URI uri) {
        URI normalizedUri = uri.normalize();
        String path = normalizedUri.getPath();
        if (path.endsWith(SEPARATOR)) {
            try {
                normalizedUri = new URI(null, null, path.substring(0, path.length() - 1), null).normalize();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return normalizedUri;
    }

    public static URI trimLastFragment(URI uri) {
        Integer index = uri.getPath().lastIndexOf(SEPARATOR);
        return index != -1 ? UriUtils.createUri(uri.getPath().substring(0, index)) : null;
    }

    public static String toRegexPattern(String globPattern) {
        boolean inGroup = false;
        StringBuilder regex = new StringBuilder("^");
        int i = 0;
        block10: while (i < globPattern.length()) {
            char c = globPattern.charAt(i++);
            switch (c) {
                case '\\': {
                    char next;
                    if (i == globPattern.length()) {
                        throw new PatternSyntaxException("No character to escape", globPattern, i - 1);
                    }
                    if (UriUtils.isGlobMeta(next = globPattern.charAt(i++)) || UriUtils.isRegexMeta(next)) {
                        regex.append('\\');
                    }
                    regex.append(next);
                    continue block10;
                }
                case '/': {
                    regex.append(c);
                    continue block10;
                }
                case '[': {
                    regex.append("[[^/]&&[");
                    if (UriUtils.next(globPattern, i) == '^') {
                        regex.append("\\^");
                        ++i;
                    } else {
                        if (UriUtils.next(globPattern, i) == '!') {
                            regex.append('^');
                            ++i;
                        }
                        if (UriUtils.next(globPattern, i) == '-') {
                            regex.append('-');
                            ++i;
                        }
                    }
                    boolean hasRangeStart = false;
                    char last = '\u0000';
                    while (i < globPattern.length() && (c = globPattern.charAt(i++)) != ']') {
                        if (c == '/') {
                            throw new PatternSyntaxException("Explicit 'name separator' in class", globPattern, i - 1);
                        }
                        if (c == '\\' || c == '[' || c == '&' && UriUtils.next(globPattern, i) == '&') {
                            regex.append('\\');
                        }
                        regex.append(c);
                        if (c == '-') {
                            if (!hasRangeStart) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 1);
                            }
                            if ((c = UriUtils.next(globPattern, i++)) == '\u0000' || c == ']') break;
                            if (c < last) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 3);
                            }
                            regex.append(c);
                            hasRangeStart = false;
                            continue;
                        }
                        hasRangeStart = true;
                        last = c;
                    }
                    if (c != ']') {
                        throw new PatternSyntaxException("Missing ']", globPattern, i - 1);
                    }
                    regex.append("]]");
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new PatternSyntaxException("Cannot nest groups", globPattern, i - 1);
                    }
                    regex.append("(?:(?:");
                    inGroup = true;
                    continue block10;
                }
                case '}': {
                    if (inGroup) {
                        regex.append("))");
                        inGroup = false;
                        continue block10;
                    }
                    regex.append('}');
                    continue block10;
                }
                case ',': {
                    if (inGroup) {
                        regex.append(")|(?:");
                        continue block10;
                    }
                    regex.append(',');
                    continue block10;
                }
                case '*': {
                    if (UriUtils.next(globPattern, i) == '*') {
                        regex.append(".*");
                        ++i;
                        continue block10;
                    }
                    regex.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    regex.append("[^/]");
                    continue block10;
                }
            }
            if (UriUtils.isRegexMeta(c)) {
                regex.append('\\');
            }
            regex.append(c);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Missing '}", globPattern, i - 1);
        }
        return regex.append('$').toString();
    }

    private static char next(String glob, int i) {
        if (i < glob.length()) {
            return glob.charAt(i);
        }
        return '\u0000';
    }

    private static boolean isRegexMeta(char c) {
        return regexMetaChars.indexOf(c) != -1;
    }

    private static boolean isGlobMeta(char c) {
        return globMetaChars.indexOf(c) != -1;
    }
}

