/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.Literal;

public class DeferredExpressionResolver {
    private final MuleExpressionLanguage evaluator;

    public DeferredExpressionResolver(MuleExpressionLanguage evaluator) {
        this.evaluator = evaluator;
    }

    public <T> T resolveExpression(Literal<T> literal, Result<Object, ? extends Object> result) {
        if (literal == null) {
            return null;
        }
        String expr = literal.getLiteralValue().orElse(null);
        if (expr == null) {
            return null;
        }
        if (!this.evaluator.isExpression(expr)) {
            return (T)expr;
        }
        BindingContext resultContext = BindingContext.builder().addBinding("payload", new TypedValue(result.getOutput(), DataType.builder().fromObject(result.getOutput()).mediaType(result.getMediaType().orElse(MediaType.ANY)).build())).addBinding("attributes", new TypedValue(result.getAttributes().get(), DataType.fromObject(result.getAttributes().get()))).addBinding("dataType", new TypedValue((Object)DataType.builder().fromObject(result.getOutput()).mediaType((MediaType)result.getMediaType().get()).build(), DataType.fromType(DataType.class))).build();
        return (T)this.evaluator.evaluate(expr, resultContext).getValue();
    }

    public <T> String getExpression(Literal<T> literal) {
        return literal != null ? (String)literal.getLiteralValue().orElse(null) : null;
    }
}

