/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.mule.tools.api.classloader.model.Plugin;

public class AppClassLoaderModel
extends ClassLoaderModel {
    private List<Plugin> additionalPluginDependencies = new ArrayList<Plugin>();

    public AppClassLoaderModel(String version, ArtifactCoordinates artifactCoordinates) {
        super(version, artifactCoordinates);
    }

    @Override
    protected ClassLoaderModel doGetParameterizedUriModel() {
        AppClassLoaderModel copy = new AppClassLoaderModel(this.getVersion(), this.getArtifactCoordinates());
        List<Plugin> pluginsCopy = this.additionalPluginDependencies.stream().map(Plugin::copyWithParameterizedDependenciesUri).collect(Collectors.toList());
        copy.setAdditionalPluginDependencies(pluginsCopy);
        return copy;
    }

    @Override
    public Set<Artifact> getArtifacts() {
        Set<Artifact> artifacts = super.getArtifacts();
        this.additionalPluginDependencies.forEach(plugin -> artifacts.addAll(plugin.getAdditionalDependencies()));
        return artifacts;
    }

    public Optional<List<Plugin>> getAdditionalPluginDependencies() {
        return Optional.ofNullable(this.additionalPluginDependencies);
    }

    public void setAdditionalPluginDependencies(List<Plugin> additionalPluginDependencies) {
        this.additionalPluginDependencies = additionalPluginDependencies;
    }
}

