/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.xacml.ctx;

import javax.xml.namespace.QName;

import org.opensaml.xacml.XACMLConstants;
import org.opensaml.xacml.XACMLObject;

/** XACML context Decision schema type. */
public interface DecisionType extends XACMLObject {

    /** Allowed decision values. */
    enum DECISION {
        /** Denied. */
        Deny,
        
        /** Permitted. */
        Permit,
        
        /** Can't tell. */
        Indeterminate,
        
        /** Not applicable. */
        NotApplicable,
    };

    /** Element name. */
    static final String DEFAULT_ELEMENT_LOCAL_NAME = "Decision";

    /** Default element name. */
    static final QName DEFAULT_ELEMENT_NAME = new QName(XACMLConstants.XACML20CTX_NS,
            DEFAULT_ELEMENT_LOCAL_NAME, XACMLConstants.XACMLCONTEXT_PREFIX);

    /** Local name of the XSI type. */
    static final String TYPE_LOCAL_NAME = "DecisionType";

    /** QName of the XSI type. */
    static final QName TYPE_NAME = new QName(XACMLConstants.XACML20CTX_NS, TYPE_LOCAL_NAME,
            XACMLConstants.XACMLCONTEXT_PREFIX);

    /**
     * Gets the value of the decision.
     * 
     * @return The value of the decision
     */
    DECISION getDecision();

    /**
     * Sets the value of the decision.
     * 
     * @param decision value of the decision
     */
    void setDecision(DECISION decision);
}