/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.authentication;

import java.util.List;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.springframework.security.authentication.Pac4jAuthentication;
import org.pac4j.springframework.security.util.SpringSecurityHelper;
import org.springframework.security.authentication.AbstractAuthenticationToken;

public class Pac4jAuthenticationToken
extends AbstractAuthenticationToken
implements Pac4jAuthentication {
    private final List<CommonProfile> profiles;
    private final CommonProfile profile;

    public Pac4jAuthenticationToken(List<CommonProfile> profiles) {
        super(SpringSecurityHelper.buildAuthorities(profiles));
        this.profiles = profiles;
        this.profile = (CommonProfile)ProfileHelper.flatIntoOneProfile(profiles).get();
        this.setAuthenticated(true);
    }

    public String getName() {
        return this.profile.getId();
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.profile;
    }

    @Override
    public List<CommonProfile> getProfiles() {
        return this.profiles;
    }
}

