/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.authentication;

import java.util.List;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.springframework.security.authentication.Pac4jAuthentication;
import org.pac4j.springframework.security.util.SpringSecurityHelper;
import org.springframework.security.authentication.RememberMeAuthenticationToken;

public class Pac4jRememberMeAuthenticationToken
extends RememberMeAuthenticationToken
implements Pac4jAuthentication {
    private final List<CommonProfile> profiles;

    public Pac4jRememberMeAuthenticationToken(List<CommonProfile> profiles) {
        super("rme", ProfileHelper.flatIntoOneProfile(profiles).get(), SpringSecurityHelper.buildAuthorities(profiles));
        this.profiles = profiles;
        this.setAuthenticated(true);
    }

    public String getName() {
        return ((CommonProfile)this.getPrincipal()).getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Pac4jRememberMeAuthenticationToken that = (Pac4jRememberMeAuthenticationToken)o;
        return this.profiles != null ? this.profiles.equals(that.profiles) : that.profiles == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.profiles != null ? this.profiles.hashCode() : 0);
        return result;
    }

    @Override
    public List<CommonProfile> getProfiles() {
        return this.profiles;
    }
}

