/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.springframework.security.web.AbstractPathFilter;

public class CallbackFilter
extends AbstractPathFilter {
    public static final String DEFAULT_CALLBACK_SUFFIX = "/callback";
    private CallbackLogic<Object, JEEContext> callbackLogic;
    private Config config;
    private String defaultUrl;
    private Boolean saveInSession;
    private Boolean multiProfile;
    private Boolean renewSession;
    private String defaultClient;

    public CallbackFilter() {
        this.setSuffix(DEFAULT_CALLBACK_SUFFIX);
    }

    public CallbackFilter(Config config) {
        this();
        this.config = config;
    }

    public CallbackFilter(Config config, String defaultUrl) {
        this(config);
        this.defaultUrl = defaultUrl;
    }

    public CallbackFilter(Config config, String defaultUrl, boolean multiProfile) {
        this(config, defaultUrl);
        this.multiProfile = multiProfile;
    }

    public CallbackFilter(Config config, String defaultUrl, boolean multiProfile, boolean renewSession) {
        this(config, defaultUrl, multiProfile);
        this.renewSession = renewSession;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)this.config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        CallbackLogic bestLogic = FindBest.callbackLogic(this.callbackLogic, (Config)this.config, (CallbackLogic)DefaultCallbackLogic.INSTANCE);
        JEEContext context = new JEEContext((HttpServletRequest)req, (HttpServletResponse)resp, bestSessionStore);
        if (this.mustApply(context)) {
            bestLogic.perform((WebContext)context, this.config, bestAdapter, this.defaultUrl, this.saveInSession, this.multiProfile, this.renewSession, this.defaultClient);
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }

    public CallbackLogic<Object, JEEContext> getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic<Object, JEEContext> callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public Boolean getMultiProfile() {
        return this.multiProfile;
    }

    public void setMultiProfile(Boolean multiProfile) {
        this.multiProfile = multiProfile;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public Boolean getSaveInSession() {
        return this.saveInSession;
    }

    public void setSaveInSession(Boolean saveInSession) {
        this.saveInSession = saveInSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }
}

