/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.process;

import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.pitest.classpath.ClassPath;
import org.pitest.functional.prelude.Prelude;
import org.pitest.process.JavaAgent;
import org.pitest.process.LaunchOptions;

public final class ProcessArgs {
    private final String launchClassPath;
    private Consumer<String> stdout = Prelude.print(String.class);
    private Consumer<String> stdErr = Prelude.printTo(String.class, (PrintStream)System.err);
    private List<String> jvmArgs = Collections.emptyList();
    private JavaAgent javaAgentFinder;
    private File workingDir = null;
    private String javaExecutable;
    private Map<String, String> environmentVariables;
    private boolean useClasspathJar = false;

    private ProcessArgs(String launchClassPath) {
        this.launchClassPath = launchClassPath;
    }

    public static ProcessArgs withClassPath(String cp) {
        return new ProcessArgs(cp);
    }

    public static ProcessArgs withClassPath(ClassPath cp) {
        return new ProcessArgs(cp.getLocalClassPath());
    }

    public ProcessArgs andBaseDir(File baseDir) {
        this.workingDir = baseDir;
        return this;
    }

    public ProcessArgs andStdout(Consumer<String> stdout) {
        this.stdout = stdout;
        return this;
    }

    public ProcessArgs andStderr(Consumer<String> stderr) {
        this.stdErr = stderr;
        return this;
    }

    public String getLaunchClassPath() {
        return this.launchClassPath;
    }

    public Consumer<String> getStdout() {
        return this.stdout;
    }

    public Consumer<String> getStdErr() {
        return this.stdErr;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public JavaAgent getJavaAgentFinder() {
        return this.javaAgentFinder;
    }

    public void setStdout(Consumer<String> stdout) {
        this.stdout = stdout;
    }

    public void setStdErr(Consumer<String> stdErr) {
        this.stdErr = stdErr;
    }

    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public boolean useClasspathJar() {
        return this.useClasspathJar;
    }

    public ProcessArgs andLaunchOptions(LaunchOptions launchOptions) {
        this.jvmArgs = launchOptions.getChildJVMArgs();
        this.javaAgentFinder = launchOptions.getJavaAgentFinder();
        this.javaExecutable = launchOptions.getJavaExecutable();
        this.environmentVariables = launchOptions.getEnvironmentVariables();
        this.useClasspathJar = launchOptions.useClasspathJar();
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }
}

