/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.reloc.antlr.stringtemplate.language;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pitest.reloc.antlr.common.RecognitionException;
import org.pitest.reloc.antlr.common.collections.AST;
import org.pitest.reloc.antlr.stringtemplate.AttributeRenderer;
import org.pitest.reloc.antlr.stringtemplate.StringTemplate;
import org.pitest.reloc.antlr.stringtemplate.StringTemplateGroup;
import org.pitest.reloc.antlr.stringtemplate.StringTemplateWriter;
import org.pitest.reloc.antlr.stringtemplate.language.ActionEvaluator;
import org.pitest.reloc.antlr.stringtemplate.language.ArrayWrappedInList;
import org.pitest.reloc.antlr.stringtemplate.language.ConditionalExpr;
import org.pitest.reloc.antlr.stringtemplate.language.Expr;
import org.pitest.reloc.antlr.stringtemplate.language.StringTemplateAST;

public class ASTExpr
extends Expr {
    public static final int MISSING = -1;
    public static final String DEFAULT_ATTRIBUTE_NAME = "it";
    public static final String DEFAULT_ATTRIBUTE_NAME_DEPRECATED = "attr";
    public static final String DEFAULT_INDEX_VARIABLE_NAME = "i";
    public static final String DEFAULT_INDEX0_VARIABLE_NAME = "i0";
    public static final String DEFAULT_MAP_VALUE_NAME = "_default_";
    public static final String DEFAULT_MAP_KEY_NAME = "key";
    public static final StringTemplate MAP_KEY_VALUE = new StringTemplate();
    public static final String EMPTY_OPTION = "empty expr option";
    public static final Map defaultOptionValues = new HashMap(){
        {
            this.put("anchor", new StringTemplateAST(34, "true"));
            this.put("wrap", new StringTemplateAST(34, "\n"));
        }
    };
    public static final Set supportedOptions = new HashSet(){
        {
            this.add("anchor");
            this.add("format");
            this.add("null");
            this.add("separator");
            this.add("wrap");
        }
    };
    AST exprTree = null;
    Map options = null;
    String wrapString = null;
    String nullValue = null;
    String separatorString = null;
    String formatString = null;

    public ASTExpr(StringTemplate enclosingTemplate, AST exprTree, Map options) {
        super(enclosingTemplate);
        this.exprTree = exprTree;
        this.options = options;
    }

    public AST getAST() {
        return this.exprTree;
    }

    public int write(StringTemplate self, StringTemplateWriter out) throws IOException {
        if (this.exprTree == null || self == null || out == null) {
            return 0;
        }
        StringTemplateAST anchorAST = (StringTemplateAST)this.getOption("anchor");
        if (anchorAST != null) {
            out.pushAnchorPoint();
        }
        out.pushIndentation(this.getIndentation());
        this.handleExprOptions(self);
        ActionEvaluator eval = new ActionEvaluator(self, this, out);
        int n = 0;
        try {
            n = eval.action(this.exprTree);
        }
        catch (RecognitionException re) {
            self.error("can't evaluate tree: " + this.exprTree.toStringList(), re);
        }
        out.popIndentation();
        if (anchorAST != null) {
            out.popAnchorPoint();
        }
        return n;
    }

    protected void handleExprOptions(StringTemplate self) {
        StringTemplateAST formatAST;
        StringTemplateAST separatorAST;
        StringTemplateAST nullValueAST;
        this.formatString = null;
        StringTemplateAST wrapAST = (StringTemplateAST)this.getOption("wrap");
        if (wrapAST != null) {
            this.wrapString = this.evaluateExpression(self, wrapAST);
        }
        if ((nullValueAST = (StringTemplateAST)this.getOption("null")) != null) {
            this.nullValue = this.evaluateExpression(self, nullValueAST);
        }
        if ((separatorAST = (StringTemplateAST)this.getOption("separator")) != null) {
            this.separatorString = this.evaluateExpression(self, separatorAST);
        }
        if ((formatAST = (StringTemplateAST)this.getOption("format")) != null) {
            this.formatString = this.evaluateExpression(self, formatAST);
        }
        if (this.options != null) {
            Iterator it = this.options.keySet().iterator();
            while (it.hasNext()) {
                String option = (String)it.next();
                if (supportedOptions.contains(option)) continue;
                self.warning("ignoring unsupported option: " + option);
            }
        }
    }

    public Object applyTemplateToListOfAttributes(StringTemplate self, List attributes, StringTemplate templateToApply) {
        if (attributes == null || templateToApply == null || attributes.size() == 0) {
            return null;
        }
        HashMap<String, Object> argumentContext = null;
        StringTemplate.STAttributeList results = new StringTemplate.STAttributeList();
        for (int a = 0; a < attributes.size(); ++a) {
            Object o = attributes.get(a);
            if (o == null) continue;
            o = ASTExpr.convertAnythingToIterator(o);
            attributes.set(a, o);
        }
        int numAttributes = attributes.size();
        Map formalArguments = templateToApply.getFormalArguments();
        if (formalArguments == null || formalArguments.size() == 0) {
            self.error("missing arguments in anonymous template in context " + self.getEnclosingInstanceStackString());
            return null;
        }
        Object[] formalArgumentNames = formalArguments.keySet().toArray();
        if (formalArgumentNames.length != numAttributes) {
            int shorterSize;
            self.error("number of arguments " + formalArguments.keySet() + " mismatch between attribute list and anonymous" + " template in context " + self.getEnclosingInstanceStackString());
            numAttributes = shorterSize = Math.min(formalArgumentNames.length, numAttributes);
            Object[] newFormalArgumentNames = new Object[shorterSize];
            System.arraycopy(formalArgumentNames, 0, newFormalArgumentNames, 0, shorterSize);
            formalArgumentNames = newFormalArgumentNames;
        }
        int i = 0;
        while (true) {
            argumentContext = new HashMap<String, Object>();
            int numEmpty = 0;
            for (int a = 0; a < numAttributes; ++a) {
                Iterator it = (Iterator)attributes.get(a);
                if (it != null && it.hasNext()) {
                    String argName = (String)formalArgumentNames[a];
                    Object iteratedValue = it.next();
                    argumentContext.put(argName, iteratedValue);
                    continue;
                }
                ++numEmpty;
            }
            if (numEmpty == numAttributes) break;
            argumentContext.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(i + 1));
            argumentContext.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(i));
            StringTemplate embedded = templateToApply.getInstanceOf();
            embedded.setEnclosingInstance(self);
            embedded.setArgumentContext(argumentContext);
            results.add(embedded);
            ++i;
        }
        return results;
    }

    public Object applyListOfAlternatingTemplates(StringTemplate self, Object attributeValue, List templatesToApply) {
        boolean isAnonymous;
        if (attributeValue == null || templatesToApply == null || templatesToApply.size() == 0) {
            return null;
        }
        StringTemplate embedded = null;
        HashMap<String, Object> argumentContext = null;
        attributeValue = ASTExpr.convertArrayToList(attributeValue);
        if ((attributeValue = ASTExpr.convertAnythingIteratableToIterator(attributeValue)) instanceof Iterator) {
            StringTemplate.STAttributeList resultVector = new StringTemplate.STAttributeList();
            Iterator iter = (Iterator)attributeValue;
            int i = 0;
            while (iter.hasNext()) {
                Object ithValue = iter.next();
                if (ithValue == null) {
                    if (this.nullValue == null) continue;
                    ithValue = this.nullValue;
                }
                int templateIndex = i % templatesToApply.size();
                embedded = (StringTemplate)templatesToApply.get(templateIndex);
                StringTemplateAST args = embedded.getArgumentsAST();
                embedded = embedded.getInstanceOf();
                embedded.setEnclosingInstance(self);
                embedded.setArgumentsAST(args);
                argumentContext = new HashMap();
                Map formalArgs = embedded.getFormalArguments();
                boolean isAnonymous2 = embedded.getName() == "anonymous";
                this.setSoleFormalArgumentToIthValue(embedded, argumentContext, ithValue);
                if (!isAnonymous2 || formalArgs == null || formalArgs.size() <= 0) {
                    argumentContext.put(DEFAULT_ATTRIBUTE_NAME, ithValue);
                    argumentContext.put(DEFAULT_ATTRIBUTE_NAME_DEPRECATED, ithValue);
                }
                argumentContext.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(i + 1));
                argumentContext.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(i));
                embedded.setArgumentContext(argumentContext);
                this.evaluateArguments(embedded);
                resultVector.add(embedded);
                ++i;
            }
            if (resultVector.size() == 0) {
                resultVector = null;
            }
            return resultVector;
        }
        embedded = (StringTemplate)templatesToApply.get(0);
        argumentContext = new HashMap<String, Object>();
        Map formalArgs = embedded.getFormalArguments();
        StringTemplateAST args = embedded.getArgumentsAST();
        this.setSoleFormalArgumentToIthValue(embedded, argumentContext, attributeValue);
        boolean bl = isAnonymous = embedded.getName() == "anonymous";
        if (!isAnonymous || formalArgs == null || formalArgs.size() <= 0) {
            argumentContext.put(DEFAULT_ATTRIBUTE_NAME, attributeValue);
            argumentContext.put(DEFAULT_ATTRIBUTE_NAME_DEPRECATED, attributeValue);
        }
        argumentContext.put(DEFAULT_INDEX_VARIABLE_NAME, new Integer(1));
        argumentContext.put(DEFAULT_INDEX0_VARIABLE_NAME, new Integer(0));
        embedded.setArgumentContext(argumentContext);
        this.evaluateArguments(embedded);
        return embedded;
    }

    protected void setSoleFormalArgumentToIthValue(StringTemplate embedded, Map argumentContext, Object ithValue) {
        Map formalArgs = embedded.getFormalArguments();
        if (formalArgs != null) {
            boolean isAnonymous;
            String soleArgName = null;
            boolean bl = isAnonymous = embedded.getName() == "anonymous";
            if (formalArgs.size() == 1 || isAnonymous && formalArgs.size() > 0) {
                if (isAnonymous && formalArgs.size() > 1) {
                    embedded.error("too many arguments on {...} template: " + formalArgs);
                }
                Set argNames = formalArgs.keySet();
                soleArgName = (String)argNames.toArray()[0];
                argumentContext.put(soleArgName, ithValue);
            }
        }
    }

    public Object getObjectProperty(StringTemplate self, Object o, Object propertyName) {
        if (o == null || propertyName == null) {
            return null;
        }
        Object value = this.rawGetObjectProperty(self, o, propertyName);
        value = ASTExpr.convertArrayToList(value);
        return value;
    }

    protected Object rawGetObjectProperty(StringTemplate self, Object o, Object property) {
        Map attributes;
        Class<?> c = o.getClass();
        Object value = null;
        if (c == StringTemplate.Aggregate.class) {
            String propertyName = (String)property;
            value = ((StringTemplate.Aggregate)o).get(propertyName);
            return value;
        }
        if (c == StringTemplate.class && (attributes = ((StringTemplate)o).getAttributes()) != null) {
            String propertyName = (String)property;
            value = attributes.get(propertyName);
            return value;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (property.equals("keys")) {
                value = map.keySet();
            } else if (property.equals("values")) {
                value = map.values();
            } else if (map.containsKey(property)) {
                value = map.get(property);
            } else if (map.containsKey(property.toString())) {
                value = map.get(property.toString());
            } else if (map.containsKey(DEFAULT_MAP_VALUE_NAME)) {
                value = map.get(DEFAULT_MAP_VALUE_NAME);
            }
            if (value == MAP_KEY_VALUE) {
                value = property;
            }
            return value;
        }
        Method m = null;
        String propertyName = (String)property;
        String methodSuffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1, propertyName.length());
        m = this.getMethod(c, "get" + methodSuffix);
        if (m == null) {
            m = this.getMethod(c, "is" + methodSuffix);
        }
        if (m != null) {
            try {
                value = this.invokeMethod(m, o, value);
            }
            catch (Exception e) {
                self.error("Can't get property " + propertyName + " using method get/is" + methodSuffix + " from " + c.getName() + " instance", e);
            }
        } else {
            try {
                Field f = c.getField(propertyName);
                try {
                    value = this.accessField(f, o, value);
                }
                catch (IllegalAccessException iae) {
                    self.error("Can't access property " + propertyName + " using method get/is" + methodSuffix + " or direct field access from " + c.getName() + " instance", iae);
                }
            }
            catch (NoSuchFieldException nsfe) {
                self.error("Class " + c.getName() + " has no such attribute: " + propertyName + " in template context " + self.getEnclosingInstanceStackString(), nsfe);
            }
        }
        return value;
    }

    protected Object accessField(Field f, Object o, Object value) throws IllegalAccessException {
        try {
            f.setAccessible(true);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        value = f.get(o);
        return value;
    }

    protected Object invokeMethod(Method m, Object o, Object value) throws IllegalAccessException, InvocationTargetException {
        try {
            m.setAccessible(true);
        }
        catch (SecurityException se) {
            // empty catch block
        }
        value = m.invoke(o, (Object[])null);
        return value;
    }

    protected Method getMethod(Class c, String methodName) {
        Method m;
        try {
            m = c.getMethod(methodName, null);
        }
        catch (NoSuchMethodException nsme) {
            m = null;
        }
        return m;
    }

    public boolean testAttributeTrue(Object a) {
        if (a == null) {
            return false;
        }
        if (a instanceof Boolean) {
            return (Boolean)a;
        }
        if (a instanceof Collection) {
            return ((Collection)a).size() > 0;
        }
        if (a instanceof Map) {
            return ((Map)a).size() > 0;
        }
        if (a instanceof Iterator) {
            return ((Iterator)a).hasNext();
        }
        return true;
    }

    public Object add(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.toString() + b.toString();
    }

    public StringTemplate getTemplateInclude(StringTemplate enclosing, String templateName, StringTemplateAST argumentsAST) {
        StringTemplateGroup group = enclosing.getGroup();
        StringTemplate embedded = group.getEmbeddedInstanceOf(enclosing, templateName);
        if (embedded == null) {
            enclosing.error("cannot make embedded instance of " + templateName + " in template " + enclosing.getName());
            return null;
        }
        embedded.setArgumentsAST(argumentsAST);
        this.evaluateArguments(embedded);
        return embedded;
    }

    public int writeAttribute(StringTemplate self, Object o, StringTemplateWriter out) {
        return this.write(self, o, out);
    }

    protected int write(StringTemplate self, Object o, StringTemplateWriter out) {
        if (o == null) {
            if (this.nullValue == null) {
                return -1;
            }
            o = this.nullValue;
        }
        int n = 0;
        try {
            if (o instanceof StringTemplate) {
                return this.writeTemplate(self, o, out);
            }
            if ((o = ASTExpr.convertAnythingIteratableToIterator(o)) instanceof Iterator) {
                return this.writeIterableValue(self, o, out);
            }
            return this.writePOJO(self, o, out);
        }
        catch (IOException io) {
            self.error("problem writing object: " + o, io);
            return n;
        }
    }

    protected int writePOJO(StringTemplate self, Object o, StringTemplateWriter out) throws IOException {
        int n = 0;
        AttributeRenderer renderer = self.getAttributeRenderer(o.getClass());
        String v = null;
        v = renderer != null ? (this.formatString != null ? renderer.toString(o, this.formatString) : renderer.toString(o)) : o.toString();
        n = this.wrapString != null ? out.write(v, this.wrapString) : out.write(v);
        return n;
    }

    protected int writeTemplate(StringTemplate self, Object o, StringTemplateWriter out) throws IOException {
        AttributeRenderer renderer;
        int n = 0;
        StringTemplate stToWrite = (StringTemplate)o;
        stToWrite.setEnclosingInstance(self);
        if (StringTemplate.inLintMode() && StringTemplate.isRecursiveEnclosingInstance(stToWrite)) {
            throw new IllegalStateException("infinite recursion to " + stToWrite.getTemplateDeclaratorString() + " referenced in " + stToWrite.getEnclosingInstance().getTemplateDeclaratorString() + "; stack trace:\n" + stToWrite.getEnclosingInstanceStackTrace());
        }
        if (this.wrapString != null) {
            n = out.writeWrapSeparator(this.wrapString);
        }
        if (this.formatString != null && (renderer = self.getAttributeRenderer(String.class)) != null) {
            StringWriter buf = new StringWriter();
            StringTemplateWriter sw = self.getGroup().getStringTemplateWriter(buf);
            stToWrite.write(sw);
            n = out.write(renderer.toString(buf.toString(), this.formatString));
            return n;
        }
        n = stToWrite.write(out);
        return n;
    }

    protected int writeIterableValue(StringTemplate self, Object o, StringTemplateWriter out) throws IOException {
        int n = 0;
        Iterator iter = (Iterator)o;
        boolean seenAValue = false;
        while (iter.hasNext()) {
            int nw;
            Object iterValue = iter.next();
            if (iterValue == null) {
                iterValue = this.nullValue;
            }
            if (iterValue == null) continue;
            if (this.separatorString == null) {
                int nw2 = this.write(self, iterValue, out);
                if (nw2 == -1) continue;
                n += nw2;
                continue;
            }
            if (iterValue instanceof StringTemplate) {
                StringTemplate st = (StringTemplate)iterValue;
                int nchunks = st.getChunks() != null ? st.getChunks().size() : 0;
                boolean nullable = true;
                for (int i = 0; i < nchunks; ++i) {
                    Expr a = (Expr)st.getChunks().get(i);
                    if (a instanceof ConditionalExpr) continue;
                    nullable = false;
                }
                if (!nullable) {
                    if (seenAValue && this.separatorString != null) {
                        n += out.writeSeparator(this.separatorString);
                    }
                    nw = this.write(self, iterValue, out);
                    n += nw;
                    seenAValue = true;
                    continue;
                }
            }
            if (!(iterValue instanceof StringTemplate) && !(iterValue instanceof Iterator)) {
                if (seenAValue && this.separatorString != null) {
                    n += out.writeSeparator(this.separatorString);
                }
                int nw3 = this.write(self, iterValue, out);
                seenAValue = true;
                n += nw3;
                continue;
            }
            StringWriter buf = new StringWriter();
            StringTemplateWriter sw = self.getGroup().getStringTemplateWriter(buf);
            int tmpsize = this.write(self, iterValue, sw);
            if (tmpsize == -1) continue;
            if (seenAValue && this.separatorString != null) {
                n += out.writeSeparator(this.separatorString);
            }
            nw = this.write(self, iterValue, out);
            n += nw;
            seenAValue = true;
        }
        return n;
    }

    public String evaluateExpression(StringTemplate self, Object expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof StringTemplateAST) {
            StringTemplateAST exprAST = (StringTemplateAST)expr;
            StringWriter buf = new StringWriter();
            StringTemplateWriter sw = self.getGroup().getStringTemplateWriter(buf);
            ActionEvaluator eval = new ActionEvaluator(self, this, sw);
            try {
                eval.action(exprAST);
            }
            catch (RecognitionException re) {
                self.error("can't evaluate tree: " + this.exprTree.toStringList(), re);
            }
            return buf.toString();
        }
        return expr.toString();
    }

    protected void evaluateArguments(StringTemplate self) {
        StringTemplateAST argumentsAST = self.getArgumentsAST();
        if (argumentsAST == null || argumentsAST.getFirstChild() == null) {
            return;
        }
        StringTemplate enclosing = self.getEnclosingInstance();
        StringTemplate argContextST = new StringTemplate(self.getGroup(), "");
        argContextST.setName("<invoke " + self.getName() + " arg context>");
        argContextST.setEnclosingInstance(enclosing);
        argContextST.setArgumentContext(self.getArgumentContext());
        ActionEvaluator eval = new ActionEvaluator(argContextST, this, null);
        try {
            Map ac = eval.argList(argumentsAST, self, self.getArgumentContext());
            self.setArgumentContext(ac);
        }
        catch (RecognitionException re) {
            self.error("can't evaluate tree: " + argumentsAST.toStringList(), re);
        }
    }

    public static Object convertArrayToList(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return new ArrayWrappedInList(value);
            }
            return Arrays.asList((Object[])value);
        }
        return value;
    }

    protected static Object convertAnythingIteratableToIterator(Object o) {
        Iterator iter = null;
        if (o instanceof Collection) {
            iter = ((Collection)o).iterator();
        } else if (o instanceof Map) {
            iter = ((Map)o).values().iterator();
        } else if (o instanceof Iterator) {
            iter = (Iterator)o;
        }
        if (iter == null) {
            return o;
        }
        return iter;
    }

    protected static Iterator convertAnythingToIterator(Object o) {
        Iterator iter = null;
        if (o instanceof Collection) {
            iter = ((Collection)o).iterator();
        } else if (o instanceof Map) {
            iter = ((Map)o).values().iterator();
        } else if (o instanceof Iterator) {
            iter = (Iterator)o;
        }
        if (iter == null) {
            StringTemplate.STAttributeList singleton = new StringTemplate.STAttributeList(1);
            singleton.add(o);
            return singleton.iterator();
        }
        return iter;
    }

    public Object first(Object attribute) {
        Iterator it;
        if (attribute == null) {
            return null;
        }
        Object f = attribute;
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator && (it = (Iterator)attribute).hasNext()) {
            f = it.next();
        }
        return f;
    }

    public Object rest(Object attribute) {
        if (attribute == null) {
            return null;
        }
        Object theRest = attribute;
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)attribute;
            if (!it.hasNext()) {
                return null;
            }
            it.next();
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null) continue;
                a.add(o);
            }
            return a;
        }
        theRest = null;
        return theRest;
    }

    public Object last(Object attribute) {
        if (attribute == null) {
            return null;
        }
        Object last = attribute;
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            Iterator it = (Iterator)attribute;
            while (it.hasNext()) {
                last = it.next();
            }
        }
        return last;
    }

    public Object strip(Object attribute) {
        if (attribute == null) {
            return null;
        }
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)attribute;
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null) continue;
                a.add(o);
            }
            return a;
        }
        return attribute;
    }

    public Object trunc(Object attribute) {
        if (attribute == null) {
            return null;
        }
        if ((attribute = ASTExpr.convertAnythingIteratableToIterator(attribute)) instanceof Iterator) {
            ArrayList a = new ArrayList();
            Iterator it = (Iterator)attribute;
            while (it.hasNext()) {
                Object o = it.next();
                if (!it.hasNext()) continue;
                a.add(o);
            }
            return a;
        }
        return null;
    }

    public Object length(Object attribute) {
        if (attribute == null) {
            return new Integer(0);
        }
        int i = 1;
        if (attribute instanceof Map) {
            i = ((Map)attribute).size();
        } else if (attribute instanceof Collection) {
            i = ((Collection)attribute).size();
        } else if (attribute instanceof Object[]) {
            Object[] list = (Object[])attribute;
            i = list.length;
        } else if (attribute instanceof int[]) {
            int[] list = (int[])attribute;
            i = list.length;
        } else if (attribute instanceof long[]) {
            long[] list = (long[])attribute;
            i = list.length;
        } else if (attribute instanceof float[]) {
            float[] list = (float[])attribute;
            i = list.length;
        } else if (attribute instanceof double[]) {
            double[] list = (double[])attribute;
            i = list.length;
        } else if (attribute instanceof Iterator) {
            Iterator it = (Iterator)attribute;
            i = 0;
            while (it.hasNext()) {
                it.next();
                ++i;
            }
        }
        return new Integer(i);
    }

    public Object getOption(String name) {
        Object value = null;
        if (this.options != null && (value = this.options.get(name)) == EMPTY_OPTION) {
            return defaultOptionValues.get(name);
        }
        return value;
    }

    public String toString() {
        return this.exprTree.toStringList();
    }
}

