/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac.handlers;

import com.sun.tools.javac.tree.JCTree;
import lombok.AccessLevel;
import lombok.core.AnnotationValues;
import lombok.core.HandlerPriority;
import lombok.experimental.NonFinal;
import lombok.experimental.Value;
import lombok.javac.JavacAnnotationHandler;
import lombok.javac.JavacNode;
import lombok.javac.handlers.HandleConstructor;
import lombok.javac.handlers.HandleEqualsAndHashCode;
import lombok.javac.handlers.HandleFieldDefaults;
import lombok.javac.handlers.HandleGetter;
import lombok.javac.handlers.HandleToString;
import lombok.javac.handlers.HandleWither;
import lombok.javac.handlers.JavacHandlerUtil;

@HandlerPriority(value=-512)
public class HandleValue
extends JavacAnnotationHandler<Value> {
    @Override
    public void handle(AnnotationValues<Value> annotation, JCTree.JCAnnotation ast, JavacNode annotationNode) {
        boolean notAClass;
        JavacHandlerUtil.deleteAnnotationIfNeccessary(annotationNode, Value.class);
        JavacNode typeNode = (JavacNode)annotationNode.up();
        boolean bl = notAClass = !JavacHandlerUtil.isClass(typeNode);
        if (notAClass) {
            annotationNode.addError("@Value is only supported on a class.");
            return;
        }
        String staticConstructorName = annotation.getInstance().staticConstructor();
        if (!JavacHandlerUtil.hasAnnotationAndDeleteIfNeccessary(NonFinal.class, typeNode)) {
            JCTree.JCModifiers jcm = ((JCTree.JCClassDecl)typeNode.get()).mods;
            if ((jcm.flags & 0x10L) == 0L) {
                jcm.flags |= 0x10L;
                typeNode.rebuild();
            }
        }
        new HandleFieldDefaults().generateFieldDefaultsForType(typeNode, annotationNode, AccessLevel.PRIVATE, true, true);
        new HandleConstructor().generateAllArgsConstructor(typeNode, AccessLevel.PUBLIC, staticConstructorName, true, annotationNode);
        new HandleGetter().generateGetterForType(typeNode, annotationNode, AccessLevel.PUBLIC, true);
        new HandleWither().generateWitherForType(typeNode, annotationNode, AccessLevel.PUBLIC, true);
        new HandleEqualsAndHashCode().generateEqualsAndHashCodeForType(typeNode, annotationNode);
        new HandleToString().generateToStringForType(typeNode, annotationNode);
    }
}

