/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.log.LoggingManager;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;

public class DeleteSession
extends WebDriverHandler<Void> {
    public DeleteSession(Session session) {
        super(session);
    }

    @Override
    public Void call() throws Exception {
        WebDriver driver = this.getDriver();
        if (driver == null) {
            return null;
        }
        try {
            LoggingManager.perSessionLogHandler().fetchAndStoreLogsFromDriver(this.getSessionId(), driver);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        driver.quit();
        PerSessionLogHandler logHandler = LoggingManager.perSessionLogHandler();
        logHandler.transferThreadTempLogsToSessionLogs(this.getSessionId());
        return null;
    }

    public String toString() {
        return String.format("[delete session: %s]", this.getRealSessionId());
    }
}

