/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

class PropertyResolvingMappingDiscoverer
implements MappingDiscoverer {
    private final MappingDiscoverer delegate;

    PropertyResolvingMappingDiscoverer(MappingDiscoverer delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate MappingDiscoverer must not be null!");
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public String getMapping(Class<?> type) {
        return PropertyResolvingMappingDiscoverer.resolveProperties(this.delegate.getMapping(type));
    }

    @Override
    @Nullable
    public String getMapping(Method method) {
        return PropertyResolvingMappingDiscoverer.resolveProperties(this.delegate.getMapping(method));
    }

    @Override
    @Nullable
    public String getMapping(Class<?> type, Method method) {
        return PropertyResolvingMappingDiscoverer.resolveProperties(this.delegate.getMapping(type, method));
    }

    @Override
    public Collection<HttpMethod> getRequestMethod(Class<?> type, Method method) {
        return this.delegate.getRequestMethod(type, method);
    }

    @Override
    public List<MediaType> getConsumes(Method method) {
        return this.delegate.getConsumes(method);
    }

    @Nullable
    private static String resolveProperties(@Nullable String mapping) {
        if (mapping == null) {
            return mapping;
        }
        WebApplicationContext context = ContextLoader.getCurrentWebApplicationContext();
        return context == null ? mapping : context.getEnvironment().resolvePlaceholders(mapping);
    }
}

