/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.core;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.jpa.core.DefaultJpaOperations;
import org.springframework.integration.jpa.core.JpaOperations;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.PersistMode;
import org.springframework.integration.jpa.support.parametersource.BeanPropertyParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.ParameterSource;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaExecutor
implements InitializingBean {
    private volatile JpaOperations jpaOperations;
    private volatile List<JpaParameter> jpaParameters;
    private volatile Class<?> entityClass;
    private volatile String jpaQuery;
    private volatile String nativeQuery;
    private volatile String namedQuery;
    private volatile int maxNumberOfResults = 0;
    private volatile PersistMode persistMode = PersistMode.MERGE;
    private volatile ParameterSourceFactory parameterSourceFactory = null;
    private volatile ParameterSource parameterSource;
    private volatile boolean deleteAfterPoll = false;
    private volatile boolean deleteInBatch = false;
    private volatile boolean expectSingleResult = false;
    private volatile Boolean usePayloadAsParameterSource = null;

    public JpaExecutor(EntityManagerFactory entityManagerFactory) {
        Assert.notNull((Object)entityManagerFactory, (String)"entityManagerFactory must not be null.");
        DefaultJpaOperations defaultJpaOperations = new DefaultJpaOperations();
        defaultJpaOperations.setEntityManagerFactory(entityManagerFactory);
        defaultJpaOperations.afterPropertiesSet();
        this.jpaOperations = defaultJpaOperations;
    }

    public JpaExecutor(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"entityManager must not be null.");
        DefaultJpaOperations defaultJpaOperations = new DefaultJpaOperations();
        defaultJpaOperations.setEntityManager(entityManager);
        defaultJpaOperations.afterPropertiesSet();
        this.jpaOperations = defaultJpaOperations;
    }

    public JpaExecutor(JpaOperations jpaOperations) {
        Assert.notNull((Object)jpaOperations, (String)"jpaOperations must not be null.");
        this.jpaOperations = jpaOperations;
    }

    public void afterPropertiesSet() {
        if (this.jpaParameters != null) {
            if (this.parameterSourceFactory == null) {
                ExpressionEvaluatingParameterSourceFactory expressionSourceFactory = new ExpressionEvaluatingParameterSourceFactory();
                expressionSourceFactory.setParameters(this.jpaParameters);
                this.parameterSourceFactory = expressionSourceFactory;
            } else if (!(this.parameterSourceFactory instanceof ExpressionEvaluatingParameterSourceFactory)) {
                throw new IllegalStateException("You are providing 'JpaParameters'. Was expecting the the provided jpaParameterSourceFactory to be an instance of 'ExpressionEvaluatingJpaParameterSourceFactory', however the provided one is of type '" + this.parameterSourceFactory.getClass().getName() + "'");
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = false;
            }
        } else {
            if (this.parameterSourceFactory == null) {
                this.parameterSourceFactory = new BeanPropertyParameterSourceFactory();
            }
            if (this.usePayloadAsParameterSource == null) {
                this.usePayloadAsParameterSource = true;
            }
        }
    }

    public Object executeOutboundJpaOperation(Message<?> message) {
        Object result;
        ParameterSource parameterSource = null;
        if (this.jpaQuery != null || this.nativeQuery != null || this.namedQuery != null) {
            parameterSource = this.determineParameterSource(message);
        }
        if (this.jpaQuery != null) {
            result = this.jpaOperations.executeUpdate(this.jpaQuery, parameterSource);
        } else if (this.nativeQuery != null) {
            result = this.jpaOperations.executeUpdateWithNativeQuery(this.nativeQuery, parameterSource);
        } else if (this.namedQuery != null) {
            result = this.jpaOperations.executeUpdateWithNamedQuery(this.namedQuery, parameterSource);
        } else if (PersistMode.PERSIST.equals((Object)this.persistMode)) {
            this.jpaOperations.persist(message.getPayload());
            result = message.getPayload();
        } else if (PersistMode.MERGE.equals((Object)this.persistMode)) {
            Object mergedEntity;
            result = mergedEntity = this.jpaOperations.merge(message.getPayload());
        } else if (PersistMode.DELETE.equals((Object)this.persistMode)) {
            this.jpaOperations.delete(message.getPayload());
            result = message.getPayload();
        } else {
            throw new IllegalStateException(String.format("Unsupported PersistMode: '%s'", this.persistMode.name()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object poll(Message<?> requestMessage) {
        void var2_7;
        List<?> result;
        if (requestMessage == null) {
            result = this.doPoll(this.parameterSource);
        } else {
            ParameterSource parameterSource = this.determineParameterSource(requestMessage);
            result = this.doPoll(parameterSource);
        }
        if (result.isEmpty()) {
            Object var2_4 = null;
        } else if (this.expectSingleResult) {
            if (result.size() != 1) throw new MessagingException(requestMessage, "The Jpa operation returned more than 1 result object but expectSingleResult was 'true'.");
            Object obj = result.iterator().next();
        } else {
            List<?> list = result;
        }
        if (var2_7 == null || !this.deleteAfterPoll) return var2_7;
        if (var2_7 instanceof Iterable) {
            if (this.deleteInBatch) {
                this.jpaOperations.deleteInBatch((Iterable)var2_7);
                return var2_7;
            } else {
                for (Object entity : (Iterable)var2_7) {
                    this.jpaOperations.delete(entity);
                }
            }
            return var2_7;
        } else {
            this.jpaOperations.delete(var2_7);
        }
        return var2_7;
    }

    private ParameterSource determineParameterSource(Message<?> requestMessage) {
        ParameterSource parameterSource = this.usePayloadAsParameterSource != false ? this.parameterSourceFactory.createParameterSource(requestMessage.getPayload()) : this.parameterSourceFactory.createParameterSource(requestMessage);
        return parameterSource;
    }

    public Object poll() {
        return this.poll(null);
    }

    protected List<?> doPoll(ParameterSource jpaQLParameterSource) {
        List<?> payload = null;
        if (this.jpaQuery != null) {
            payload = this.jpaOperations.getResultListForQuery(this.jpaQuery, jpaQLParameterSource, this.maxNumberOfResults);
        } else if (this.nativeQuery != null) {
            payload = this.jpaOperations.getResultListForNativeQuery(this.nativeQuery, this.entityClass, jpaQLParameterSource, this.maxNumberOfResults);
        } else if (this.namedQuery != null) {
            payload = this.jpaOperations.getResultListForNamedQuery(this.namedQuery, jpaQLParameterSource, this.maxNumberOfResults);
        } else if (this.entityClass != null) {
            payload = this.jpaOperations.getResultListForClass(this.entityClass, this.maxNumberOfResults);
        } else {
            throw new IllegalStateException("For the polling operation, one of the following properties must be specified: query, namedQuery or entityClass.");
        }
        return payload;
    }

    public void setEntityClass(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass must not be null.");
        this.entityClass = entityClass;
    }

    public void setJpaQuery(String jpaQuery) {
        Assert.isTrue((this.nativeQuery == null && this.namedQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)jpaQuery, (String)"jpaQuery must neither be null nor empty.");
        this.jpaQuery = jpaQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        Assert.isTrue((this.namedQuery == null && this.jpaQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)nativeQuery, (String)"nativeQuery must neither be null nor empty.");
        this.nativeQuery = nativeQuery;
    }

    public void setNamedQuery(String namedQuery) {
        Assert.isTrue((this.jpaQuery == null && this.nativeQuery == null ? 1 : 0) != 0, (String)"You can define only one of the properties 'jpaQuery', 'nativeQuery', 'namedQuery'");
        Assert.hasText((String)namedQuery, (String)"namedQuery must neither be null nor empty.");
        this.namedQuery = namedQuery;
    }

    public void setPersistMode(PersistMode persistMode) {
        this.persistMode = persistMode;
    }

    public void setJpaParameters(List<JpaParameter> jpaParameters) {
        this.jpaParameters = jpaParameters;
    }

    public void setUsePayloadAsParameterSource(Boolean usePayloadAsParameterSource) {
        this.usePayloadAsParameterSource = usePayloadAsParameterSource;
    }

    public void setDeleteInBatch(boolean deleteInBatch) {
        this.deleteInBatch = deleteInBatch;
    }

    public void setDeleteAfterPoll(boolean deleteAfterPoll) {
        this.deleteAfterPoll = deleteAfterPoll;
    }

    public void setParameterSourceFactory(ParameterSourceFactory parameterSourceFactory) {
        Assert.notNull((Object)parameterSourceFactory, (String)"parameterSourceFactory must not be null.");
        this.parameterSourceFactory = parameterSourceFactory;
    }

    public void setParameterSource(ParameterSource parameterSource) {
        Assert.notNull((Object)parameterSource, (String)"parameterSource must not be null.");
        this.parameterSource = parameterSource;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public void setMaxNumberOfResults(int maxNumberOfResults) {
        Assert.isTrue((maxNumberOfResults >= 0 ? 1 : 0) != 0, (String)"maxNumberOfResults must not be negative.");
        this.maxNumberOfResults = maxNumberOfResults;
    }
}

