/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSource;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSourceUtils;
import org.springframework.integration.jpa.support.parametersource.ParameterSourceFactory;
import org.springframework.integration.jpa.support.parametersource.PositionSupportingParameterSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluatingParameterSourceFactory
implements ParameterSourceFactory {
    private volatile List<JpaParameter> parameters;
    private ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator expressionEvaluator = new ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator();

    public ExpressionEvaluatingParameterSourceFactory() {
        this.parameters = Collections.unmodifiableList(new ArrayList());
    }

    public void setParameters(List<JpaParameter> parameters) {
        Assert.notEmpty(parameters, (String)"parameters must not be null or empty.");
        for (JpaParameter parameter : parameters) {
            Assert.notNull((Object)parameter, (String)"The provided list (parameters) cannot contain null values.");
        }
        this.parameters = parameters;
        this.expressionEvaluator.getEvaluationContext().setVariable("staticParameters", ExpressionEvaluatingParameterSourceUtils.convertStaticParameters(parameters));
    }

    @Override
    public PositionSupportingParameterSource createParameterSource(Object input) {
        return new ExpressionEvaluatingParameterSource(input, this.parameters, this.expressionEvaluator);
    }
}

