/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import lombok.Generated;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Origin;

final class LocalResponse
extends HttpServletResponseWrapper
implements HttpResponse {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final String protocolVersion;

    LocalResponse(HttpServletResponse response, String protocolVersion) {
        super(response);
        this.protocolVersion = protocolVersion;
    }

    public Origin getOrigin() {
        return Origin.LOCAL;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public HttpHeaders getHeaders() {
        HttpHeaders headers = HttpHeaders.empty();
        for (String header : this.getHeaderNames()) {
            headers = headers.update(header, this.getHeaders(header));
        }
        return headers;
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.getCharacterEncoding()).map(Charset::forName).orElse(StandardCharsets.UTF_8);
    }

    public HttpResponse withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpResponse withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.buffer().getOutputStream(this.getResponse());
    }

    public PrintWriter getWriter() throws IOException {
        return this.buffer().getWriter(this.getResponse(), this::getCharset);
    }

    public void flushBuffer() throws IOException {
        this.state.get().flush();
        super.flushBuffer();
    }

    public byte[] getBody() {
        return this.buffer().getBody();
    }

    private State buffer() {
        return this.state.updateAndGet((UnaryOperator<State>)FauxPas.throwingUnaryOperator(state -> state.buffer(this.getResponse())));
    }

    private static final class Unbuffered
    implements State {
        private Unbuffered() {
        }

        @Override
        public State with() {
            return new Offering();
        }
    }

    private static interface State {
        default public State with() {
            return this;
        }

        default public State without() {
            return this;
        }

        default public State buffer(ServletResponse response) throws IOException {
            return this;
        }

        default public ServletOutputStream getOutputStream(ServletResponse response) throws IOException {
            return response.getOutputStream();
        }

        default public PrintWriter getWriter(ServletResponse response, Supplier<Charset> charset) throws IOException {
            return response.getWriter();
        }

        default public void flush() throws IOException {
        }

        default public byte[] getBody() {
            return new byte[0];
        }
    }

    private static class TeeServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream original;
        private final OutputStream branch;

        public void write(int b) throws IOException {
            this.original.write(b);
            this.branch.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.original.write(b, off, len);
            this.branch.write(b, off, len);
        }

        public void flush() throws IOException {
            this.original.flush();
            this.branch.flush();
        }

        public void close() throws IOException {
            this.original.close();
            this.branch.close();
        }

        public boolean isReady() {
            return this.original.isReady();
        }

        public void setWriteListener(WriteListener listener) {
            this.original.setWriteListener(listener);
        }

        @Generated
        public TeeServletOutputStream(ServletOutputStream original, OutputStream branch) {
            this.original = original;
            this.branch = branch;
        }
    }

    private static class Tee {
        private final ByteArrayOutputStream branch = new ByteArrayOutputStream();
        private final TeeServletOutputStream output;
        private PrintWriter writer;
        private byte[] bytes;

        private Tee(ServletOutputStream original) {
            this.output = new TeeServletOutputStream(original, this.branch);
        }

        ServletOutputStream getOutputStream() {
            return this.output;
        }

        PrintWriter getWriter(Supplier<Charset> charset) {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.output), charset.get()));
            }
            return this.writer;
        }

        void flush() throws IOException {
            if (this.writer == null) {
                this.output.flush();
            } else {
                this.writer.flush();
            }
        }

        byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = this.branch.toByteArray();
            }
            return this.bytes;
        }
    }

    private static final class Ignoring
    extends Streaming {
        Ignoring(Tee tee) {
            super(tee);
        }

        @Override
        public State with() {
            return new Buffering(this.getTee());
        }
    }

    private static final class Buffering
    extends Streaming {
        Buffering(Tee tee) {
            super(tee);
        }

        @Override
        public State without() {
            return new Ignoring(this.getTee());
        }

        @Override
        public byte[] getBody() {
            return this.getTee().getBytes();
        }
    }

    private static abstract class Streaming
    implements State {
        private final Tee tee;

        @Override
        public ServletOutputStream getOutputStream(ServletResponse response) {
            return this.tee.getOutputStream();
        }

        @Override
        public PrintWriter getWriter(ServletResponse response, Supplier<Charset> charset) {
            return this.tee.getWriter(charset);
        }

        @Override
        public void flush() throws IOException {
            this.tee.flush();
        }

        @Generated
        public Streaming(Tee tee) {
            this.tee = tee;
        }

        @Generated
        protected Tee getTee() {
            return this.tee;
        }
    }

    private static final class Offering
    implements State {
        private Offering() {
        }

        @Override
        public State without() {
            return new Unbuffered();
        }

        @Override
        public State buffer(ServletResponse response) throws IOException {
            Tee tee = new Tee(response.getOutputStream());
            return new Buffering(tee);
        }
    }
}

