/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.MetricsStatus;
import com.amazonaws.s3.model.ReplicationTimeValue;
import java.util.Objects;

public class Metrics {
    MetricsStatus status;
    ReplicationTimeValue eventThreshold;

    Metrics() {
        this.status = null;
        this.eventThreshold = null;
    }

    protected Metrics(BuilderImpl builder) {
        this.status = builder.status;
        this.eventThreshold = builder.eventThreshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(Metrics.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof Metrics;
    }

    public MetricsStatus status() {
        return this.status;
    }

    public ReplicationTimeValue eventThreshold() {
        return this.eventThreshold;
    }

    protected static class BuilderImpl
    implements Builder {
        MetricsStatus status;
        ReplicationTimeValue eventThreshold;

        protected BuilderImpl() {
        }

        private BuilderImpl(Metrics model) {
            this.status(model.status);
            this.eventThreshold(model.eventThreshold);
        }

        @Override
        public Metrics build() {
            return new Metrics(this);
        }

        @Override
        public final Builder status(MetricsStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder eventThreshold(ReplicationTimeValue eventThreshold) {
            this.eventThreshold = eventThreshold;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public MetricsStatus status() {
            return this.status;
        }

        public ReplicationTimeValue eventThreshold() {
            return this.eventThreshold;
        }
    }

    public static interface Builder {
        public Builder status(MetricsStatus var1);

        public Builder eventThreshold(ReplicationTimeValue var1);

        public Metrics build();
    }
}

