/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class PutBucketPolicyRequest {
    String bucket;
    String contentMD5;
    Boolean confirmRemoveSelfBucketAccess;
    String policy;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    PutBucketPolicyRequest() {
        this.bucket = "";
        this.contentMD5 = "";
        this.confirmRemoveSelfBucketAccess = null;
        this.policy = "";
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected PutBucketPolicyRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.confirmRemoveSelfBucketAccess = builder.confirmRemoveSelfBucketAccess;
        this.policy = builder.policy;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutBucketPolicyRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutBucketPolicyRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public Boolean confirmRemoveSelfBucketAccess() {
        return this.confirmRemoveSelfBucketAccess;
    }

    public String policy() {
        return this.policy;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String contentMD5;
        Boolean confirmRemoveSelfBucketAccess;
        String policy;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutBucketPolicyRequest model) {
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.confirmRemoveSelfBucketAccess(model.confirmRemoveSelfBucketAccess);
            this.policy(model.policy);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public PutBucketPolicyRequest build() {
            return new PutBucketPolicyRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder confirmRemoveSelfBucketAccess(Boolean confirmRemoveSelfBucketAccess) {
            this.confirmRemoveSelfBucketAccess = confirmRemoveSelfBucketAccess;
            return this;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public Boolean confirmRemoveSelfBucketAccess() {
            return this.confirmRemoveSelfBucketAccess;
        }

        public String policy() {
            return this.policy;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder confirmRemoveSelfBucketAccess(Boolean var1);

        public Builder policy(String var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public PutBucketPolicyRequest build();
    }
}

