/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.pinpoint.model.CreateAppRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateAppResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteAppResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeletePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetAppsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetAppsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetChannelsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyDateRangeKpiResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionActivityMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyExecutionMetricsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.GetJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetPushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetRecommenderConfigurationsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentExportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetUserEndpointsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.GetVoiceTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysRequest;
import software.amazon.awssdk.services.pinpoint.model.ListJourneysResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesRequest;
import software.amazon.awssdk.services.pinpoint.model.ListTemplatesResponse;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateRequest;
import software.amazon.awssdk.services.pinpoint.model.PhoneNumberValidateResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.PutEventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventsResponse;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesRequest;
import software.amazon.awssdk.services.pinpoint.model.RemoveAttributesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.TagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceRequest;
import software.amazon.awssdk.services.pinpoint.model.UntagResourceResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateBaiduChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateRecommenderConfigurationResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsTemplateResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateTemplateActiveVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateVoiceTemplateResponse;

/**
 * Service client for accessing Amazon Pinpoint asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Doc Engage API - Amazon Pinpoint API
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface PinpointAsyncClient extends SdkClient {
    String SERVICE_NAME = "mobiletargeting";

    /**
     * Create a {@link PinpointAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PinpointAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PinpointAsyncClient}.
     */
    static PinpointAsyncClientBuilder builder() {
        return new DefaultPinpointAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppRequest#builder()}
     * </p>
     *
     * @param createAppRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppResponse> createApp(Consumer<CreateAppRequest.Builder> createAppRequest) {
        return createApp(CreateAppRequest.builder().applyMutation(createAppRequest).build());
    }

    /**
     * <p>
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     * </p>
     *
     * @param createCampaignRequest
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCampaignResponse> createCampaign(CreateCampaignRequest createCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new campaign for an application or updates the settings of an existing campaign for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCampaignRequest#builder()}
     * </p>
     *
     * @param createCampaignRequest
     *        A {@link Consumer} that will call methods on {@link CreateCampaignRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCampaignResponse> createCampaign(Consumer<CreateCampaignRequest.Builder> createCampaignRequest) {
        return createCampaign(CreateCampaignRequest.builder().applyMutation(createCampaignRequest).build());
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param createEmailTemplateRequest
     * @return A Java Future containing the result of the CreateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(
            CreateEmailTemplateRequest createEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the email channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailTemplateRequest#builder()}
     * </p>
     *
     * @param createEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateEmailTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEmailTemplateResponse> createEmailTemplate(
            Consumer<CreateEmailTemplateRequest.Builder> createEmailTemplateRequest) {
        return createEmailTemplate(CreateEmailTemplateRequest.builder().applyMutation(createEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Creates an export job for an application.
     * </p>
     *
     * @param createExportJobRequest
     * @return A Java Future containing the result of the CreateExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExportJobResponse> createExportJob(CreateExportJobRequest createExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an export job for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExportJobRequest#builder()}
     * </p>
     *
     * @param createExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateExportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateExportJobResponse> createExportJob(
            Consumer<CreateExportJobRequest.Builder> createExportJobRequest) {
        return createExportJob(CreateExportJobRequest.builder().applyMutation(createExportJobRequest).build());
    }

    /**
     * <p>
     * Creates an import job for an application.
     * </p>
     *
     * @param createImportJobRequest
     * @return A Java Future containing the result of the CreateImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImportJobResponse> createImportJob(CreateImportJobRequest createImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an import job for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImportJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateImportJobRequest#builder()}
     * </p>
     *
     * @param createImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateImportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImportJobResponse> createImportJob(
            Consumer<CreateImportJobRequest.Builder> createImportJobRequest) {
        return createImportJob(CreateImportJobRequest.builder().applyMutation(createImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a journey for an application.
     * </p>
     *
     * @param createJourneyRequest
     * @return A Java Future containing the result of the CreateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJourneyResponse> createJourney(CreateJourneyRequest createJourneyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a journey for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJourneyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJourneyRequest#builder()}
     * </p>
     *
     * @param createJourneyRequest
     *        A {@link Consumer} that will call methods on {@link CreateJourneyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateJourneyResponse> createJourney(Consumer<CreateJourneyRequest.Builder> createJourneyRequest) {
        return createJourney(CreateJourneyRequest.builder().applyMutation(createJourneyRequest).build());
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param createPushTemplateRequest
     * @return A Java Future containing the result of the CreatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePushTemplateResponse> createPushTemplate(CreatePushTemplateRequest createPushTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through a push notification channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePushTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePushTemplateRequest#builder()}
     * </p>
     *
     * @param createPushTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreatePushTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePushTemplateResponse> createPushTemplate(
            Consumer<CreatePushTemplateRequest.Builder> createPushTemplateRequest) {
        return createPushTemplate(CreatePushTemplateRequest.builder().applyMutation(createPushTemplateRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param createRecommenderConfigurationRequest
     * @return A Java Future containing the result of the CreateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRecommenderConfigurationResponse> createRecommenderConfiguration(
            CreateRecommenderConfigurationRequest createRecommenderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRecommenderConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRecommenderConfigurationRequest#builder()}
     * </p>
     *
     * @param createRecommenderConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link CreateRecommenderConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRecommenderConfigurationResponse> createRecommenderConfiguration(
            Consumer<CreateRecommenderConfigurationRequest.Builder> createRecommenderConfigurationRequest) {
        return createRecommenderConfiguration(CreateRecommenderConfigurationRequest.builder()
                .applyMutation(createRecommenderConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param createSegmentRequest
     * @return A Java Future containing the result of the CreateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSegmentResponse> createSegment(CreateSegmentRequest createSegmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSegmentRequest#builder()}
     * </p>
     *
     * @param createSegmentRequest
     *        A {@link Consumer} that will call methods on {@link CreateSegmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSegmentResponse> createSegment(Consumer<CreateSegmentRequest.Builder> createSegmentRequest) {
        return createSegment(CreateSegmentRequest.builder().applyMutation(createSegmentRequest).build());
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param createSmsTemplateRequest
     * @return A Java Future containing the result of the CreateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSmsTemplateResponse> createSmsTemplate(CreateSmsTemplateRequest createSmsTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the SMS channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSmsTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link CreateSmsTemplateRequest#builder()}
     * </p>
     *
     * @param createSmsTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateSmsTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSmsTemplateResponse> createSmsTemplate(
            Consumer<CreateSmsTemplateRequest.Builder> createSmsTemplateRequest) {
        return createSmsTemplate(CreateSmsTemplateRequest.builder().applyMutation(createSmsTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param createVoiceTemplateRequest
     * @return A Java Future containing the result of the CreateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVoiceTemplateResponse> createVoiceTemplate(
            CreateVoiceTemplateRequest createVoiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a message template for messages that are sent through the voice channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVoiceTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVoiceTemplateRequest#builder()}
     * </p>
     *
     * @param createVoiceTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateVoiceTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.CreateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVoiceTemplateResponse> createVoiceTemplate(
            Consumer<CreateVoiceTemplateRequest.Builder> createVoiceTemplateRequest) {
        return createVoiceTemplate(CreateVoiceTemplateRequest.builder().applyMutation(createVoiceTemplateRequest).build());
    }

    /**
     * <p>
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteAdmChannelRequest
     * @return A Java Future containing the result of the DeleteAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAdmChannelResponse> deleteAdmChannel(DeleteAdmChannelRequest deleteAdmChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the ADM channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAdmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAdmChannelRequest#builder()}
     * </p>
     *
     * @param deleteAdmChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAdmChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAdmChannelResponse> deleteAdmChannel(
            Consumer<DeleteAdmChannelRequest.Builder> deleteAdmChannelRequest) {
        return deleteAdmChannel(DeleteAdmChannelRequest.builder().applyMutation(deleteAdmChannelRequest).build());
    }

    /**
     * <p>
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsChannelRequest
     * @return A Java Future containing the result of the DeleteApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApnsChannelResponse> deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the APNs channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApnsChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteApnsChannelResponse> deleteApnsChannel(
            Consumer<DeleteApnsChannelRequest.Builder> deleteApnsChannelRequest) {
        return deleteApnsChannel(DeleteApnsChannelRequest.builder().applyMutation(deleteApnsChannelRequest).build());
    }

    /**
     * <p>
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsSandboxChannelRequest
     * @return A Java Future containing the result of the DeleteApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApnsSandboxChannelResponse> deleteApnsSandboxChannel(
            DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsSandboxChannelRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteApnsSandboxChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsSandboxChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApnsSandboxChannelResponse> deleteApnsSandboxChannel(
            Consumer<DeleteApnsSandboxChannelRequest.Builder> deleteApnsSandboxChannelRequest) {
        return deleteApnsSandboxChannel(DeleteApnsSandboxChannelRequest.builder().applyMutation(deleteApnsSandboxChannelRequest)
                .build());
    }

    /**
     * <p>
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipChannelRequest
     * @return A Java Future containing the result of the DeleteApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApnsVoipChannelResponse> deleteApnsVoipChannel(
            DeleteApnsVoipChannelRequest deleteApnsVoipChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsVoipChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteApnsVoipChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsVoipChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsVoipChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApnsVoipChannelResponse> deleteApnsVoipChannel(
            Consumer<DeleteApnsVoipChannelRequest.Builder> deleteApnsVoipChannelRequest) {
        return deleteApnsVoipChannel(DeleteApnsVoipChannelRequest.builder().applyMutation(deleteApnsVoipChannelRequest).build());
    }

    /**
     * <p>
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the DeleteApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApnsVoipSandboxChannelResponse> deleteApnsVoipSandboxChannel(
            DeleteApnsVoipSandboxChannelRequest deleteApnsVoipSandboxChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApnsVoipSandboxChannelRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteApnsVoipSandboxChannelRequest#builder()}
     * </p>
     *
     * @param deleteApnsVoipSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApnsVoipSandboxChannelRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteApnsVoipSandboxChannelResponse> deleteApnsVoipSandboxChannel(
            Consumer<DeleteApnsVoipSandboxChannelRequest.Builder> deleteApnsVoipSandboxChannelRequest) {
        return deleteApnsVoipSandboxChannel(DeleteApnsVoipSandboxChannelRequest.builder()
                .applyMutation(deleteApnsVoipSandboxChannelRequest).build());
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteBaiduChannelRequest
     * @return A Java Future containing the result of the DeleteBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBaiduChannelResponse> deleteBaiduChannel(DeleteBaiduChannelRequest deleteBaiduChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the Baidu channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBaiduChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBaiduChannelRequest#builder()}
     * </p>
     *
     * @param deleteBaiduChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBaiduChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBaiduChannelResponse> deleteBaiduChannel(
            Consumer<DeleteBaiduChannelRequest.Builder> deleteBaiduChannelRequest) {
        return deleteBaiduChannel(DeleteBaiduChannelRequest.builder().applyMutation(deleteBaiduChannelRequest).build());
    }

    /**
     * <p>
     * Deletes a campaign from an application.
     * </p>
     *
     * @param deleteCampaignRequest
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCampaignResponse> deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a campaign from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteCampaignRequest#builder()}
     * </p>
     *
     * @param deleteCampaignRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCampaignRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCampaignResponse> deleteCampaign(Consumer<DeleteCampaignRequest.Builder> deleteCampaignRequest) {
        return deleteCampaign(DeleteCampaignRequest.builder().applyMutation(deleteCampaignRequest).build());
    }

    /**
     * <p>
     * Disables the email channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteEmailChannelRequest
     * @return A Java Future containing the result of the DeleteEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEmailChannelResponse> deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the email channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailChannelRequest#builder()}
     * </p>
     *
     * @param deleteEmailChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEmailChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEmailChannelResponse> deleteEmailChannel(
            Consumer<DeleteEmailChannelRequest.Builder> deleteEmailChannelRequest) {
        return deleteEmailChannel(DeleteEmailChannelRequest.builder().applyMutation(deleteEmailChannelRequest).build());
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the email channel.
     * </p>
     *
     * @param deleteEmailTemplateRequest
     * @return A Java Future containing the result of the DeleteEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(
            DeleteEmailTemplateRequest deleteEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the email channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailTemplateRequest#builder()}
     * </p>
     *
     * @param deleteEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEmailTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEmailTemplateResponse> deleteEmailTemplate(
            Consumer<DeleteEmailTemplateRequest.Builder> deleteEmailTemplateRequest) {
        return deleteEmailTemplate(DeleteEmailTemplateRequest.builder().applyMutation(deleteEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes an endpoint from an application.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes the event stream for an application.
     * </p>
     *
     * @param deleteEventStreamRequest
     * @return A Java Future containing the result of the DeleteEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventStreamResponse> deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the event stream for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventStreamRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventStreamRequest#builder()}
     * </p>
     *
     * @param deleteEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventStreamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteEventStream" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventStreamResponse> deleteEventStream(
            Consumer<DeleteEventStreamRequest.Builder> deleteEventStreamRequest) {
        return deleteEventStream(DeleteEventStreamRequest.builder().applyMutation(deleteEventStreamRequest).build());
    }

    /**
     * <p>
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteGcmChannelRequest
     * @return A Java Future containing the result of the DeleteGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGcmChannelResponse> deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the GCM channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGcmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteGcmChannelRequest#builder()}
     * </p>
     *
     * @param deleteGcmChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGcmChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGcmChannelResponse> deleteGcmChannel(
            Consumer<DeleteGcmChannelRequest.Builder> deleteGcmChannelRequest) {
        return deleteGcmChannel(DeleteGcmChannelRequest.builder().applyMutation(deleteGcmChannelRequest).build());
    }

    /**
     * <p>
     * Deletes a journey from an application.
     * </p>
     *
     * @param deleteJourneyRequest
     * @return A Java Future containing the result of the DeleteJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJourneyResponse> deleteJourney(DeleteJourneyRequest deleteJourneyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a journey from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJourneyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJourneyRequest#builder()}
     * </p>
     *
     * @param deleteJourneyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJourneyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJourneyResponse> deleteJourney(Consumer<DeleteJourneyRequest.Builder> deleteJourneyRequest) {
        return deleteJourney(DeleteJourneyRequest.builder().applyMutation(deleteJourneyRequest).build());
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through a push notification channel.
     * </p>
     *
     * @param deletePushTemplateRequest
     * @return A Java Future containing the result of the DeletePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeletePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePushTemplateResponse> deletePushTemplate(DeletePushTemplateRequest deletePushTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through a push notification channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePushTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePushTemplateRequest#builder()}
     * </p>
     *
     * @param deletePushTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeletePushTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeletePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeletePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePushTemplateResponse> deletePushTemplate(
            Consumer<DeletePushTemplateRequest.Builder> deletePushTemplateRequest) {
        return deletePushTemplate(DeletePushTemplateRequest.builder().applyMutation(deletePushTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param deleteRecommenderConfigurationRequest
     * @return A Java Future containing the result of the DeleteRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecommenderConfigurationResponse> deleteRecommenderConfiguration(
            DeleteRecommenderConfigurationRequest deleteRecommenderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Pinpoint configuration for a recommender model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRecommenderConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteRecommenderConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteRecommenderConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRecommenderConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteRecommenderConfigurationResponse> deleteRecommenderConfiguration(
            Consumer<DeleteRecommenderConfigurationRequest.Builder> deleteRecommenderConfigurationRequest) {
        return deleteRecommenderConfiguration(DeleteRecommenderConfigurationRequest.builder()
                .applyMutation(deleteRecommenderConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a segment from an application.
     * </p>
     *
     * @param deleteSegmentRequest
     * @return A Java Future containing the result of the DeleteSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSegmentResponse> deleteSegment(DeleteSegmentRequest deleteSegmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a segment from an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSegmentRequest#builder()}
     * </p>
     *
     * @param deleteSegmentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSegmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSegmentResponse> deleteSegment(Consumer<DeleteSegmentRequest.Builder> deleteSegmentRequest) {
        return deleteSegment(DeleteSegmentRequest.builder().applyMutation(deleteSegmentRequest).build());
    }

    /**
     * <p>
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteSmsChannelRequest
     * @return A Java Future containing the result of the DeleteSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSmsChannelResponse> deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the SMS channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSmsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSmsChannelRequest#builder()}
     * </p>
     *
     * @param deleteSmsChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSmsChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSmsChannelResponse> deleteSmsChannel(
            Consumer<DeleteSmsChannelRequest.Builder> deleteSmsChannelRequest) {
        return deleteSmsChannel(DeleteSmsChannelRequest.builder().applyMutation(deleteSmsChannelRequest).build());
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the SMS channel.
     * </p>
     *
     * @param deleteSmsTemplateRequest
     * @return A Java Future containing the result of the DeleteSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSmsTemplateResponse> deleteSmsTemplate(DeleteSmsTemplateRequest deleteSmsTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the SMS channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSmsTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSmsTemplateRequest#builder()}
     * </p>
     *
     * @param deleteSmsTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSmsTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSmsTemplateResponse> deleteSmsTemplate(
            Consumer<DeleteSmsTemplateRequest.Builder> deleteSmsTemplateRequest) {
        return deleteSmsTemplate(DeleteSmsTemplateRequest.builder().applyMutation(deleteSmsTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param deleteUserEndpointsRequest
     * @return A Java Future containing the result of the DeleteUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserEndpointsResponse> deleteUserEndpoints(
            DeleteUserEndpointsRequest deleteUserEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all the endpoints that are associated with a specific user ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserEndpointsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserEndpointsRequest#builder()}
     * </p>
     *
     * @param deleteUserEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserEndpointsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteUserEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserEndpointsResponse> deleteUserEndpoints(
            Consumer<DeleteUserEndpointsRequest.Builder> deleteUserEndpointsRequest) {
        return deleteUserEndpoints(DeleteUserEndpointsRequest.builder().applyMutation(deleteUserEndpointsRequest).build());
    }

    /**
     * <p>
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     * </p>
     *
     * @param deleteVoiceChannelRequest
     * @return A Java Future containing the result of the DeleteVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceChannelResponse> deleteVoiceChannel(DeleteVoiceChannelRequest deleteVoiceChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the voice channel for an application and deletes any existing settings for the channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceChannelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVoiceChannelRequest#builder()}
     * </p>
     *
     * @param deleteVoiceChannelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceChannelResponse> deleteVoiceChannel(
            Consumer<DeleteVoiceChannelRequest.Builder> deleteVoiceChannelRequest) {
        return deleteVoiceChannel(DeleteVoiceChannelRequest.builder().applyMutation(deleteVoiceChannelRequest).build());
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the voice channel.
     * </p>
     *
     * @param deleteVoiceTemplateRequest
     * @return A Java Future containing the result of the DeleteVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceTemplateResponse> deleteVoiceTemplate(
            DeleteVoiceTemplateRequest deleteVoiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a message template for messages that were sent through the voice channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVoiceTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVoiceTemplateRequest#builder()}
     * </p>
     *
     * @param deleteVoiceTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVoiceTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.DeleteVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/DeleteVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVoiceTemplateResponse> deleteVoiceTemplate(
            Consumer<DeleteVoiceTemplateRequest.Builder> deleteVoiceTemplateRequest) {
        return deleteVoiceTemplate(DeleteVoiceTemplateRequest.builder().applyMutation(deleteVoiceTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the ADM channel for an application.
     * </p>
     *
     * @param getAdmChannelRequest
     * @return A Java Future containing the result of the GetAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAdmChannelResponse> getAdmChannel(GetAdmChannelRequest getAdmChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the ADM channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdmChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetAdmChannelRequest#builder()}
     * </p>
     *
     * @param getAdmChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetAdmChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAdmChannelResponse> getAdmChannel(Consumer<GetAdmChannelRequest.Builder> getAdmChannelRequest) {
        return getAdmChannel(GetAdmChannelRequest.builder().applyMutation(getAdmChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs channel for an application.
     * </p>
     *
     * @param getApnsChannelRequest
     * @return A Java Future containing the result of the GetApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApnsChannelResponse> getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetApnsChannelRequest#builder()}
     * </p>
     *
     * @param getApnsChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetApnsChannelResponse> getApnsChannel(Consumer<GetApnsChannelRequest.Builder> getApnsChannelRequest) {
        return getApnsChannel(GetApnsChannelRequest.builder().applyMutation(getApnsChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     * </p>
     *
     * @param getApnsSandboxChannelRequest
     * @return A Java Future containing the result of the GetApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApnsSandboxChannelResponse> getApnsSandboxChannel(
            GetApnsSandboxChannelRequest getApnsSandboxChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs sandbox channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsSandboxChannelRequest.Builder} avoiding the
     * need to create one manually via {@link GetApnsSandboxChannelRequest#builder()}
     * </p>
     *
     * @param getApnsSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsSandboxChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApnsSandboxChannelResponse> getApnsSandboxChannel(
            Consumer<GetApnsSandboxChannelRequest.Builder> getApnsSandboxChannelRequest) {
        return getApnsSandboxChannel(GetApnsSandboxChannelRequest.builder().applyMutation(getApnsSandboxChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     * </p>
     *
     * @param getApnsVoipChannelRequest
     * @return A Java Future containing the result of the GetApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApnsVoipChannelResponse> getApnsVoipChannel(GetApnsVoipChannelRequest getApnsVoipChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsVoipChannelRequest.Builder} avoiding the
     * need to create one manually via {@link GetApnsVoipChannelRequest#builder()}
     * </p>
     *
     * @param getApnsVoipChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsVoipChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApnsVoipChannelResponse> getApnsVoipChannel(
            Consumer<GetApnsVoipChannelRequest.Builder> getApnsVoipChannelRequest) {
        return getApnsVoipChannel(GetApnsVoipChannelRequest.builder().applyMutation(getApnsVoipChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     * </p>
     *
     * @param getApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the GetApnsVoipSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApnsVoipSandboxChannelResponse> getApnsVoipSandboxChannel(
            GetApnsVoipSandboxChannelRequest getApnsVoipSandboxChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApnsVoipSandboxChannelRequest.Builder} avoiding
     * the need to create one manually via {@link GetApnsVoipSandboxChannelRequest#builder()}
     * </p>
     *
     * @param getApnsVoipSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetApnsVoipSandboxChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApnsVoipSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApnsVoipSandboxChannelResponse> getApnsVoipSandboxChannel(
            Consumer<GetApnsVoipSandboxChannelRequest.Builder> getApnsVoipSandboxChannelRequest) {
        return getApnsVoipSandboxChannel(GetApnsVoipSandboxChannelRequest.builder()
                .applyMutation(getApnsVoipSandboxChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     *
     * @param getAppRequest
     * @return A Java Future containing the result of the GetApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppResponse> getApp(GetAppRequest getAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppRequest.Builder} avoiding the need to create
     * one manually via {@link GetAppRequest#builder()}
     * </p>
     *
     * @param getAppRequest
     *        A {@link Consumer} that will call methods on {@link GetAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppResponse> getApp(Consumer<GetAppRequest.Builder> getAppRequest) {
        return getApp(GetAppRequest.builder().applyMutation(getAppRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     * </p>
     *
     * @param getApplicationDateRangeKpiRequest
     * @return A Java Future containing the result of the GetApplicationDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationDateRangeKpiResponse> getApplicationDateRangeKpi(
            GetApplicationDateRangeKpiRequest getApplicationDateRangeKpiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationDateRangeKpiRequest.Builder} avoiding
     * the need to create one manually via {@link GetApplicationDateRangeKpiRequest#builder()}
     * </p>
     *
     * @param getApplicationDateRangeKpiRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationDateRangeKpiRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApplicationDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationDateRangeKpiResponse> getApplicationDateRangeKpi(
            Consumer<GetApplicationDateRangeKpiRequest.Builder> getApplicationDateRangeKpiRequest) {
        return getApplicationDateRangeKpi(GetApplicationDateRangeKpiRequest.builder()
                .applyMutation(getApplicationDateRangeKpiRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the settings for an application.
     * </p>
     *
     * @param getApplicationSettingsRequest
     * @return A Java Future containing the result of the GetApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationSettingsResponse> getApplicationSettings(
            GetApplicationSettingsRequest getApplicationSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the settings for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationSettingsRequest#builder()}
     * </p>
     *
     * @param getApplicationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationSettingsResponse> getApplicationSettings(
            Consumer<GetApplicationSettingsRequest.Builder> getApplicationSettingsRequest) {
        return getApplicationSettings(GetApplicationSettingsRequest.builder().applyMutation(getApplicationSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param getAppsRequest
     * @return A Java Future containing the result of the GetApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppsResponse> getApps(GetAppsRequest getAppsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all the applications that are associated with your Amazon Pinpoint account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAppsRequest.Builder} avoiding the need to create
     * one manually via {@link GetAppsRequest#builder()}
     * </p>
     *
     * @param getAppsRequest
     *        A {@link Consumer} that will call methods on {@link GetAppsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAppsResponse> getApps(Consumer<GetAppsRequest.Builder> getAppsRequest) {
        return getApps(GetAppsRequest.builder().applyMutation(getAppsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the Baidu channel for an application.
     * </p>
     *
     * @param getBaiduChannelRequest
     * @return A Java Future containing the result of the GetBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBaiduChannelResponse> getBaiduChannel(GetBaiduChannelRequest getBaiduChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the Baidu channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBaiduChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetBaiduChannelRequest#builder()}
     * </p>
     *
     * @param getBaiduChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetBaiduChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetBaiduChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBaiduChannelResponse> getBaiduChannel(
            Consumer<GetBaiduChannelRequest.Builder> getBaiduChannelRequest) {
        return getBaiduChannel(GetBaiduChannelRequest.builder().applyMutation(getBaiduChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a campaign.
     * </p>
     *
     * @param getCampaignRequest
     * @return A Java Future containing the result of the GetCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCampaignResponse> getCampaign(GetCampaignRequest getCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link GetCampaignRequest#builder()}
     * </p>
     *
     * @param getCampaignRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCampaignResponse> getCampaign(Consumer<GetCampaignRequest.Builder> getCampaignRequest) {
        return getCampaign(GetCampaignRequest.builder().applyMutation(getCampaignRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all the activities for a campaign.
     * </p>
     *
     * @param getCampaignActivitiesRequest
     * @return A Java Future containing the result of the GetCampaignActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignActivitiesResponse> getCampaignActivities(
            GetCampaignActivitiesRequest getCampaignActivitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all the activities for a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignActivitiesRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignActivitiesRequest#builder()}
     * </p>
     *
     * @param getCampaignActivitiesRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignActivitiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCampaignActivities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignActivities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignActivitiesResponse> getCampaignActivities(
            Consumer<GetCampaignActivitiesRequest.Builder> getCampaignActivitiesRequest) {
        return getCampaignActivities(GetCampaignActivitiesRequest.builder().applyMutation(getCampaignActivitiesRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     * </p>
     *
     * @param getCampaignDateRangeKpiRequest
     * @return A Java Future containing the result of the GetCampaignDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignDateRangeKpiResponse> getCampaignDateRangeKpi(
            GetCampaignDateRangeKpiRequest getCampaignDateRangeKpiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignDateRangeKpiRequest.Builder} avoiding
     * the need to create one manually via {@link GetCampaignDateRangeKpiRequest#builder()}
     * </p>
     *
     * @param getCampaignDateRangeKpiRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignDateRangeKpiRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCampaignDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCampaignDateRangeKpiResponse> getCampaignDateRangeKpi(
            Consumer<GetCampaignDateRangeKpiRequest.Builder> getCampaignDateRangeKpiRequest) {
        return getCampaignDateRangeKpi(GetCampaignDateRangeKpiRequest.builder().applyMutation(getCampaignDateRangeKpiRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     * </p>
     *
     * @param getCampaignVersionRequest
     * @return A Java Future containing the result of the GetCampaignVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCampaignVersionResponse> getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a specific version of a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignVersionRequest#builder()}
     * </p>
     *
     * @param getCampaignVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCampaignVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCampaignVersionResponse> getCampaignVersion(
            Consumer<GetCampaignVersionRequest.Builder> getCampaignVersionRequest) {
        return getCampaignVersion(GetCampaignVersionRequest.builder().applyMutation(getCampaignVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     * </p>
     *
     * @param getCampaignVersionsRequest
     * @return A Java Future containing the result of the GetCampaignVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCampaignVersionsResponse> getCampaignVersions(
            GetCampaignVersionsRequest getCampaignVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all versions of a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetCampaignVersionsRequest#builder()}
     * </p>
     *
     * @param getCampaignVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCampaignVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaignVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaignVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetCampaignVersionsResponse> getCampaignVersions(
            Consumer<GetCampaignVersionsRequest.Builder> getCampaignVersionsRequest) {
        return getCampaignVersions(GetCampaignVersionsRequest.builder().applyMutation(getCampaignVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are
     * associated with an application.
     * </p>
     *
     * @param getCampaignsRequest
     * @return A Java Future containing the result of the GetCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCampaignsResponse> getCampaigns(GetCampaignsRequest getCampaignsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the campaigns that are
     * associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCampaignsRequest.Builder} avoiding the need to
     * create one manually via {@link GetCampaignsRequest#builder()}
     * </p>
     *
     * @param getCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link GetCampaignsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCampaigns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetCampaigns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetCampaigns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCampaignsResponse> getCampaigns(Consumer<GetCampaignsRequest.Builder> getCampaignsRequest) {
        return getCampaigns(GetCampaignsRequest.builder().applyMutation(getCampaignsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the history and status of each channel for an application.
     * </p>
     *
     * @param getChannelsRequest
     * @return A Java Future containing the result of the GetChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelsResponse> getChannels(GetChannelsRequest getChannelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the history and status of each channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetChannelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetChannelsRequest#builder()}
     * </p>
     *
     * @param getChannelsRequest
     *        A {@link Consumer} that will call methods on {@link GetChannelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetChannels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetChannelsResponse> getChannels(Consumer<GetChannelsRequest.Builder> getChannelsRequest) {
        return getChannels(GetChannelsRequest.builder().applyMutation(getChannelsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the email channel for an application.
     * </p>
     *
     * @param getEmailChannelRequest
     * @return A Java Future containing the result of the GetEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailChannelResponse> getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the email channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailChannelRequest#builder()}
     * </p>
     *
     * @param getEmailChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetEmailChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailChannelResponse> getEmailChannel(
            Consumer<GetEmailChannelRequest.Builder> getEmailChannelRequest) {
        return getEmailChannel(GetEmailChannelRequest.builder().applyMutation(getEmailChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     * </p>
     *
     * @param getEmailTemplateRequest
     * @return A Java Future containing the result of the GetEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(GetEmailTemplateRequest getEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the email channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailTemplateRequest#builder()}
     * </p>
     *
     * @param getEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetEmailTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEmailTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailTemplateResponse> getEmailTemplate(
            Consumer<GetEmailTemplateRequest.Builder> getEmailTemplateRequest) {
        return getEmailTemplate(GetEmailTemplateRequest.builder().applyMutation(getEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     * </p>
     *
     * @param getEndpointRequest
     * @return A Java Future containing the result of the GetEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEndpointResponse> getEndpoint(GetEndpointRequest getEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the settings and attributes of a specific endpoint for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetEndpointRequest#builder()}
     * </p>
     *
     * @param getEndpointRequest
     *        A {@link Consumer} that will call methods on {@link GetEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEndpointResponse> getEndpoint(Consumer<GetEndpointRequest.Builder> getEndpointRequest) {
        return getEndpoint(GetEndpointRequest.builder().applyMutation(getEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the event stream settings for an application.
     * </p>
     *
     * @param getEventStreamRequest
     * @return A Java Future containing the result of the GetEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEventStreamResponse> getEventStream(GetEventStreamRequest getEventStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the event stream settings for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventStreamRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventStreamRequest#builder()}
     * </p>
     *
     * @param getEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link GetEventStreamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEventStreamResponse> getEventStream(Consumer<GetEventStreamRequest.Builder> getEventStreamRequest) {
        return getEventStream(GetEventStreamRequest.builder().applyMutation(getEventStreamRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific export job for an application.
     * </p>
     *
     * @param getExportJobRequest
     * @return A Java Future containing the result of the GetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExportJobResponse> getExportJob(GetExportJobRequest getExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific export job for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportJobRequest#builder()}
     * </p>
     *
     * @param getExportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetExportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExportJobResponse> getExportJob(Consumer<GetExportJobRequest.Builder> getExportJobRequest) {
        return getExportJob(GetExportJobRequest.builder().applyMutation(getExportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the export jobs for an application.
     * </p>
     *
     * @param getExportJobsRequest
     * @return A Java Future containing the result of the GetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExportJobsResponse> getExportJobs(GetExportJobsRequest getExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the export jobs for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link GetExportJobsRequest#builder()}
     * </p>
     *
     * @param getExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetExportJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetExportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetExportJobsResponse> getExportJobs(Consumer<GetExportJobsRequest.Builder> getExportJobsRequest) {
        return getExportJobs(GetExportJobsRequest.builder().applyMutation(getExportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the GCM channel for an application.
     * </p>
     *
     * @param getGcmChannelRequest
     * @return A Java Future containing the result of the GetGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGcmChannelResponse> getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the GCM channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGcmChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetGcmChannelRequest#builder()}
     * </p>
     *
     * @param getGcmChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetGcmChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGcmChannelResponse> getGcmChannel(Consumer<GetGcmChannelRequest.Builder> getGcmChannelRequest) {
        return getGcmChannel(GetGcmChannelRequest.builder().applyMutation(getGcmChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific import job for an application.
     * </p>
     *
     * @param getImportJobRequest
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobResponse> getImportJob(GetImportJobRequest getImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of a specific import job for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobRequest#builder()}
     * </p>
     *
     * @param getImportJobRequest
     *        A {@link Consumer} that will call methods on {@link GetImportJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobResponse> getImportJob(Consumer<GetImportJobRequest.Builder> getImportJobRequest) {
        return getImportJob(GetImportJobRequest.builder().applyMutation(getImportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the import jobs for an application.
     * </p>
     *
     * @param getImportJobsRequest
     * @return A Java Future containing the result of the GetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobsResponse> getImportJobs(GetImportJobsRequest getImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of all the import jobs for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportJobsRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportJobsRequest#builder()}
     * </p>
     *
     * @param getImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetImportJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetImportJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetImportJobsResponse> getImportJobs(Consumer<GetImportJobsRequest.Builder> getImportJobsRequest) {
        return getImportJobs(GetImportJobsRequest.builder().applyMutation(getImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a journey.
     * </p>
     *
     * @param getJourneyRequest
     * @return A Java Future containing the result of the GetJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJourneyResponse> getJourney(GetJourneyRequest getJourneyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for a journey.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJourneyRequest.Builder} avoiding the need to
     * create one manually via {@link GetJourneyRequest#builder()}
     * </p>
     *
     * @param getJourneyRequest
     *        A {@link Consumer} that will call methods on {@link GetJourneyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetJourneyResponse> getJourney(Consumer<GetJourneyRequest.Builder> getJourneyRequest) {
        return getJourney(GetJourneyRequest.builder().applyMutation(getJourneyRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     * </p>
     *
     * @param getJourneyDateRangeKpiRequest
     * @return A Java Future containing the result of the GetJourneyDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetJourneyDateRangeKpiResponse> getJourneyDateRangeKpi(
            GetJourneyDateRangeKpiRequest getJourneyDateRangeKpiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJourneyDateRangeKpiRequest.Builder} avoiding the
     * need to create one manually via {@link GetJourneyDateRangeKpiRequest#builder()}
     * </p>
     *
     * @param getJourneyDateRangeKpiRequest
     *        A {@link Consumer} that will call methods on {@link GetJourneyDateRangeKpiRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetJourneyDateRangeKpi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyDateRangeKpi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyDateRangeKpi"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetJourneyDateRangeKpiResponse> getJourneyDateRangeKpi(
            Consumer<GetJourneyDateRangeKpiRequest.Builder> getJourneyDateRangeKpiRequest) {
        return getJourneyDateRangeKpi(GetJourneyDateRangeKpiRequest.builder().applyMutation(getJourneyDateRangeKpiRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     * </p>
     *
     * @param getJourneyExecutionActivityMetricsRequest
     * @return A Java Future containing the result of the GetJourneyExecutionActivityMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionActivityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetJourneyExecutionActivityMetricsResponse> getJourneyExecutionActivityMetrics(
            GetJourneyExecutionActivityMetricsRequest getJourneyExecutionActivityMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJourneyExecutionActivityMetricsRequest.Builder}
     * avoiding the need to create one manually via {@link GetJourneyExecutionActivityMetricsRequest#builder()}
     * </p>
     *
     * @param getJourneyExecutionActivityMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetJourneyExecutionActivityMetricsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetJourneyExecutionActivityMetrics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionActivityMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionActivityMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetJourneyExecutionActivityMetricsResponse> getJourneyExecutionActivityMetrics(
            Consumer<GetJourneyExecutionActivityMetricsRequest.Builder> getJourneyExecutionActivityMetricsRequest) {
        return getJourneyExecutionActivityMetrics(GetJourneyExecutionActivityMetricsRequest.builder()
                .applyMutation(getJourneyExecutionActivityMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     * </p>
     *
     * @param getJourneyExecutionMetricsRequest
     * @return A Java Future containing the result of the GetJourneyExecutionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetJourneyExecutionMetricsResponse> getJourneyExecutionMetrics(
            GetJourneyExecutionMetricsRequest getJourneyExecutionMetricsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJourneyExecutionMetricsRequest.Builder} avoiding
     * the need to create one manually via {@link GetJourneyExecutionMetricsRequest#builder()}
     * </p>
     *
     * @param getJourneyExecutionMetricsRequest
     *        A {@link Consumer} that will call methods on {@link GetJourneyExecutionMetricsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetJourneyExecutionMetrics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetJourneyExecutionMetrics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetJourneyExecutionMetrics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetJourneyExecutionMetricsResponse> getJourneyExecutionMetrics(
            Consumer<GetJourneyExecutionMetricsRequest.Builder> getJourneyExecutionMetricsRequest) {
        return getJourneyExecutionMetrics(GetJourneyExecutionMetricsRequest.builder()
                .applyMutation(getJourneyExecutionMetricsRequest).build());
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through a push notification
     * channel.
     * </p>
     *
     * @param getPushTemplateRequest
     * @return A Java Future containing the result of the GetPushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetPushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetPushTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPushTemplateResponse> getPushTemplate(GetPushTemplateRequest getPushTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through a push notification
     * channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPushTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetPushTemplateRequest#builder()}
     * </p>
     *
     * @param getPushTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetPushTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetPushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetPushTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPushTemplateResponse> getPushTemplate(
            Consumer<GetPushTemplateRequest.Builder> getPushTemplateRequest) {
        return getPushTemplate(GetPushTemplateRequest.builder().applyMutation(getPushTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param getRecommenderConfigurationRequest
     * @return A Java Future containing the result of the GetRecommenderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommenderConfigurationResponse> getRecommenderConfiguration(
            GetRecommenderConfigurationRequest getRecommenderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an Amazon Pinpoint configuration for a recommender model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommenderConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecommenderConfigurationRequest#builder()}
     * </p>
     *
     * @param getRecommenderConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommenderConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetRecommenderConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommenderConfigurationResponse> getRecommenderConfiguration(
            Consumer<GetRecommenderConfigurationRequest.Builder> getRecommenderConfigurationRequest) {
        return getRecommenderConfiguration(GetRecommenderConfigurationRequest.builder()
                .applyMutation(getRecommenderConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all the recommender model configurations that are associated with your Amazon
     * Pinpoint account.
     * </p>
     *
     * @param getRecommenderConfigurationsRequest
     * @return A Java Future containing the result of the GetRecommenderConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommenderConfigurationsResponse> getRecommenderConfigurations(
            GetRecommenderConfigurationsRequest getRecommenderConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all the recommender model configurations that are associated with your Amazon
     * Pinpoint account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommenderConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link GetRecommenderConfigurationsRequest#builder()}
     * </p>
     *
     * @param getRecommenderConfigurationsRequest
     *        A {@link Consumer} that will call methods on {@link GetRecommenderConfigurationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetRecommenderConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetRecommenderConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetRecommenderConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommenderConfigurationsResponse> getRecommenderConfigurations(
            Consumer<GetRecommenderConfigurationsRequest.Builder> getRecommenderConfigurationsRequest) {
        return getRecommenderConfigurations(GetRecommenderConfigurationsRequest.builder()
                .applyMutation(getRecommenderConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's
     * associated with an application.
     * </p>
     *
     * @param getSegmentRequest
     * @return A Java Future containing the result of the GetSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSegmentResponse> getSegment(GetSegmentRequest getSegmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific segment that's
     * associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link GetSegmentRequest#builder()}
     * </p>
     *
     * @param getSegmentRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSegmentResponse> getSegment(Consumer<GetSegmentRequest.Builder> getSegmentRequest) {
        return getSegment(GetSegmentRequest.builder().applyMutation(getSegmentRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the export jobs for a segment.
     * </p>
     *
     * @param getSegmentExportJobsRequest
     * @return A Java Future containing the result of the GetSegmentExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentExportJobsResponse> getSegmentExportJobs(
            GetSegmentExportJobsRequest getSegmentExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the export jobs for a segment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentExportJobsRequest#builder()}
     * </p>
     *
     * @param getSegmentExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentExportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSegmentExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentExportJobsResponse> getSegmentExportJobs(
            Consumer<GetSegmentExportJobsRequest.Builder> getSegmentExportJobsRequest) {
        return getSegmentExportJobs(GetSegmentExportJobsRequest.builder().applyMutation(getSegmentExportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the import jobs for a segment.
     * </p>
     *
     * @param getSegmentImportJobsRequest
     * @return A Java Future containing the result of the GetSegmentImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentImportJobsResponse> getSegmentImportJobs(
            GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the import jobs for a segment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentImportJobsRequest#builder()}
     * </p>
     *
     * @param getSegmentImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSegmentImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentImportJobsResponse> getSegmentImportJobs(
            Consumer<GetSegmentImportJobsRequest.Builder> getSegmentImportJobsRequest) {
        return getSegmentImportJobs(GetSegmentImportJobsRequest.builder().applyMutation(getSegmentImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment
     * that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionRequest
     * @return A Java Future containing the result of the GetSegmentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentVersionResponse> getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for a specific version of a segment
     * that's associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetSegmentVersionRequest#builder()}
     * </p>
     *
     * @param getSegmentVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSegmentVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentVersionResponse> getSegmentVersion(
            Consumer<GetSegmentVersionRequest.Builder> getSegmentVersionRequest) {
        return getSegmentVersion(GetSegmentVersionRequest.builder().applyMutation(getSegmentVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific
     * segment that's associated with an application.
     * </p>
     *
     * @param getSegmentVersionsRequest
     * @return A Java Future containing the result of the GetSegmentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentVersionsResponse> getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the versions of a specific
     * segment that's associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSegmentVersionsRequest#builder()}
     * </p>
     *
     * @param getSegmentVersionsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSegmentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegmentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegmentVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSegmentVersionsResponse> getSegmentVersions(
            Consumer<GetSegmentVersionsRequest.Builder> getSegmentVersionsRequest) {
        return getSegmentVersions(GetSegmentVersionsRequest.builder().applyMutation(getSegmentVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are
     * associated with an application.
     * </p>
     *
     * @param getSegmentsRequest
     * @return A Java Future containing the result of the GetSegments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSegmentsResponse> getSegments(GetSegmentsRequest getSegmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the configuration, dimension, and other settings for all the segments that are
     * associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSegmentsRequest.Builder} avoiding the need to
     * create one manually via {@link GetSegmentsRequest#builder()}
     * </p>
     *
     * @param getSegmentsRequest
     *        A {@link Consumer} that will call methods on {@link GetSegmentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSegments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSegments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSegments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSegmentsResponse> getSegments(Consumer<GetSegmentsRequest.Builder> getSegmentsRequest) {
        return getSegments(GetSegmentsRequest.builder().applyMutation(getSegmentsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the SMS channel for an application.
     * </p>
     *
     * @param getSmsChannelRequest
     * @return A Java Future containing the result of the GetSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSmsChannelResponse> getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the SMS channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSmsChannelRequest.Builder} avoiding the need to
     * create one manually via {@link GetSmsChannelRequest#builder()}
     * </p>
     *
     * @param getSmsChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetSmsChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSmsChannelResponse> getSmsChannel(Consumer<GetSmsChannelRequest.Builder> getSmsChannelRequest) {
        return getSmsChannel(GetSmsChannelRequest.builder().applyMutation(getSmsChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param getSmsTemplateRequest
     * @return A Java Future containing the result of the GetSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSmsTemplateResponse> getSmsTemplate(GetSmsTemplateRequest getSmsTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the SMS channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSmsTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetSmsTemplateRequest#builder()}
     * </p>
     *
     * @param getSmsTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetSmsTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetSmsTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSmsTemplateResponse> getSmsTemplate(Consumer<GetSmsTemplateRequest.Builder> getSmsTemplateRequest) {
        return getSmsTemplate(GetSmsTemplateRequest.builder().applyMutation(getSmsTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     * </p>
     *
     * @param getUserEndpointsRequest
     * @return A Java Future containing the result of the GetUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserEndpointsResponse> getUserEndpoints(GetUserEndpointsRequest getUserEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all the endpoints that are associated with a specific user ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link GetUserEndpointsRequest#builder()}
     * </p>
     *
     * @param getUserEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link GetUserEndpointsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetUserEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetUserEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetUserEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetUserEndpointsResponse> getUserEndpoints(
            Consumer<GetUserEndpointsRequest.Builder> getUserEndpointsRequest) {
        return getUserEndpoints(GetUserEndpointsRequest.builder().applyMutation(getUserEndpointsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the voice channel for an application.
     * </p>
     *
     * @param getVoiceChannelRequest
     * @return A Java Future containing the result of the GetVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVoiceChannelResponse> getVoiceChannel(GetVoiceChannelRequest getVoiceChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status and settings of the voice channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceChannelRequest.Builder} avoiding the need
     * to create one manually via {@link GetVoiceChannelRequest#builder()}
     * </p>
     *
     * @param getVoiceChannelRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVoiceChannelResponse> getVoiceChannel(
            Consumer<GetVoiceChannelRequest.Builder> getVoiceChannelRequest) {
        return getVoiceChannel(GetVoiceChannelRequest.builder().applyMutation(getVoiceChannelRequest).build());
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param getVoiceTemplateRequest
     * @return A Java Future containing the result of the GetVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVoiceTemplateResponse> getVoiceTemplate(GetVoiceTemplateRequest getVoiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the content and settings of a message template for messages that are sent through the voice channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVoiceTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetVoiceTemplateRequest#builder()}
     * </p>
     *
     * @param getVoiceTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetVoiceTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.GetVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetVoiceTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVoiceTemplateResponse> getVoiceTemplate(
            Consumer<GetVoiceTemplateRequest.Builder> getVoiceTemplateRequest) {
        return getVoiceTemplate(GetVoiceTemplateRequest.builder().applyMutation(getVoiceTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the journeys that are
     * associated with an application.
     * </p>
     *
     * @param listJourneysRequest
     * @return A Java Future containing the result of the ListJourneys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListJourneys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListJourneys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJourneysResponse> listJourneys(ListJourneysRequest listJourneysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the status, configuration, and other settings for all the journeys that are
     * associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJourneysRequest.Builder} avoiding the need to
     * create one manually via {@link ListJourneysRequest#builder()}
     * </p>
     *
     * @param listJourneysRequest
     *        A {@link Consumer} that will call methods on {@link ListJourneysRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListJourneys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListJourneys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListJourneys" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListJourneysResponse> listJourneys(Consumer<ListJourneysRequest.Builder> listJourneysRequest) {
        return listJourneys(ListJourneysRequest.builder().applyMutation(listJourneysRequest).build());
    }

    /**
     * <p>
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or
     * segment.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or
     * segment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all the versions of a specific message template.
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A Java Future containing the result of the ListTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplateVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(
            ListTemplateVersionsRequest listTemplateVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all the versions of a specific message template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateVersionsRequest#builder()}
     * </p>
     *
     * @param listTemplateVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplateVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(
            Consumer<ListTemplateVersionsRequest.Builder> listTemplateVersionsRequest) {
        return listTemplateVersions(ListTemplateVersionsRequest.builder().applyMutation(listTemplateVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     * </p>
     *
     * @param listTemplatesRequest
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest) {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a phone number.
     * </p>
     *
     * @param phoneNumberValidateRequest
     * @return A Java Future containing the result of the PhoneNumberValidate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PhoneNumberValidate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PhoneNumberValidateResponse> phoneNumberValidate(
            PhoneNumberValidateRequest phoneNumberValidateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a phone number.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PhoneNumberValidateRequest.Builder} avoiding the
     * need to create one manually via {@link PhoneNumberValidateRequest#builder()}
     * </p>
     *
     * @param phoneNumberValidateRequest
     *        A {@link Consumer} that will call methods on {@link PhoneNumberValidateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PhoneNumberValidate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PhoneNumberValidate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PhoneNumberValidate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PhoneNumberValidateResponse> phoneNumberValidate(
            Consumer<PhoneNumberValidateRequest.Builder> phoneNumberValidateRequest) {
        return phoneNumberValidate(PhoneNumberValidateRequest.builder().applyMutation(phoneNumberValidateRequest).build());
    }

    /**
     * <p>
     * Creates a new event stream for an application or updates the settings of an existing event stream for an
     * application.
     * </p>
     *
     * @param putEventStreamRequest
     * @return A Java Future containing the result of the PutEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEventStreamResponse> putEventStream(PutEventStreamRequest putEventStreamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event stream for an application or updates the settings of an existing event stream for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventStreamRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventStreamRequest#builder()}
     * </p>
     *
     * @param putEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link PutEventStreamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutEventStream operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEventStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEventStreamResponse> putEventStream(Consumer<PutEventStreamRequest.Builder> putEventStreamRequest) {
        return putEventStream(PutEventStreamRequest.builder().applyMutation(putEventStreamRequest).build());
    }

    /**
     * <p>
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are
     * associated with.
     * </p>
     *
     * @param putEventsRequest
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEventsResponse> putEvents(PutEventsRequest putEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are
     * associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventsRequest#builder()}
     * </p>
     *
     * @param putEventsRequest
     *        A {@link Consumer} that will call methods on {@link PutEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.PutEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/PutEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutEventsResponse> putEvents(Consumer<PutEventsRequest.Builder> putEventsRequest) {
        return putEvents(PutEventsRequest.builder().applyMutation(putEventsRequest).build());
    }

    /**
     * <p>
     * Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an
     * application.
     * </p>
     *
     * @param removeAttributesRequest
     * @return A Java Future containing the result of the RemoveAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.RemoveAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveAttributesResponse> removeAttributes(RemoveAttributesRequest removeAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveAttributesRequest#builder()}
     * </p>
     *
     * @param removeAttributesRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAttributesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RemoveAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.RemoveAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/RemoveAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveAttributesResponse> removeAttributes(
            Consumer<RemoveAttributesRequest.Builder> removeAttributesRequest) {
        return removeAttributes(RemoveAttributesRequest.builder().applyMutation(removeAttributesRequest).build());
    }

    /**
     * <p>
     * Creates and sends a direct message.
     * </p>
     *
     * @param sendMessagesRequest
     * @return A Java Future containing the result of the SendMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendMessagesResponse> sendMessages(SendMessagesRequest sendMessagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and sends a direct message.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendMessagesRequest.Builder} avoiding the need to
     * create one manually via {@link SendMessagesRequest#builder()}
     * </p>
     *
     * @param sendMessagesRequest
     *        A {@link Consumer} that will call methods on {@link SendMessagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendMessages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendMessagesResponse> sendMessages(Consumer<SendMessagesRequest.Builder> sendMessagesRequest) {
        return sendMessages(SendMessagesRequest.builder().applyMutation(sendMessagesRequest).build());
    }

    /**
     * <p>
     * Creates and sends a message to a list of users.
     * </p>
     *
     * @param sendUsersMessagesRequest
     * @return A Java Future containing the result of the SendUsersMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendUsersMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SendUsersMessagesResponse> sendUsersMessages(SendUsersMessagesRequest sendUsersMessagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and sends a message to a list of users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendUsersMessagesRequest.Builder} avoiding the need
     * to create one manually via {@link SendUsersMessagesRequest#builder()}
     * </p>
     *
     * @param sendUsersMessagesRequest
     *        A {@link Consumer} that will call methods on {@link SendUsersMessagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendUsersMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.SendUsersMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/SendUsersMessages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<SendUsersMessagesResponse> sendUsersMessages(
            Consumer<SendUsersMessagesRequest.Builder> sendUsersMessagesRequest) {
        return sendUsersMessages(SendUsersMessagesRequest.builder().applyMutation(sendUsersMessagesRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags (keys and values) to an application, campaign, message template, or segment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags (keys and values) from an application, campaign, message template, or segment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an
     * application.
     * </p>
     *
     * @param updateAdmChannelRequest
     * @return A Java Future containing the result of the UpdateAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAdmChannelResponse> updateAdmChannel(UpdateAdmChannelRequest updateAdmChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the ADM channel for an application or updates the status and settings of the ADM channel for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAdmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAdmChannelRequest#builder()}
     * </p>
     *
     * @param updateAdmChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAdmChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAdmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateAdmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAdmChannelResponse> updateAdmChannel(
            Consumer<UpdateAdmChannelRequest.Builder> updateAdmChannelRequest) {
        return updateAdmChannel(UpdateAdmChannelRequest.builder().applyMutation(updateAdmChannelRequest).build());
    }

    /**
     * <p>
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an
     * application.
     * </p>
     *
     * @param updateApnsChannelRequest
     * @return A Java Future containing the result of the UpdateApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApnsChannelResponse> updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the APNs channel for an application or updates the status and settings of the APNs channel for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApnsChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApnsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateApnsChannelResponse> updateApnsChannel(
            Consumer<UpdateApnsChannelRequest.Builder> updateApnsChannelRequest) {
        return updateApnsChannel(UpdateApnsChannelRequest.builder().applyMutation(updateApnsChannelRequest).build());
    }

    /**
     * <p>
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox
     * channel for an application.
     * </p>
     *
     * @param updateApnsSandboxChannelRequest
     * @return A Java Future containing the result of the UpdateApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApnsSandboxChannelResponse> updateApnsSandboxChannel(
            UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox
     * channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsSandboxChannelRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateApnsSandboxChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsSandboxChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApnsSandboxChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApnsSandboxChannelResponse> updateApnsSandboxChannel(
            Consumer<UpdateApnsSandboxChannelRequest.Builder> updateApnsSandboxChannelRequest) {
        return updateApnsSandboxChannel(UpdateApnsSandboxChannelRequest.builder().applyMutation(updateApnsSandboxChannelRequest)
                .build());
    }

    /**
     * <p>
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for
     * an application.
     * </p>
     *
     * @param updateApnsVoipChannelRequest
     * @return A Java Future containing the result of the UpdateApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApnsVoipChannelResponse> updateApnsVoipChannel(
            UpdateApnsVoipChannelRequest updateApnsVoipChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for
     * an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsVoipChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateApnsVoipChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsVoipChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsVoipChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApnsVoipChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApnsVoipChannelResponse> updateApnsVoipChannel(
            Consumer<UpdateApnsVoipChannelRequest.Builder> updateApnsVoipChannelRequest) {
        return updateApnsVoipChannel(UpdateApnsVoipChannelRequest.builder().applyMutation(updateApnsVoipChannelRequest).build());
    }

    /**
     * <p>
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP
     * sandbox channel for an application.
     * </p>
     *
     * @param updateApnsVoipSandboxChannelRequest
     * @return A Java Future containing the result of the UpdateApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApnsVoipSandboxChannelResponse> updateApnsVoipSandboxChannel(
            UpdateApnsVoipSandboxChannelRequest updateApnsVoipSandboxChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP
     * sandbox channel for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApnsVoipSandboxChannelRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateApnsVoipSandboxChannelRequest#builder()}
     * </p>
     *
     * @param updateApnsVoipSandboxChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApnsVoipSandboxChannelRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateApnsVoipSandboxChannel operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApnsVoipSandboxChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApnsVoipSandboxChannel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApnsVoipSandboxChannelResponse> updateApnsVoipSandboxChannel(
            Consumer<UpdateApnsVoipSandboxChannelRequest.Builder> updateApnsVoipSandboxChannelRequest) {
        return updateApnsVoipSandboxChannel(UpdateApnsVoipSandboxChannelRequest.builder()
                .applyMutation(updateApnsVoipSandboxChannelRequest).build());
    }

    /**
     * <p>
     * Updates the settings for an application.
     * </p>
     *
     * @param updateApplicationSettingsRequest
     * @return A Java Future containing the result of the UpdateApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationSettingsResponse> updateApplicationSettings(
            UpdateApplicationSettingsRequest updateApplicationSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings for an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateApplicationSettingsRequest#builder()}
     * </p>
     *
     * @param updateApplicationSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApplicationSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateApplicationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateApplicationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationSettingsResponse> updateApplicationSettings(
            Consumer<UpdateApplicationSettingsRequest.Builder> updateApplicationSettingsRequest) {
        return updateApplicationSettings(UpdateApplicationSettingsRequest.builder()
                .applyMutation(updateApplicationSettingsRequest).build());
    }

    /**
     * <p>
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an
     * application.
     * </p>
     *
     * @param updateBaiduChannelRequest
     * @return A Java Future containing the result of the UpdateBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBaiduChannelResponse> updateBaiduChannel(UpdateBaiduChannelRequest updateBaiduChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBaiduChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBaiduChannelRequest#builder()}
     * </p>
     *
     * @param updateBaiduChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBaiduChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateBaiduChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateBaiduChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateBaiduChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateBaiduChannelResponse> updateBaiduChannel(
            Consumer<UpdateBaiduChannelRequest.Builder> updateBaiduChannelRequest) {
        return updateBaiduChannel(UpdateBaiduChannelRequest.builder().applyMutation(updateBaiduChannelRequest).build());
    }

    /**
     * <p>
     * Updates the configuration and other settings for a campaign.
     * </p>
     *
     * @param updateCampaignRequest
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCampaignResponse> updateCampaign(UpdateCampaignRequest updateCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration and other settings for a campaign.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCampaignRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCampaignRequest#builder()}
     * </p>
     *
     * @param updateCampaignRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCampaignRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCampaign operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateCampaign
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateCampaign" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCampaignResponse> updateCampaign(Consumer<UpdateCampaignRequest.Builder> updateCampaignRequest) {
        return updateCampaign(UpdateCampaignRequest.builder().applyMutation(updateCampaignRequest).build());
    }

    /**
     * <p>
     * Enables the email channel for an application or updates the status and settings of the email channel for an
     * application.
     * </p>
     *
     * @param updateEmailChannelRequest
     * @return A Java Future containing the result of the UpdateEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEmailChannelResponse> updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the email channel for an application or updates the status and settings of the email channel for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmailChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEmailChannelRequest#builder()}
     * </p>
     *
     * @param updateEmailChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEmailChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEmailChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEmailChannelResponse> updateEmailChannel(
            Consumer<UpdateEmailChannelRequest.Builder> updateEmailChannelRequest) {
        return updateEmailChannel(UpdateEmailChannelRequest.builder().applyMutation(updateEmailChannelRequest).build());
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the email channel.
     * </p>
     *
     * @param updateEmailTemplateRequest
     * @return A Java Future containing the result of the UpdateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(
            UpdateEmailTemplateRequest updateEmailTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the email channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmailTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEmailTemplateRequest#builder()}
     * </p>
     *
     * @param updateEmailTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEmailTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEmailTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEmailTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEmailTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEmailTemplateResponse> updateEmailTemplate(
            Consumer<UpdateEmailTemplateRequest.Builder> updateEmailTemplateRequest) {
        return updateEmailTemplate(UpdateEmailTemplateRequest.builder().applyMutation(updateEmailTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an
     * application. You can also use this operation to define custom attributes for an endpoint. If an update includes
     * one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new
     * values.
     * </p>
     *
     * @param updateEndpointRequest
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest updateEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an
     * application. You can also use this operation to define custom attributes for an endpoint. If an update includes
     * one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new
     * values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateEndpointRequest#builder()}
     * </p>
     *
     * @param updateEndpointRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateEndpointResponse> updateEndpoint(Consumer<UpdateEndpointRequest.Builder> updateEndpointRequest) {
        return updateEndpoint(UpdateEndpointRequest.builder().applyMutation(updateEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing
     * endpoints for an application. You can also use this operation to define custom attributes for a batch of
     * endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites)
     * any existing values with the new values.
     * </p>
     *
     * @param updateEndpointsBatchRequest
     * @return A Java Future containing the result of the UpdateEndpointsBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpointsBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointsBatchResponse> updateEndpointsBatch(
            UpdateEndpointsBatchRequest updateEndpointsBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing
     * endpoints for an application. You can also use this operation to define custom attributes for a batch of
     * endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites)
     * any existing values with the new values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEndpointsBatchRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEndpointsBatchRequest#builder()}
     * </p>
     *
     * @param updateEndpointsBatchRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEndpointsBatchRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEndpointsBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateEndpointsBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateEndpointsBatchResponse> updateEndpointsBatch(
            Consumer<UpdateEndpointsBatchRequest.Builder> updateEndpointsBatchRequest) {
        return updateEndpointsBatch(UpdateEndpointsBatchRequest.builder().applyMutation(updateEndpointsBatchRequest).build());
    }

    /**
     * <p>
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an
     * application.
     * </p>
     *
     * @param updateGcmChannelRequest
     * @return A Java Future containing the result of the UpdateGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGcmChannelResponse> updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the GCM channel for an application or updates the status and settings of the GCM channel for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGcmChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateGcmChannelRequest#builder()}
     * </p>
     *
     * @param updateGcmChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGcmChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGcmChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateGcmChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateGcmChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGcmChannelResponse> updateGcmChannel(
            Consumer<UpdateGcmChannelRequest.Builder> updateGcmChannelRequest) {
        return updateGcmChannel(UpdateGcmChannelRequest.builder().applyMutation(updateGcmChannelRequest).build());
    }

    /**
     * <p>
     * Updates the configuration and other settings for a journey.
     * </p>
     *
     * @param updateJourneyRequest
     * @return A Java Future containing the result of the UpdateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>ConflictException The request failed due to a conflict with the current state of the specified
     *         resource (ConflictException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateJourneyResponse> updateJourney(UpdateJourneyRequest updateJourneyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration and other settings for a journey.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJourneyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateJourneyRequest#builder()}
     * </p>
     *
     * @param updateJourneyRequest
     *        A {@link Consumer} that will call methods on {@link UpdateJourneyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateJourney operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>ConflictException The request failed due to a conflict with the current state of the specified
     *         resource (ConflictException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourney
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourney" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateJourneyResponse> updateJourney(Consumer<UpdateJourneyRequest.Builder> updateJourneyRequest) {
        return updateJourney(UpdateJourneyRequest.builder().applyMutation(updateJourneyRequest).build());
    }

    /**
     * <p>
     * Cancels (stops) an active journey.
     * </p>
     *
     * @param updateJourneyStateRequest
     * @return A Java Future containing the result of the UpdateJourneyState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourneyState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateJourneyStateResponse> updateJourneyState(UpdateJourneyStateRequest updateJourneyStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels (stops) an active journey.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateJourneyStateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateJourneyStateRequest#builder()}
     * </p>
     *
     * @param updateJourneyStateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateJourneyStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateJourneyState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateJourneyState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateJourneyState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateJourneyStateResponse> updateJourneyState(
            Consumer<UpdateJourneyStateRequest.Builder> updateJourneyStateRequest) {
        return updateJourneyState(UpdateJourneyStateRequest.builder().applyMutation(updateJourneyStateRequest).build());
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through a push notification channel.
     * </p>
     *
     * @param updatePushTemplateRequest
     * @return A Java Future containing the result of the UpdatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePushTemplateResponse> updatePushTemplate(UpdatePushTemplateRequest updatePushTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through a push notification channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePushTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdatePushTemplateRequest#builder()}
     * </p>
     *
     * @param updatePushTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePushTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePushTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdatePushTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdatePushTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePushTemplateResponse> updatePushTemplate(
            Consumer<UpdatePushTemplateRequest.Builder> updatePushTemplateRequest) {
        return updatePushTemplate(UpdatePushTemplateRequest.builder().applyMutation(updatePushTemplateRequest).build());
    }

    /**
     * <p>
     * Updates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     *
     * @param updateRecommenderConfigurationRequest
     * @return A Java Future containing the result of the UpdateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecommenderConfigurationResponse> updateRecommenderConfiguration(
            UpdateRecommenderConfigurationRequest updateRecommenderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Amazon Pinpoint configuration for a recommender model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecommenderConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRecommenderConfigurationRequest#builder()}
     * </p>
     *
     * @param updateRecommenderConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRecommenderConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateRecommenderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateRecommenderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateRecommenderConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecommenderConfigurationResponse> updateRecommenderConfiguration(
            Consumer<UpdateRecommenderConfigurationRequest.Builder> updateRecommenderConfigurationRequest) {
        return updateRecommenderConfiguration(UpdateRecommenderConfigurationRequest.builder()
                .applyMutation(updateRecommenderConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     *
     * @param updateSegmentRequest
     * @return A Java Future containing the result of the UpdateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSegmentResponse> updateSegment(UpdateSegmentRequest updateSegmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new segment for an application or updates the configuration, dimension, and other settings for an
     * existing segment that's associated with an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSegmentRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSegmentRequest#builder()}
     * </p>
     *
     * @param updateSegmentRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSegmentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSegment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSegment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSegment" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSegmentResponse> updateSegment(Consumer<UpdateSegmentRequest.Builder> updateSegmentRequest) {
        return updateSegment(UpdateSegmentRequest.builder().applyMutation(updateSegmentRequest).build());
    }

    /**
     * <p>
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an
     * application.
     * </p>
     *
     * @param updateSmsChannelRequest
     * @return A Java Future containing the result of the UpdateSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSmsChannelResponse> updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the SMS channel for an application or updates the status and settings of the SMS channel for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSmsChannelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSmsChannelRequest#builder()}
     * </p>
     *
     * @param updateSmsChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSmsChannelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSmsChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsChannel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSmsChannelResponse> updateSmsChannel(
            Consumer<UpdateSmsChannelRequest.Builder> updateSmsChannelRequest) {
        return updateSmsChannel(UpdateSmsChannelRequest.builder().applyMutation(updateSmsChannelRequest).build());
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the SMS channel.
     * </p>
     *
     * @param updateSmsTemplateRequest
     * @return A Java Future containing the result of the UpdateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSmsTemplateResponse> updateSmsTemplate(UpdateSmsTemplateRequest updateSmsTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the SMS channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSmsTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSmsTemplateRequest#builder()}
     * </p>
     *
     * @param updateSmsTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSmsTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateSmsTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateSmsTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateSmsTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSmsTemplateResponse> updateSmsTemplate(
            Consumer<UpdateSmsTemplateRequest.Builder> updateSmsTemplateRequest) {
        return updateSmsTemplate(UpdateSmsTemplateRequest.builder().applyMutation(updateSmsTemplateRequest).build());
    }

    /**
     * <p>
     * Changes the status of a specific version of a message template to <i>active</i>.
     * </p>
     *
     * @param updateTemplateActiveVersionRequest
     * @return A Java Future containing the result of the UpdateTemplateActiveVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateTemplateActiveVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateTemplateActiveVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateActiveVersionResponse> updateTemplateActiveVersion(
            UpdateTemplateActiveVersionRequest updateTemplateActiveVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the status of a specific version of a message template to <i>active</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateActiveVersionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateTemplateActiveVersionRequest#builder()}
     * </p>
     *
     * @param updateTemplateActiveVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateActiveVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateTemplateActiveVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateTemplateActiveVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateTemplateActiveVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateActiveVersionResponse> updateTemplateActiveVersion(
            Consumer<UpdateTemplateActiveVersionRequest.Builder> updateTemplateActiveVersionRequest) {
        return updateTemplateActiveVersion(UpdateTemplateActiveVersionRequest.builder()
                .applyMutation(updateTemplateActiveVersionRequest).build());
    }

    /**
     * <p>
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an
     * application.
     * </p>
     *
     * @param updateVoiceChannelRequest
     * @return A Java Future containing the result of the UpdateVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceChannelResponse> updateVoiceChannel(UpdateVoiceChannelRequest updateVoiceChannelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the voice channel for an application or updates the status and settings of the voice channel for an
     * application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceChannelRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVoiceChannelRequest#builder()}
     * </p>
     *
     * @param updateVoiceChannelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceChannelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceChannel" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceChannelResponse> updateVoiceChannel(
            Consumer<UpdateVoiceChannelRequest.Builder> updateVoiceChannelRequest) {
        return updateVoiceChannel(UpdateVoiceChannelRequest.builder().applyMutation(updateVoiceChannelRequest).build());
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the voice channel.
     * </p>
     *
     * @param updateVoiceTemplateRequest
     * @return A Java Future containing the result of the UpdateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceTemplateResponse> updateVoiceTemplate(
            UpdateVoiceTemplateRequest updateVoiceTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing message template for messages that are sent through the voice channel.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVoiceTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVoiceTemplateRequest#builder()}
     * </p>
     *
     * @param updateVoiceTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVoiceTemplateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateVoiceTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request contains a syntax error (BadRequestException).</li>
     *         <li>InternalServerErrorException The request failed due to an unknown internal server error, exception,
     *         or failure (InternalServerErrorException).</li>
     *         <li>PayloadTooLargeException The request failed because the payload for the body of the request is too
     *         large (RequestEntityTooLargeException).</li>
     *         <li>ForbiddenException The request was denied because access to the specified resource is forbidden
     *         (ForbiddenException).</li>
     *         <li>NotFoundException The request failed because the specified resource was not found
     *         (NotFoundException).</li>
     *         <li>MethodNotAllowedException The request failed because the method is not allowed for the specified
     *         resource (MethodNotAllowedException).</li>
     *         <li>TooManyRequestsException The request failed because too many requests were sent during a certain
     *         amount of time (TooManyRequestsException).</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>PinpointException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample PinpointAsyncClient.UpdateVoiceTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateVoiceTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVoiceTemplateResponse> updateVoiceTemplate(
            Consumer<UpdateVoiceTemplateRequest.Builder> updateVoiceTemplateRequest) {
        return updateVoiceTemplate(UpdateVoiceTemplateRequest.builder().applyMutation(updateVoiceTemplateRequest).build());
    }
}
