/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the delivery status and results of sending a message directly to an endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointMessageResult implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointMessageResult.Builder, EndpointMessageResult> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(EndpointMessageResult::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> DELIVERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStatus").getter(getter(EndpointMessageResult::deliveryStatusAsString))
            .setter(setter(Builder::deliveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStatus").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(EndpointMessageResult::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(EndpointMessageResult::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(EndpointMessageResult::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> UPDATED_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedToken").getter(getter(EndpointMessageResult::updatedToken)).setter(setter(Builder::updatedToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            DELIVERY_STATUS_FIELD, MESSAGE_ID_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, UPDATED_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String address;

    private final String deliveryStatus;

    private final String messageId;

    private final Integer statusCode;

    private final String statusMessage;

    private final String updatedToken;

    private EndpointMessageResult(BuilderImpl builder) {
        this.address = builder.address;
        this.deliveryStatus = builder.deliveryStatus;
        this.messageId = builder.messageId;
        this.statusCode = builder.statusCode;
        this.statusMessage = builder.statusMessage;
        this.updatedToken = builder.updatedToken;
    }

    /**
     * <p>
     * The endpoint address that the message was delivered to.
     * </p>
     * 
     * @return The endpoint address that the message was delivered to.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * The delivery status of the message. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't attempt to
     * send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you. Amazon
     * Pinpoint won't attempt to send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint won't attempt
     * to send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCESSFUL - The message was successfully delivered to the endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIMEOUT - The message couldn't be sent within the timeout period.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN_FAILURE - An unknown error occurred.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryStatus}
     * will return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryStatusAsString}.
     * </p>
     * 
     * @return The delivery status of the message. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't
     *         attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you.
     *         Amazon Pinpoint won't attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint won't
     *         attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCESSFUL - The message was successfully delivered to the endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIMEOUT - The message couldn't be sent within the timeout period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN_FAILURE - An unknown error occurred.
     *         </p>
     *         </li>
     * @see DeliveryStatus
     */
    public final DeliveryStatus deliveryStatus() {
        return DeliveryStatus.fromValue(deliveryStatus);
    }

    /**
     * <p>
     * The delivery status of the message. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't attempt to
     * send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you. Amazon
     * Pinpoint won't attempt to send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint won't attempt
     * to send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCESSFUL - The message was successfully delivered to the endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
     * </p>
     * </li>
     * <li>
     * <p>
     * THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
     * </p>
     * </li>
     * <li>
     * <p>
     * TIMEOUT - The message couldn't be sent within the timeout period.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNKNOWN_FAILURE - An unknown error occurred.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryStatus}
     * will return {@link DeliveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deliveryStatusAsString}.
     * </p>
     * 
     * @return The delivery status of the message. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't
     *         attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you.
     *         Amazon Pinpoint won't attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint won't
     *         attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCESSFUL - The message was successfully delivered to the endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TIMEOUT - The message couldn't be sent within the timeout period.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNKNOWN_FAILURE - An unknown error occurred.
     *         </p>
     *         </li>
     * @see DeliveryStatus
     */
    public final String deliveryStatusAsString() {
        return deliveryStatus;
    }

    /**
     * <p>
     * The unique identifier for the message that was sent.
     * </p>
     * 
     * @return The unique identifier for the message that was sent.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The downstream service status code for delivering the message.
     * </p>
     * 
     * @return The downstream service status code for delivering the message.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * The status message for delivering the message.
     * </p>
     * 
     * @return The status message for delivering the message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * For push notifications that are sent through the GCM channel, specifies whether the endpoint's device
     * registration token was updated as part of delivering the message.
     * </p>
     * 
     * @return For push notifications that are sent through the GCM channel, specifies whether the endpoint's device
     *         registration token was updated as part of delivering the message.
     */
    public final String updatedToken() {
        return updatedToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(updatedToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointMessageResult)) {
            return false;
        }
        EndpointMessageResult other = (EndpointMessageResult) obj;
        return Objects.equals(address(), other.address())
                && Objects.equals(deliveryStatusAsString(), other.deliveryStatusAsString())
                && Objects.equals(messageId(), other.messageId()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(updatedToken(), other.updatedToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointMessageResult").add("Address", address())
                .add("DeliveryStatus", deliveryStatusAsString()).add("MessageId", messageId()).add("StatusCode", statusCode())
                .add("StatusMessage", statusMessage()).add("UpdatedToken", updatedToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "DeliveryStatus":
            return Optional.ofNullable(clazz.cast(deliveryStatusAsString()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "UpdatedToken":
            return Optional.ofNullable(clazz.cast(updatedToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointMessageResult, T> g) {
        return obj -> g.apply((EndpointMessageResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointMessageResult> {
        /**
         * <p>
         * The endpoint address that the message was delivered to.
         * </p>
         * 
         * @param address
         *        The endpoint address that the message was delivered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The delivery status of the message. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't attempt to
         * send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you. Amazon
         * Pinpoint won't attempt to send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint won't
         * attempt to send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCESSFUL - The message was successfully delivered to the endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT - The message couldn't be sent within the timeout period.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN_FAILURE - An unknown error occurred.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryStatus
         *        The delivery status of the message. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't
         *        attempt to send the message again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you.
         *        Amazon Pinpoint won't attempt to send the message again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint
         *        won't attempt to send the message again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCESSFUL - The message was successfully delivered to the endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT - The message couldn't be sent within the timeout period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN_FAILURE - An unknown error occurred.
         *        </p>
         *        </li>
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder deliveryStatus(String deliveryStatus);

        /**
         * <p>
         * The delivery status of the message. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't attempt to
         * send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you. Amazon
         * Pinpoint won't attempt to send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint won't
         * attempt to send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCESSFUL - The message was successfully delivered to the endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message again.
         * </p>
         * </li>
         * <li>
         * <p>
         * THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
         * </p>
         * </li>
         * <li>
         * <p>
         * TIMEOUT - The message couldn't be sent within the timeout period.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNKNOWN_FAILURE - An unknown error occurred.
         * </p>
         * </li>
         * </ul>
         * 
         * @param deliveryStatus
         *        The delivery status of the message. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won't
         *        attempt to send the message again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPT_OUT - The user who's associated with the endpoint has opted out of receiving messages from you.
         *        Amazon Pinpoint won't attempt to send the message again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint
         *        won't attempt to send the message again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCESSFUL - The message was successfully delivered to the endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won't attempt to send the message
         *        again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TIMEOUT - The message couldn't be sent within the timeout period.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNKNOWN_FAILURE - An unknown error occurred.
         *        </p>
         *        </li>
         * @see DeliveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeliveryStatus
         */
        Builder deliveryStatus(DeliveryStatus deliveryStatus);

        /**
         * <p>
         * The unique identifier for the message that was sent.
         * </p>
         * 
         * @param messageId
         *        The unique identifier for the message that was sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The downstream service status code for delivering the message.
         * </p>
         * 
         * @param statusCode
         *        The downstream service status code for delivering the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * The status message for delivering the message.
         * </p>
         * 
         * @param statusMessage
         *        The status message for delivering the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * For push notifications that are sent through the GCM channel, specifies whether the endpoint's device
         * registration token was updated as part of delivering the message.
         * </p>
         * 
         * @param updatedToken
         *        For push notifications that are sent through the GCM channel, specifies whether the endpoint's device
         *        registration token was updated as part of delivering the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedToken(String updatedToken);
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private String deliveryStatus;

        private String messageId;

        private Integer statusCode;

        private String statusMessage;

        private String updatedToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointMessageResult model) {
            address(model.address);
            deliveryStatus(model.deliveryStatus);
            messageId(model.messageId);
            statusCode(model.statusCode);
            statusMessage(model.statusMessage);
            updatedToken(model.updatedToken);
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        public final String getDeliveryStatus() {
            return deliveryStatus;
        }

        @Override
        public final Builder deliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        @Override
        public final Builder deliveryStatus(DeliveryStatus deliveryStatus) {
            this.deliveryStatus(deliveryStatus == null ? null : deliveryStatus.toString());
            return this;
        }

        public final void setDeliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getUpdatedToken() {
            return updatedToken;
        }

        @Override
        public final Builder updatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
            return this;
        }

        public final void setUpdatedToken(String updatedToken) {
            this.updatedToken = updatedToken;
        }

        @Override
        public EndpointMessageResult build() {
            return new EndpointMessageResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
