/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the status code and message that result from processing an event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventItemResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<EventItemResponse.Builder, EventItemResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(EventItemResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(EventItemResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            STATUS_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final Integer statusCode;

    private EventItemResponse(BuilderImpl builder) {
        this.message = builder.message;
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * A custom message that's returned in the response as a result of processing the event.
     * </p>
     * 
     * @return A custom message that's returned in the response as a result of processing the event.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The status code that's returned in the response as a result of processing the event. Possible values are: 202,
     * for events that were accepted; and, 400, for events that weren't valid.
     * </p>
     * 
     * @return The status code that's returned in the response as a result of processing the event. Possible values are:
     *         202, for events that were accepted; and, 400, for events that weren't valid.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventItemResponse)) {
            return false;
        }
        EventItemResponse other = (EventItemResponse) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventItemResponse").add("Message", message()).add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventItemResponse, T> g) {
        return obj -> g.apply((EventItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventItemResponse> {
        /**
         * <p>
         * A custom message that's returned in the response as a result of processing the event.
         * </p>
         * 
         * @param message
         *        A custom message that's returned in the response as a result of processing the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The status code that's returned in the response as a result of processing the event. Possible values are:
         * 202, for events that were accepted; and, 400, for events that weren't valid.
         * </p>
         * 
         * @param statusCode
         *        The status code that's returned in the response as a result of processing the event. Possible values
         *        are: 202, for events that were accepted; and, 400, for events that weren't valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(EventItemResponse model) {
            message(model.message);
            statusCode(model.statusCode);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public EventItemResponse build() {
            return new EventItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
