/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJourneyExecutionMetricsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetJourneyExecutionMetricsResponse.Builder, GetJourneyExecutionMetricsResponse> {
    private static final SdkField<JourneyExecutionMetricsResponse> JOURNEY_EXECUTION_METRICS_RESPONSE_FIELD = SdkField
            .<JourneyExecutionMetricsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("JourneyExecutionMetricsResponse")
            .getter(getter(GetJourneyExecutionMetricsResponse::journeyExecutionMetricsResponse))
            .setter(setter(Builder::journeyExecutionMetricsResponse))
            .constructor(JourneyExecutionMetricsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyExecutionMetricsResponse")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOURNEY_EXECUTION_METRICS_RESPONSE_FIELD));

    private final JourneyExecutionMetricsResponse journeyExecutionMetricsResponse;

    private GetJourneyExecutionMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.journeyExecutionMetricsResponse = builder.journeyExecutionMetricsResponse;
    }

    /**
     * Returns the value of the JourneyExecutionMetricsResponse property for this object.
     * 
     * @return The value of the JourneyExecutionMetricsResponse property for this object.
     */
    public final JourneyExecutionMetricsResponse journeyExecutionMetricsResponse() {
        return journeyExecutionMetricsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(journeyExecutionMetricsResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJourneyExecutionMetricsResponse)) {
            return false;
        }
        GetJourneyExecutionMetricsResponse other = (GetJourneyExecutionMetricsResponse) obj;
        return Objects.equals(journeyExecutionMetricsResponse(), other.journeyExecutionMetricsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJourneyExecutionMetricsResponse")
                .add("JourneyExecutionMetricsResponse", journeyExecutionMetricsResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JourneyExecutionMetricsResponse":
            return Optional.ofNullable(clazz.cast(journeyExecutionMetricsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJourneyExecutionMetricsResponse, T> g) {
        return obj -> g.apply((GetJourneyExecutionMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetJourneyExecutionMetricsResponse> {
        /**
         * Sets the value of the JourneyExecutionMetricsResponse property for this object.
         *
         * @param journeyExecutionMetricsResponse
         *        The new value for the JourneyExecutionMetricsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyExecutionMetricsResponse(JourneyExecutionMetricsResponse journeyExecutionMetricsResponse);

        /**
         * Sets the value of the JourneyExecutionMetricsResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link JourneyExecutionMetricsResponse.Builder}
         * avoiding the need to create one manually via {@link JourneyExecutionMetricsResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link JourneyExecutionMetricsResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #journeyExecutionMetricsResponse(JourneyExecutionMetricsResponse)}.
         * 
         * @param journeyExecutionMetricsResponse
         *        a consumer that will call methods on {@link JourneyExecutionMetricsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journeyExecutionMetricsResponse(JourneyExecutionMetricsResponse)
         */
        default Builder journeyExecutionMetricsResponse(
                Consumer<JourneyExecutionMetricsResponse.Builder> journeyExecutionMetricsResponse) {
            return journeyExecutionMetricsResponse(JourneyExecutionMetricsResponse.builder()
                    .applyMutation(journeyExecutionMetricsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private JourneyExecutionMetricsResponse journeyExecutionMetricsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJourneyExecutionMetricsResponse model) {
            super(model);
            journeyExecutionMetricsResponse(model.journeyExecutionMetricsResponse);
        }

        public final JourneyExecutionMetricsResponse.Builder getJourneyExecutionMetricsResponse() {
            return journeyExecutionMetricsResponse != null ? journeyExecutionMetricsResponse.toBuilder() : null;
        }

        @Override
        public final Builder journeyExecutionMetricsResponse(JourneyExecutionMetricsResponse journeyExecutionMetricsResponse) {
            this.journeyExecutionMetricsResponse = journeyExecutionMetricsResponse;
            return this;
        }

        public final void setJourneyExecutionMetricsResponse(
                JourneyExecutionMetricsResponse.BuilderImpl journeyExecutionMetricsResponse) {
            this.journeyExecutionMetricsResponse = journeyExecutionMetricsResponse != null ? journeyExecutionMetricsResponse
                    .build() : null;
        }

        @Override
        public GetJourneyExecutionMetricsResponse build() {
            return new GetJourneyExecutionMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
