/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the "From" address for an email message that's sent to participants in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JourneyEmailMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<JourneyEmailMessage.Builder, JourneyEmailMessage> {
    private static final SdkField<String> FROM_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromAddress").getter(getter(JourneyEmailMessage::fromAddress)).setter(setter(Builder::fromAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fromAddress;

    private JourneyEmailMessage(BuilderImpl builder) {
        this.fromAddress = builder.fromAddress;
    }

    /**
     * <p>
     * The verified email address to send the email message from. The default address is the FromAddress specified for
     * the email channel for the application.
     * </p>
     * 
     * @return The verified email address to send the email message from. The default address is the FromAddress
     *         specified for the email channel for the application.
     */
    public final String fromAddress() {
        return fromAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JourneyEmailMessage)) {
            return false;
        }
        JourneyEmailMessage other = (JourneyEmailMessage) obj;
        return Objects.equals(fromAddress(), other.fromAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JourneyEmailMessage").add("FromAddress", fromAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromAddress":
            return Optional.ofNullable(clazz.cast(fromAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JourneyEmailMessage, T> g) {
        return obj -> g.apply((JourneyEmailMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JourneyEmailMessage> {
        /**
         * <p>
         * The verified email address to send the email message from. The default address is the FromAddress specified
         * for the email channel for the application.
         * </p>
         * 
         * @param fromAddress
         *        The verified email address to send the email message from. The default address is the FromAddress
         *        specified for the email channel for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromAddress(String fromAddress);
    }

    static final class BuilderImpl implements Builder {
        private String fromAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(JourneyEmailMessage model) {
            fromAddress(model.fromAddress);
        }

        public final String getFromAddress() {
            return fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        @Override
        public JourneyEmailMessage build() {
            return new JourneyEmailMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
