/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberValidateResponse extends PinpointResponse implements
        ToCopyableBuilder<PhoneNumberValidateResponse.Builder, PhoneNumberValidateResponse> {
    private static final SdkField<NumberValidateResponse> NUMBER_VALIDATE_RESPONSE_FIELD = SdkField
            .<NumberValidateResponse> builder(MarshallingType.SDK_POJO)
            .memberName("NumberValidateResponse")
            .getter(getter(PhoneNumberValidateResponse::numberValidateResponse))
            .setter(setter(Builder::numberValidateResponse))
            .constructor(NumberValidateResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValidateResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(NUMBER_VALIDATE_RESPONSE_FIELD));

    private final NumberValidateResponse numberValidateResponse;

    private PhoneNumberValidateResponse(BuilderImpl builder) {
        super(builder);
        this.numberValidateResponse = builder.numberValidateResponse;
    }

    /**
     * Returns the value of the NumberValidateResponse property for this object.
     * 
     * @return The value of the NumberValidateResponse property for this object.
     */
    public final NumberValidateResponse numberValidateResponse() {
        return numberValidateResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(numberValidateResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberValidateResponse)) {
            return false;
        }
        PhoneNumberValidateResponse other = (PhoneNumberValidateResponse) obj;
        return Objects.equals(numberValidateResponse(), other.numberValidateResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhoneNumberValidateResponse").add("NumberValidateResponse", numberValidateResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberValidateResponse":
            return Optional.ofNullable(clazz.cast(numberValidateResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberValidateResponse, T> g) {
        return obj -> g.apply((PhoneNumberValidateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, PhoneNumberValidateResponse> {
        /**
         * Sets the value of the NumberValidateResponse property for this object.
         *
         * @param numberValidateResponse
         *        The new value for the NumberValidateResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValidateResponse(NumberValidateResponse numberValidateResponse);

        /**
         * Sets the value of the NumberValidateResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link NumberValidateResponse.Builder} avoiding the
         * need to create one manually via {@link NumberValidateResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link NumberValidateResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #numberValidateResponse(NumberValidateResponse)}.
         * 
         * @param numberValidateResponse
         *        a consumer that will call methods on {@link NumberValidateResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numberValidateResponse(NumberValidateResponse)
         */
        default Builder numberValidateResponse(Consumer<NumberValidateResponse.Builder> numberValidateResponse) {
            return numberValidateResponse(NumberValidateResponse.builder().applyMutation(numberValidateResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private NumberValidateResponse numberValidateResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberValidateResponse model) {
            super(model);
            numberValidateResponse(model.numberValidateResponse);
        }

        public final NumberValidateResponse.Builder getNumberValidateResponse() {
            return numberValidateResponse != null ? numberValidateResponse.toBuilder() : null;
        }

        @Override
        public final Builder numberValidateResponse(NumberValidateResponse numberValidateResponse) {
            this.numberValidateResponse = numberValidateResponse;
            return this;
        }

        public final void setNumberValidateResponse(NumberValidateResponse.BuilderImpl numberValidateResponse) {
            this.numberValidateResponse = numberValidateResponse != null ? numberValidateResponse.build() : null;
        }

        @Override
        public PhoneNumberValidateResponse build() {
            return new PhoneNumberValidateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
