/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the settings for a random split activity in a journey. This type of activity randomly sends specified
 * percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RandomSplitActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<RandomSplitActivity.Builder, RandomSplitActivity> {
    private static final SdkField<List<RandomSplitEntry>> BRANCHES_FIELD = SdkField
            .<List<RandomSplitEntry>> builder(MarshallingType.LIST)
            .memberName("Branches")
            .getter(getter(RandomSplitActivity::branches))
            .setter(setter(Builder::branches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RandomSplitEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(RandomSplitEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCHES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RandomSplitEntry> branches;

    private RandomSplitActivity(BuilderImpl builder) {
        this.branches = builder.branches;
    }

    /**
     * Returns true if the Branches property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasBranches() {
        return branches != null && !(branches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The paths for the activity, including the percentage of participants to enter each path and the activity to
     * perform for each path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBranches()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The paths for the activity, including the percentage of participants to enter each path and the activity
     *         to perform for each path.
     */
    public final List<RandomSplitEntry> branches() {
        return branches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBranches() ? branches() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RandomSplitActivity)) {
            return false;
        }
        RandomSplitActivity other = (RandomSplitActivity) obj;
        return hasBranches() == other.hasBranches() && Objects.equals(branches(), other.branches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RandomSplitActivity").add("Branches", hasBranches() ? branches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Branches":
            return Optional.ofNullable(clazz.cast(branches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RandomSplitActivity, T> g) {
        return obj -> g.apply((RandomSplitActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RandomSplitActivity> {
        /**
         * <p>
         * The paths for the activity, including the percentage of participants to enter each path and the activity to
         * perform for each path.
         * </p>
         * 
         * @param branches
         *        The paths for the activity, including the percentage of participants to enter each path and the
         *        activity to perform for each path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(Collection<RandomSplitEntry> branches);

        /**
         * <p>
         * The paths for the activity, including the percentage of participants to enter each path and the activity to
         * perform for each path.
         * </p>
         * 
         * @param branches
         *        The paths for the activity, including the percentage of participants to enter each path and the
         *        activity to perform for each path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branches(RandomSplitEntry... branches);

        /**
         * <p>
         * The paths for the activity, including the percentage of participants to enter each path and the activity to
         * perform for each path.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RandomSplitEntry>.Builder} avoiding the
         * need to create one manually via {@link List<RandomSplitEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RandomSplitEntry>.Builder#build()} is called immediately and
         * its result is passed to {@link #branches(List<RandomSplitEntry>)}.
         * 
         * @param branches
         *        a consumer that will call methods on {@link List<RandomSplitEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #branches(List<RandomSplitEntry>)
         */
        Builder branches(Consumer<RandomSplitEntry.Builder>... branches);
    }

    static final class BuilderImpl implements Builder {
        private List<RandomSplitEntry> branches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RandomSplitActivity model) {
            branches(model.branches);
        }

        public final Collection<RandomSplitEntry.Builder> getBranches() {
            if (branches instanceof SdkAutoConstructList) {
                return null;
            }
            return branches != null ? branches.stream().map(RandomSplitEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder branches(Collection<RandomSplitEntry> branches) {
            this.branches = ListOfRandomSplitEntryCopier.copy(branches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(RandomSplitEntry... branches) {
            branches(Arrays.asList(branches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder branches(Consumer<RandomSplitEntry.Builder>... branches) {
            branches(Stream.of(branches).map(c -> RandomSplitEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBranches(Collection<RandomSplitEntry.BuilderImpl> branches) {
            this.branches = ListOfRandomSplitEntryCopier.copyFromBuilder(branches);
        }

        @Override
        public RandomSplitActivity build() {
            return new RandomSplitActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
