/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a condition to evaluate for an activity in a journey.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimpleCondition implements SdkPojo, Serializable, ToCopyableBuilder<SimpleCondition.Builder, SimpleCondition> {
    private static final SdkField<EventCondition> EVENT_CONDITION_FIELD = SdkField
            .<EventCondition> builder(MarshallingType.SDK_POJO).memberName("EventCondition")
            .getter(getter(SimpleCondition::eventCondition)).setter(setter(Builder::eventCondition))
            .constructor(EventCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCondition").build()).build();

    private static final SdkField<SegmentCondition> SEGMENT_CONDITION_FIELD = SdkField
            .<SegmentCondition> builder(MarshallingType.SDK_POJO).memberName("SegmentCondition")
            .getter(getter(SimpleCondition::segmentCondition)).setter(setter(Builder::segmentCondition))
            .constructor(SegmentCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentCondition").build()).build();

    private static final SdkField<SegmentDimensions> SEGMENT_DIMENSIONS_FIELD = SdkField
            .<SegmentDimensions> builder(MarshallingType.SDK_POJO).memberName("SegmentDimensions")
            .getter(getter(SimpleCondition::segmentDimensions)).setter(setter(Builder::segmentDimensions))
            .constructor(SegmentDimensions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDimensions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CONDITION_FIELD,
            SEGMENT_CONDITION_FIELD, SEGMENT_DIMENSIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final EventCondition eventCondition;

    private final SegmentCondition segmentCondition;

    private final SegmentDimensions segmentDimensions;

    private SimpleCondition(BuilderImpl builder) {
        this.eventCondition = builder.eventCondition;
        this.segmentCondition = builder.segmentCondition;
        this.segmentDimensions = builder.segmentDimensions;
    }

    /**
     * <p>
     * The dimension settings for the event that's associated with the activity.
     * </p>
     * 
     * @return The dimension settings for the event that's associated with the activity.
     */
    public final EventCondition eventCondition() {
        return eventCondition;
    }

    /**
     * <p>
     * The segment that's associated with the activity.
     * </p>
     * 
     * @return The segment that's associated with the activity.
     */
    public final SegmentCondition segmentCondition() {
        return segmentCondition;
    }

    /**
     * <p>
     * The dimension settings for the segment that's associated with the activity.
     * </p>
     * 
     * @return The dimension settings for the segment that's associated with the activity.
     */
    public final SegmentDimensions segmentDimensions() {
        return segmentDimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventCondition());
        hashCode = 31 * hashCode + Objects.hashCode(segmentCondition());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDimensions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleCondition)) {
            return false;
        }
        SimpleCondition other = (SimpleCondition) obj;
        return Objects.equals(eventCondition(), other.eventCondition())
                && Objects.equals(segmentCondition(), other.segmentCondition())
                && Objects.equals(segmentDimensions(), other.segmentDimensions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SimpleCondition").add("EventCondition", eventCondition())
                .add("SegmentCondition", segmentCondition()).add("SegmentDimensions", segmentDimensions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventCondition":
            return Optional.ofNullable(clazz.cast(eventCondition()));
        case "SegmentCondition":
            return Optional.ofNullable(clazz.cast(segmentCondition()));
        case "SegmentDimensions":
            return Optional.ofNullable(clazz.cast(segmentDimensions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleCondition, T> g) {
        return obj -> g.apply((SimpleCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimpleCondition> {
        /**
         * <p>
         * The dimension settings for the event that's associated with the activity.
         * </p>
         * 
         * @param eventCondition
         *        The dimension settings for the event that's associated with the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCondition(EventCondition eventCondition);

        /**
         * <p>
         * The dimension settings for the event that's associated with the activity.
         * </p>
         * This is a convenience that creates an instance of the {@link EventCondition.Builder} avoiding the need to
         * create one manually via {@link EventCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #eventCondition(EventCondition)}.
         * 
         * @param eventCondition
         *        a consumer that will call methods on {@link EventCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventCondition(EventCondition)
         */
        default Builder eventCondition(Consumer<EventCondition.Builder> eventCondition) {
            return eventCondition(EventCondition.builder().applyMutation(eventCondition).build());
        }

        /**
         * <p>
         * The segment that's associated with the activity.
         * </p>
         * 
         * @param segmentCondition
         *        The segment that's associated with the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentCondition(SegmentCondition segmentCondition);

        /**
         * <p>
         * The segment that's associated with the activity.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentCondition.Builder} avoiding the need to
         * create one manually via {@link SegmentCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentCondition(SegmentCondition)}.
         * 
         * @param segmentCondition
         *        a consumer that will call methods on {@link SegmentCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentCondition(SegmentCondition)
         */
        default Builder segmentCondition(Consumer<SegmentCondition.Builder> segmentCondition) {
            return segmentCondition(SegmentCondition.builder().applyMutation(segmentCondition).build());
        }

        /**
         * <p>
         * The dimension settings for the segment that's associated with the activity.
         * </p>
         * 
         * @param segmentDimensions
         *        The dimension settings for the segment that's associated with the activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDimensions(SegmentDimensions segmentDimensions);

        /**
         * <p>
         * The dimension settings for the segment that's associated with the activity.
         * </p>
         * This is a convenience that creates an instance of the {@link SegmentDimensions.Builder} avoiding the need to
         * create one manually via {@link SegmentDimensions#builder()}.
         *
         * When the {@link Consumer} completes, {@link SegmentDimensions.Builder#build()} is called immediately and its
         * result is passed to {@link #segmentDimensions(SegmentDimensions)}.
         * 
         * @param segmentDimensions
         *        a consumer that will call methods on {@link SegmentDimensions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentDimensions(SegmentDimensions)
         */
        default Builder segmentDimensions(Consumer<SegmentDimensions.Builder> segmentDimensions) {
            return segmentDimensions(SegmentDimensions.builder().applyMutation(segmentDimensions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EventCondition eventCondition;

        private SegmentCondition segmentCondition;

        private SegmentDimensions segmentDimensions;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleCondition model) {
            eventCondition(model.eventCondition);
            segmentCondition(model.segmentCondition);
            segmentDimensions(model.segmentDimensions);
        }

        public final EventCondition.Builder getEventCondition() {
            return eventCondition != null ? eventCondition.toBuilder() : null;
        }

        @Override
        public final Builder eventCondition(EventCondition eventCondition) {
            this.eventCondition = eventCondition;
            return this;
        }

        public final void setEventCondition(EventCondition.BuilderImpl eventCondition) {
            this.eventCondition = eventCondition != null ? eventCondition.build() : null;
        }

        public final SegmentCondition.Builder getSegmentCondition() {
            return segmentCondition != null ? segmentCondition.toBuilder() : null;
        }

        @Override
        public final Builder segmentCondition(SegmentCondition segmentCondition) {
            this.segmentCondition = segmentCondition;
            return this;
        }

        public final void setSegmentCondition(SegmentCondition.BuilderImpl segmentCondition) {
            this.segmentCondition = segmentCondition != null ? segmentCondition.build() : null;
        }

        public final SegmentDimensions.Builder getSegmentDimensions() {
            return segmentDimensions != null ? segmentDimensions.toBuilder() : null;
        }

        @Override
        public final Builder segmentDimensions(SegmentDimensions segmentDimensions) {
            this.segmentDimensions = segmentDimensions;
            return this;
        }

        public final void setSegmentDimensions(SegmentDimensions.BuilderImpl segmentDimensions) {
            this.segmentDimensions = segmentDimensions != null ? segmentDimensions.build() : null;
        }

        @Override
        public SimpleCondition build() {
            return new SimpleCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
