/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AssociationStatusAggregatedCountCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociationOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociationOverview> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AssociationOverview.getter(AssociationOverview::status)).setter(AssociationOverview.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailedStatus").getter(AssociationOverview.getter(AssociationOverview::detailedStatus)).setter(AssociationOverview.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final SdkField<Map<String, Integer>> ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AssociationStatusAggregatedCount").getter(AssociationOverview.getter(AssociationOverview::associationStatusAggregatedCount)).setter(AssociationOverview.setter(Builder::associationStatusAggregatedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationStatusAggregatedCount").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, DETAILED_STATUS_FIELD, ASSOCIATION_STATUS_AGGREGATED_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String detailedStatus;
    private final Map<String, Integer> associationStatusAggregatedCount;

    private AssociationOverview(BuilderImpl builder) {
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.associationStatusAggregatedCount = builder.associationStatusAggregatedCount;
    }

    public final String status() {
        return this.status;
    }

    public final String detailedStatus() {
        return this.detailedStatus;
    }

    public final boolean hasAssociationStatusAggregatedCount() {
        return this.associationStatusAggregatedCount != null && !(this.associationStatusAggregatedCount instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> associationStatusAggregatedCount() {
        return this.associationStatusAggregatedCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociationStatusAggregatedCount() ? this.associationStatusAggregatedCount() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationOverview)) {
            return false;
        }
        AssociationOverview other = (AssociationOverview)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.detailedStatus(), other.detailedStatus()) && this.hasAssociationStatusAggregatedCount() == other.hasAssociationStatusAggregatedCount() && Objects.equals(this.associationStatusAggregatedCount(), other.associationStatusAggregatedCount());
    }

    public final String toString() {
        return ToString.builder((String)"AssociationOverview").add("Status", (Object)this.status()).add("DetailedStatus", (Object)this.detailedStatus()).add("AssociationStatusAggregatedCount", this.hasAssociationStatusAggregatedCount() ? this.associationStatusAggregatedCount() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatus()));
            }
            case "AssociationStatusAggregatedCount": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAggregatedCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationOverview, T> g) {
        return obj -> g.apply((AssociationOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String detailedStatus;
        private Map<String, Integer> associationStatusAggregatedCount = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationOverview model) {
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.associationStatusAggregatedCount(model.associationStatusAggregatedCount);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final Map<String, Integer> getAssociationStatusAggregatedCount() {
            if (this.associationStatusAggregatedCount instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.associationStatusAggregatedCount;
        }

        @Override
        public final Builder associationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
            return this;
        }

        public final void setAssociationStatusAggregatedCount(Map<String, Integer> associationStatusAggregatedCount) {
            this.associationStatusAggregatedCount = AssociationStatusAggregatedCountCopier.copy(associationStatusAggregatedCount);
        }

        public AssociationOverview build() {
            return new AssociationOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociationOverview> {
        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder associationStatusAggregatedCount(Map<String, Integer> var1);
    }
}

