/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.Patch;
import software.amazon.awssdk.services.ssm.model.PatchListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAvailablePatchesResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
    private static final SdkField<List<Patch>> PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Patches").getter(DescribeAvailablePatchesResponse.getter(DescribeAvailablePatchesResponse::patches)).setter(DescribeAvailablePatchesResponse.setter(Builder::patches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Patch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAvailablePatchesResponse.getter(DescribeAvailablePatchesResponse::nextToken)).setter(DescribeAvailablePatchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCHES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Patch> patches;
    private final String nextToken;

    private DescribeAvailablePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPatches() {
        return this.patches != null && !(this.patches instanceof SdkAutoConstructList);
    }

    public final List<Patch> patches() {
        return this.patches;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPatches() ? this.patches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailablePatchesResponse)) {
            return false;
        }
        DescribeAvailablePatchesResponse other = (DescribeAvailablePatchesResponse)((Object)obj);
        return this.hasPatches() == other.hasPatches() && Objects.equals(this.patches(), other.patches()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAvailablePatchesResponse").add("Patches", this.hasPatches() ? this.patches() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Patches": {
                return Optional.ofNullable(clazz.cast(this.patches()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAvailablePatchesResponse, T> g) {
        return obj -> g.apply((DescribeAvailablePatchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<Patch> patches = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailablePatchesResponse model) {
            super(model);
            this.patches(model.patches);
            this.nextToken(model.nextToken);
        }

        public final Collection<Patch.Builder> getPatches() {
            if (this.patches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.patches != null ? (Collection)this.patches.stream().map(Patch::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patches(Collection<Patch> patches) {
            this.patches = PatchListCopier.copy(patches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Patch ... patches) {
            this.patches(Arrays.asList(patches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patches(Consumer<Patch.Builder> ... patches) {
            this.patches(Stream.of(patches).map(c -> (Patch)((Patch.Builder)Patch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatches(Collection<Patch.BuilderImpl> patches) {
            this.patches = PatchListCopier.copyFromBuilder(patches);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAvailablePatchesResponse build() {
            return new DescribeAvailablePatchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
        public Builder patches(Collection<Patch> var1);

        public Builder patches(Patch ... var1);

        public Builder patches(Consumer<Patch.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

