/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tlddoc;

import com.sun.tlddoc.GeneratorException;
import com.sun.tlddoc.TagLibrary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JARTLDFileTagLibrary
extends TagLibrary {
    private File jar;
    private String tldPath;

    public JARTLDFileTagLibrary(File jar, String tldPath) {
        this.jar = jar;
        this.tldPath = tldPath;
    }

    public String getPathDescription() {
        return this.jar.getAbsolutePath() + "!" + this.tldPath;
    }

    public InputStream getResource(String path) throws IOException {
        JarFile jarFile;
        JarEntry jarEntry;
        InputStream result = null;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((jarEntry = (jarFile = new JarFile(this.jar)).getJarEntry(path)) != null) {
            result = jarFile.getInputStream(jarEntry);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getTLDDocument(DocumentBuilder documentBuilder) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException, GeneratorException {
        Document result = null;
        JarFile jarFile = new JarFile(this.jar);
        JarEntry jarEntry = jarFile.getJarEntry(this.tldPath);
        if (jarEntry != null) {
            InputStream in = jarFile.getInputStream(jarEntry);
            try {
                InputSource source = new InputSource(in);
                result = documentBuilder.parse(source);
            }
            finally {
                in.close();
            }
        }
        jarFile.close();
        return result;
    }
}

