// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.endpoints

import aws.sdk.kotlin.runtime.endpoint.functions.isVirtualHostableS3Bucket
import aws.sdk.kotlin.runtime.endpoint.functions.parseArn
import aws.sdk.kotlin.services.s3.endpoints.internal.partition
import aws.sdk.kotlin.services.s3.express.sigV4S3Express
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.client.endpoints.functions.isValidHostLabel
import aws.smithy.kotlin.runtime.client.endpoints.functions.parseUrl
import aws.smithy.kotlin.runtime.client.endpoints.functions.substring
import aws.smithy.kotlin.runtime.client.endpoints.functions.uriEncode
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.http.auth.sigV4
import aws.smithy.kotlin.runtime.http.auth.sigV4A
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultS3EndpointProvider: S3EndpointProvider {
    public override suspend fun resolveEndpoint(params: S3EndpointParameters): Endpoint {
        if (
            params.region != null
        ) {
            if (
                params.accelerate == true &&
                params.useFips == true
            ) {
                throw EndpointProviderException("Accelerate cannot be used with FIPS")
            }
            if (
                params.useDualStack == true &&
                params.endpoint != null
            ) {
                throw EndpointProviderException("Cannot set dual-stack in combination with a custom endpoint.")
            }
            if (
                params.endpoint != null &&
                params.useFips == true
            ) {
                throw EndpointProviderException("A custom endpoint cannot be combined with FIPS")
            }
            if (
                params.endpoint != null &&
                params.accelerate == true
            ) {
                throw EndpointProviderException("A custom endpoint cannot be combined with S3 Accelerate")
            }
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null &&
                    params.useFips == true &&
                    partitionResult?.name == "aws-cn"
                ) {
                    throw EndpointProviderException("Partition does not support FIPS")
                }
            }
            run {
                val bucketSuffix = substring(params.bucket, 0, 6, true)
                if (
                    bucketSuffix != null &&
                    params.bucket != null &&
                    bucketSuffix == "--x-s3"
                ) {
                    if (
                        params.useDualStack == true
                    ) {
                        throw EndpointProviderException("S3Express does not support Dual-stack.")
                    }
                    if (
                        params.accelerate == true
                    ) {
                        throw EndpointProviderException("S3Express does not support S3 Accelerate.")
                    }
                    run {
                        val url = parseUrl(params.endpoint)
                        if (
                            url != null &&
                            params.endpoint != null
                        ) {
                            if (
                                params.disableS3ExpressSessionAuth != null &&
                                params.disableS3ExpressSessionAuth == true
                            ) {
                                if (
                                    url?.isIp == true
                                ) {
                                    run {
                                        val uriEncodedBucket = uriEncode(params.bucket)
                                        if (
                                            uriEncodedBucket != null
                                        ) {
                                            return Endpoint(
                                                Url.parse("${url?.scheme}://${url?.authority}/${uriEncodedBucket}${url?.path}"),
                                                attributes = attributesOf {
                                                    "backend" to "S3Express"
                                                    SigningContextAttributeKey to listOf(
                                                        sigV4(
                                                            serviceName = "s3express",
                                                            disableDoubleUriEncode = true,
                                                            signingRegion = "${params.region}",
                                                        ),
                                                    )
                                                },
                                            )
                                        }
                                    }
                                }
                                if (
                                    isVirtualHostableS3Bucket(params.bucket, false)
                                ) {
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${params.bucket}.${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            "backend" to "S3Express"
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3express",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                throw EndpointProviderException("S3Express bucket name is not a valid virtual hostable name.")
                            }
                            if (
                                url?.isIp == true
                            ) {
                                run {
                                    val uriEncodedBucket = uriEncode(params.bucket)
                                    if (
                                        uriEncodedBucket != null
                                    ) {
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${url?.authority}/${uriEncodedBucket}${url?.path}"),
                                            attributes = attributesOf {
                                                "backend" to "S3Express"
                                                SigningContextAttributeKey to listOf(
                                                    sigV4S3Express(
                                                        serviceName = "s3express",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                            }
                            if (
                                isVirtualHostableS3Bucket(params.bucket, false)
                            ) {
                                return Endpoint(
                                    Url.parse("${url?.scheme}://${params.bucket}.${url?.authority}${url?.path}"),
                                    attributes = attributesOf {
                                        "backend" to "S3Express"
                                        SigningContextAttributeKey to listOf(
                                            sigV4S3Express(
                                                serviceName = "s3express",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            throw EndpointProviderException("S3Express bucket name is not a valid virtual hostable name.")
                        }
                    }
                    if (
                        params.useS3ExpressControlEndpoint != null &&
                        params.useS3ExpressControlEndpoint == true
                    ) {
                        run {
                            val uriEncodedBucket = uriEncode(params.bucket)
                            if (
                                uriEncodedBucket != null &&
                                !(params.endpoint != null)
                            ) {
                                if (
                                    params.useFips == true
                                ) {
                                    return Endpoint(
                                        Url.parse("https://s3express-control-fips.${params.region}.amazonaws.com/${uriEncodedBucket}"),
                                        attributes = attributesOf {
                                            "backend" to "S3Express"
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3express",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                return Endpoint(
                                    Url.parse("https://s3express-control.${params.region}.amazonaws.com/${uriEncodedBucket}"),
                                    attributes = attributesOf {
                                        "backend" to "S3Express"
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3express",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                        }
                    }
                    if (
                        isVirtualHostableS3Bucket(params.bucket, false)
                    ) {
                        if (
                            params.disableS3ExpressSessionAuth != null &&
                            params.disableS3ExpressSessionAuth == true
                        ) {
                            run {
                                val s3ExpressAvailabilityZoneId = substring(params.bucket, 6, 14, true)
                                val s3ExpressAvailabilityZoneDelim = substring(params.bucket, 14, 16, true)
                                if (
                                    s3ExpressAvailabilityZoneId != null &&
                                    s3ExpressAvailabilityZoneDelim != null &&
                                    s3ExpressAvailabilityZoneDelim == "--"
                                ) {
                                    if (
                                        params.useFips == true
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://${params.bucket}.s3express-fips-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                            attributes = attributesOf {
                                                "backend" to "S3Express"
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3express",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3express-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                        attributes = attributesOf {
                                            "backend" to "S3Express"
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3express",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            run {
                                val s3ExpressAvailabilityZoneId = substring(params.bucket, 6, 15, true)
                                val s3ExpressAvailabilityZoneDelim = substring(params.bucket, 15, 17, true)
                                if (
                                    s3ExpressAvailabilityZoneId != null &&
                                    s3ExpressAvailabilityZoneDelim != null &&
                                    s3ExpressAvailabilityZoneDelim == "--"
                                ) {
                                    if (
                                        params.useFips == true
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://${params.bucket}.s3express-fips-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                            attributes = attributesOf {
                                                "backend" to "S3Express"
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3express",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3express-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                        attributes = attributesOf {
                                            "backend" to "S3Express"
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3express",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            throw EndpointProviderException("Unrecognized S3Express bucket name format.")
                        }
                        run {
                            val s3ExpressAvailabilityZoneId = substring(params.bucket, 6, 14, true)
                            val s3ExpressAvailabilityZoneDelim = substring(params.bucket, 14, 16, true)
                            if (
                                s3ExpressAvailabilityZoneId != null &&
                                s3ExpressAvailabilityZoneDelim != null &&
                                s3ExpressAvailabilityZoneDelim == "--"
                            ) {
                                if (
                                    params.useFips == true
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3express-fips-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                        attributes = attributesOf {
                                            "backend" to "S3Express"
                                            SigningContextAttributeKey to listOf(
                                                sigV4S3Express(
                                                    serviceName = "s3express",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                return Endpoint(
                                    Url.parse("https://${params.bucket}.s3express-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                    attributes = attributesOf {
                                        "backend" to "S3Express"
                                        SigningContextAttributeKey to listOf(
                                            sigV4S3Express(
                                                serviceName = "s3express",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                        }
                        run {
                            val s3ExpressAvailabilityZoneId = substring(params.bucket, 6, 15, true)
                            val s3ExpressAvailabilityZoneDelim = substring(params.bucket, 15, 17, true)
                            if (
                                s3ExpressAvailabilityZoneId != null &&
                                s3ExpressAvailabilityZoneDelim != null &&
                                s3ExpressAvailabilityZoneDelim == "--"
                            ) {
                                if (
                                    params.useFips == true
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3express-fips-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                        attributes = attributesOf {
                                            "backend" to "S3Express"
                                            SigningContextAttributeKey to listOf(
                                                sigV4S3Express(
                                                    serviceName = "s3express",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                return Endpoint(
                                    Url.parse("https://${params.bucket}.s3express-${s3ExpressAvailabilityZoneId}.${params.region}.amazonaws.com"),
                                    attributes = attributesOf {
                                        "backend" to "S3Express"
                                        SigningContextAttributeKey to listOf(
                                            sigV4S3Express(
                                                serviceName = "s3express",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                        }
                        throw EndpointProviderException("Unrecognized S3Express bucket name format.")
                    }
                    throw EndpointProviderException("S3Express bucket name is not a valid virtual hostable name.")
                }
            }
            if (
                !(params.bucket != null) &&
                params.useS3ExpressControlEndpoint != null &&
                params.useS3ExpressControlEndpoint == true
            ) {
                run {
                    val url = parseUrl(params.endpoint)
                    if (
                        url != null &&
                        params.endpoint != null
                    ) {
                        return Endpoint(
                            Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                            attributes = attributesOf {
                                "backend" to "S3Express"
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = "s3express",
                                        disableDoubleUriEncode = true,
                                        signingRegion = "${params.region}",
                                    ),
                                )
                            },
                        )
                    }
                }
                if (
                    params.useFips == true
                ) {
                    return Endpoint(
                        Url.parse("https://s3express-control-fips.${params.region}.amazonaws.com"),
                        attributes = attributesOf {
                            "backend" to "S3Express"
                            SigningContextAttributeKey to listOf(
                                sigV4(
                                    serviceName = "s3express",
                                    disableDoubleUriEncode = true,
                                    signingRegion = "${params.region}",
                                ),
                            )
                        },
                    )
                }
                return Endpoint(
                    Url.parse("https://s3express-control.${params.region}.amazonaws.com"),
                    attributes = attributesOf {
                        "backend" to "S3Express"
                        SigningContextAttributeKey to listOf(
                            sigV4(
                                serviceName = "s3express",
                                disableDoubleUriEncode = true,
                                signingRegion = "${params.region}",
                            ),
                        )
                    },
                )
            }
            run {
                val hardwareType = substring(params.bucket, 49, 50, true)
                val regionPrefix = substring(params.bucket, 8, 12, true)
                val bucketAliasSuffix = substring(params.bucket, 0, 7, true)
                val outpostId = substring(params.bucket, 32, 49, true)
                val regionPartition = partition(params.region)
                if (
                    hardwareType != null &&
                    regionPrefix != null &&
                    bucketAliasSuffix != null &&
                    outpostId != null &&
                    regionPartition != null &&
                    params.bucket != null &&
                    bucketAliasSuffix == "--op-s3"
                ) {
                    if (
                        isValidHostLabel(outpostId, false)
                    ) {
                        if (
                            hardwareType == "e"
                        ) {
                            if (
                                regionPrefix == "beta"
                            ) {
                                if (
                                    !(params.endpoint != null)
                                ) {
                                    throw EndpointProviderException("Expected a endpoint to be specified but no endpoint was found")
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.endpoint != null
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://${params.bucket}.ec2.${url?.authority}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3-outposts",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                            }
                            return Endpoint(
                                Url.parse("https://${params.bucket}.ec2.s3-outposts.${params.region}.${regionPartition?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3-outposts",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                        if (
                            hardwareType == "o"
                        ) {
                            if (
                                regionPrefix == "beta"
                            ) {
                                if (
                                    !(params.endpoint != null)
                                ) {
                                    throw EndpointProviderException("Expected a endpoint to be specified but no endpoint was found")
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.endpoint != null
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://${params.bucket}.op-${outpostId}.${url?.authority}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3-outposts",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                            }
                            return Endpoint(
                                Url.parse("https://${params.bucket}.op-${outpostId}.s3-outposts.${params.region}.${regionPartition?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3-outposts",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("Unrecognized hardware type: \"Expected hardware type o or e but got ${hardwareType}\"")
                    }
                    throw EndpointProviderException("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`.")
                }
            }
            if (
                params.bucket != null
            ) {
                if (
                    params.endpoint != null &&
                    !(parseUrl(params.endpoint) != null)
                ) {
                    throw EndpointProviderException("Custom endpoint `${params.endpoint}` was not a valid URI")
                }
                if (
                    params.forcePathStyle == false &&
                    isVirtualHostableS3Bucket(params.bucket, false)
                ) {
                    run {
                        val partitionResult = partition(params.region)
                        if (
                            partitionResult != null
                        ) {
                            if (
                                isValidHostLabel(params.region, false)
                            ) {
                                if (
                                    params.accelerate == true &&
                                    partitionResult?.name == "aws-cn"
                                ) {
                                    throw EndpointProviderException("S3 Accelerate cannot be used in this region")
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == true &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    params.region == "aws-global"
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-fips.dualstack.us-east-1.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "us-east-1",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == true &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == true
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == true &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == false
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == true &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    params.region == "aws-global"
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-fips.us-east-1.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "us-east-1",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == true &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == true
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == true &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == false
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == false &&
                                    params.accelerate == true &&
                                    !(params.endpoint != null) &&
                                    params.region == "aws-global"
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-accelerate.dualstack.us-east-1.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "us-east-1",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == false &&
                                    params.accelerate == true &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == true
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-accelerate.dualstack.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == false &&
                                    params.accelerate == true &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == false
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-accelerate.dualstack.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == false &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    params.region == "aws-global"
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3.dualstack.us-east-1.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "us-east-1",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == false &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == true
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == true &&
                                    params.useFips == false &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == false
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.useDualStack == false &&
                                        params.useFips == false &&
                                        params.accelerate == false &&
                                        params.endpoint != null &&
                                        url?.isIp == true &&
                                        params.region == "aws-global"
                                    ) {
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${params.bucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "us-east-1",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.useDualStack == false &&
                                        params.useFips == false &&
                                        params.accelerate == false &&
                                        params.endpoint != null &&
                                        url?.isIp == false &&
                                        params.region == "aws-global"
                                    ) {
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${params.bucket}.${url?.authority}${url?.path}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "us-east-1",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.useDualStack == false &&
                                        params.useFips == false &&
                                        params.accelerate == false &&
                                        params.endpoint != null &&
                                        url?.isIp == true &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == true
                                    ) {
                                        if (
                                            params.region == "us-east-1"
                                        ) {
                                            return Endpoint(
                                                Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${params.bucket}"),
                                                attributes = attributesOf {
                                                    SigningContextAttributeKey to listOf(
                                                        sigV4(
                                                            serviceName = "s3",
                                                            disableDoubleUriEncode = true,
                                                            signingRegion = "${params.region}",
                                                        ),
                                                    )
                                                },
                                            )
                                        }
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${params.bucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.useDualStack == false &&
                                        params.useFips == false &&
                                        params.accelerate == false &&
                                        params.endpoint != null &&
                                        url?.isIp == false &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == true
                                    ) {
                                        if (
                                            params.region == "us-east-1"
                                        ) {
                                            return Endpoint(
                                                Url.parse("${url?.scheme}://${params.bucket}.${url?.authority}${url?.path}"),
                                                attributes = attributesOf {
                                                    SigningContextAttributeKey to listOf(
                                                        sigV4(
                                                            serviceName = "s3",
                                                            disableDoubleUriEncode = true,
                                                            signingRegion = "${params.region}",
                                                        ),
                                                    )
                                                },
                                            )
                                        }
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${params.bucket}.${url?.authority}${url?.path}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.useDualStack == false &&
                                        params.useFips == false &&
                                        params.accelerate == false &&
                                        params.endpoint != null &&
                                        url?.isIp == true &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == false
                                    ) {
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${params.bucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                                run {
                                    val url = parseUrl(params.endpoint)
                                    if (
                                        url != null &&
                                        params.useDualStack == false &&
                                        params.useFips == false &&
                                        params.accelerate == false &&
                                        params.endpoint != null &&
                                        url?.isIp == false &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == false
                                    ) {
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${params.bucket}.${url?.authority}${url?.path}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == false &&
                                    params.accelerate == true &&
                                    !(params.endpoint != null) &&
                                    params.region == "aws-global"
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-accelerate.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "us-east-1",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == false &&
                                    params.accelerate == true &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == true
                                ) {
                                    if (
                                        params.region == "us-east-1"
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://${params.bucket}.s3-accelerate.${partitionResult?.dnsSuffix}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-accelerate.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == false &&
                                    params.accelerate == true &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == false
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3-accelerate.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == false &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    params.region == "aws-global"
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "us-east-1",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == false &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == true
                                ) {
                                    if (
                                        params.region == "us-east-1"
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://${params.bucket}.s3.${partitionResult?.dnsSuffix}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                if (
                                    params.useDualStack == false &&
                                    params.useFips == false &&
                                    params.accelerate == false &&
                                    !(params.endpoint != null) &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == false
                                ) {
                                    return Endpoint(
                                        Url.parse("https://${params.bucket}.s3.${params.region}.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            throw EndpointProviderException("Invalid region: region was not a valid DNS name.")
                        }
                    }
                }
                run {
                    val url = parseUrl(params.endpoint)
                    if (
                        url != null &&
                        params.endpoint != null &&
                        url?.scheme == "http" &&
                        isVirtualHostableS3Bucket(params.bucket, true) &&
                        params.forcePathStyle == false &&
                        params.useFips == false &&
                        params.useDualStack == false &&
                        params.accelerate == false
                    ) {
                        run {
                            val partitionResult = partition(params.region)
                            if (
                                partitionResult != null
                            ) {
                                if (
                                    isValidHostLabel(params.region, false)
                                ) {
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${params.bucket}.${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                throw EndpointProviderException("Invalid region: region was not a valid DNS name.")
                            }
                        }
                    }
                }
                run {
                    val bucketArn = parseArn(params.bucket)
                    if (
                        bucketArn != null &&
                        params.forcePathStyle == false
                    ) {
                        run {
                            val arnType = bucketArn?.resourceId?.getOrNull(0)
                            if (
                                arnType != null &&
                                !(arnType == "")
                            ) {
                                if (
                                    bucketArn?.service == "s3-object-lambda"
                                ) {
                                    if (
                                        arnType == "accesspoint"
                                    ) {
                                        run {
                                            val accessPointName = bucketArn?.resourceId?.getOrNull(1)
                                            if (
                                                accessPointName != null &&
                                                !(accessPointName == "")
                                            ) {
                                                if (
                                                    params.useDualStack == true
                                                ) {
                                                    throw EndpointProviderException("S3 Object Lambda does not support Dual-stack")
                                                }
                                                if (
                                                    params.accelerate == true
                                                ) {
                                                    throw EndpointProviderException("S3 Object Lambda does not support S3 Accelerate")
                                                }
                                                if (
                                                    !(bucketArn?.region == "")
                                                ) {
                                                    if (
                                                        params.disableAccessPoints != null &&
                                                        params.disableAccessPoints == true
                                                    ) {
                                                        throw EndpointProviderException("Access points are not supported for this operation")
                                                    }
                                                    if (
                                                        !(bucketArn?.resourceId?.getOrNull(2) != null)
                                                    ) {
                                                        if (
                                                            params.useArnRegion != null &&
                                                            params.useArnRegion == false &&
                                                            !(bucketArn?.region == "${params.region}")
                                                        ) {
                                                            throw EndpointProviderException("Invalid configuration: region from ARN `${bucketArn?.region}` does not match client region `${params.region}` and UseArnRegion is `false`")
                                                        }
                                                        run {
                                                            val bucketPartition = partition(bucketArn?.region)
                                                            if (
                                                                bucketPartition != null
                                                            ) {
                                                                run {
                                                                    val partitionResult = partition(params.region)
                                                                    if (
                                                                        partitionResult != null
                                                                    ) {
                                                                        if (
                                                                            bucketPartition?.name == partitionResult?.name
                                                                        ) {
                                                                            if (
                                                                                isValidHostLabel(bucketArn?.region, true)
                                                                            ) {
                                                                                if (
                                                                                    bucketArn?.accountId == ""
                                                                                ) {
                                                                                    throw EndpointProviderException("Invalid ARN: Missing account id")
                                                                                }
                                                                                if (
                                                                                    isValidHostLabel(bucketArn?.accountId, false)
                                                                                ) {
                                                                                    if (
                                                                                        isValidHostLabel(accessPointName, false)
                                                                                    ) {
                                                                                        run {
                                                                                            val url = parseUrl(params.endpoint)
                                                                                            if (
                                                                                                url != null &&
                                                                                                params.endpoint != null
                                                                                            ) {
                                                                                                return Endpoint(
                                                                                                    Url.parse("${url?.scheme}://${accessPointName}-${bucketArn?.accountId}.${url?.authority}${url?.path}"),
                                                                                                    attributes = attributesOf {
                                                                                                        SigningContextAttributeKey to listOf(
                                                                                                            sigV4(
                                                                                                                serviceName = "s3-object-lambda",
                                                                                                                disableDoubleUriEncode = true,
                                                                                                                signingRegion = "${bucketArn?.region}",
                                                                                                            ),
                                                                                                        )
                                                                                                    },
                                                                                                )
                                                                                            }
                                                                                        }
                                                                                        if (
                                                                                            params.useFips == true
                                                                                        ) {
                                                                                            return Endpoint(
                                                                                                Url.parse("https://${accessPointName}-${bucketArn?.accountId}.s3-object-lambda-fips.${bucketArn?.region}.${bucketPartition?.dnsSuffix}"),
                                                                                                attributes = attributesOf {
                                                                                                    SigningContextAttributeKey to listOf(
                                                                                                        sigV4(
                                                                                                            serviceName = "s3-object-lambda",
                                                                                                            disableDoubleUriEncode = true,
                                                                                                            signingRegion = "${bucketArn?.region}",
                                                                                                        ),
                                                                                                    )
                                                                                                },
                                                                                            )
                                                                                        }
                                                                                        return Endpoint(
                                                                                            Url.parse("https://${accessPointName}-${bucketArn?.accountId}.s3-object-lambda.${bucketArn?.region}.${bucketPartition?.dnsSuffix}"),
                                                                                            attributes = attributesOf {
                                                                                                SigningContextAttributeKey to listOf(
                                                                                                    sigV4(
                                                                                                        serviceName = "s3-object-lambda",
                                                                                                        disableDoubleUriEncode = true,
                                                                                                        signingRegion = "${bucketArn?.region}",
                                                                                                    ),
                                                                                                )
                                                                                            },
                                                                                        )
                                                                                    }
                                                                                    throw EndpointProviderException("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `${accessPointName}`")
                                                                                }
                                                                                throw EndpointProviderException("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `${bucketArn?.accountId}`")
                                                                            }
                                                                            throw EndpointProviderException("Invalid region in ARN: `${bucketArn?.region}` (invalid DNS name)")
                                                                        }
                                                                        throw EndpointProviderException("Client was configured for partition `${partitionResult?.name}` but ARN (`${params.bucket}`) has `${bucketPartition?.name}`")
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    throw EndpointProviderException("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.")
                                                }
                                                throw EndpointProviderException("Invalid ARN: bucket ARN is missing a region")
                                            }
                                        }
                                        throw EndpointProviderException("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided")
                                    }
                                    throw EndpointProviderException("Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `${arnType}`")
                                }
                                if (
                                    arnType == "accesspoint"
                                ) {
                                    run {
                                        val accessPointName = bucketArn?.resourceId?.getOrNull(1)
                                        if (
                                            accessPointName != null &&
                                            !(accessPointName == "")
                                        ) {
                                            if (
                                                !(bucketArn?.region == "")
                                            ) {
                                                if (
                                                    arnType == "accesspoint"
                                                ) {
                                                    if (
                                                        !(bucketArn?.region == "")
                                                    ) {
                                                        if (
                                                            params.disableAccessPoints != null &&
                                                            params.disableAccessPoints == true
                                                        ) {
                                                            throw EndpointProviderException("Access points are not supported for this operation")
                                                        }
                                                        if (
                                                            !(bucketArn?.resourceId?.getOrNull(2) != null)
                                                        ) {
                                                            if (
                                                                params.useArnRegion != null &&
                                                                params.useArnRegion == false &&
                                                                !(bucketArn?.region == "${params.region}")
                                                            ) {
                                                                throw EndpointProviderException("Invalid configuration: region from ARN `${bucketArn?.region}` does not match client region `${params.region}` and UseArnRegion is `false`")
                                                            }
                                                            run {
                                                                val bucketPartition = partition(bucketArn?.region)
                                                                if (
                                                                    bucketPartition != null
                                                                ) {
                                                                    run {
                                                                        val partitionResult = partition(params.region)
                                                                        if (
                                                                            partitionResult != null
                                                                        ) {
                                                                            if (
                                                                                bucketPartition?.name == "${partitionResult?.name}"
                                                                            ) {
                                                                                if (
                                                                                    isValidHostLabel(bucketArn?.region, true)
                                                                                ) {
                                                                                    if (
                                                                                        bucketArn?.service == "s3"
                                                                                    ) {
                                                                                        if (
                                                                                            isValidHostLabel(bucketArn?.accountId, false)
                                                                                        ) {
                                                                                            if (
                                                                                                isValidHostLabel(accessPointName, false)
                                                                                            ) {
                                                                                                if (
                                                                                                    params.accelerate == true
                                                                                                ) {
                                                                                                    throw EndpointProviderException("Access Points do not support S3 Accelerate")
                                                                                                }
                                                                                                if (
                                                                                                    params.useFips == true &&
                                                                                                    params.useDualStack == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://${accessPointName}-${bucketArn?.accountId}.s3-accesspoint-fips.dualstack.${bucketArn?.region}.${bucketPartition?.dnsSuffix}"),
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${bucketArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                if (
                                                                                                    params.useFips == true &&
                                                                                                    params.useDualStack == false
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://${accessPointName}-${bucketArn?.accountId}.s3-accesspoint-fips.${bucketArn?.region}.${bucketPartition?.dnsSuffix}"),
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${bucketArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                if (
                                                                                                    params.useFips == false &&
                                                                                                    params.useDualStack == true
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://${accessPointName}-${bucketArn?.accountId}.s3-accesspoint.dualstack.${bucketArn?.region}.${bucketPartition?.dnsSuffix}"),
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${bucketArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                                run {
                                                                                                    val url = parseUrl(params.endpoint)
                                                                                                    if (
                                                                                                        url != null &&
                                                                                                        params.useFips == false &&
                                                                                                        params.useDualStack == false &&
                                                                                                        params.endpoint != null
                                                                                                    ) {
                                                                                                        return Endpoint(
                                                                                                            Url.parse("${url?.scheme}://${accessPointName}-${bucketArn?.accountId}.${url?.authority}${url?.path}"),
                                                                                                            attributes = attributesOf {
                                                                                                                SigningContextAttributeKey to listOf(
                                                                                                                    sigV4(
                                                                                                                        serviceName = "s3",
                                                                                                                        disableDoubleUriEncode = true,
                                                                                                                        signingRegion = "${bucketArn?.region}",
                                                                                                                    ),
                                                                                                                )
                                                                                                            },
                                                                                                        )
                                                                                                    }
                                                                                                }
                                                                                                if (
                                                                                                    params.useFips == false &&
                                                                                                    params.useDualStack == false
                                                                                                ) {
                                                                                                    return Endpoint(
                                                                                                        Url.parse("https://${accessPointName}-${bucketArn?.accountId}.s3-accesspoint.${bucketArn?.region}.${bucketPartition?.dnsSuffix}"),
                                                                                                        attributes = attributesOf {
                                                                                                            SigningContextAttributeKey to listOf(
                                                                                                                sigV4(
                                                                                                                    serviceName = "s3",
                                                                                                                    disableDoubleUriEncode = true,
                                                                                                                    signingRegion = "${bucketArn?.region}",
                                                                                                                ),
                                                                                                            )
                                                                                                        },
                                                                                                    )
                                                                                                }
                                                                                            }
                                                                                            throw EndpointProviderException("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `${accessPointName}`")
                                                                                        }
                                                                                        throw EndpointProviderException("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `${bucketArn?.accountId}`")
                                                                                    }
                                                                                    throw EndpointProviderException("Invalid ARN: The ARN was not for the S3 service, found: ${bucketArn?.service}")
                                                                                }
                                                                                throw EndpointProviderException("Invalid region in ARN: `${bucketArn?.region}` (invalid DNS name)")
                                                                            }
                                                                            throw EndpointProviderException("Client was configured for partition `${partitionResult?.name}` but ARN (`${params.bucket}`) has `${bucketPartition?.name}`")
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        throw EndpointProviderException("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.")
                                                    }
                                                }
                                            }
                                            if (
                                                isValidHostLabel(accessPointName, true)
                                            ) {
                                                if (
                                                    params.useDualStack == true
                                                ) {
                                                    throw EndpointProviderException("S3 MRAP does not support dual-stack")
                                                }
                                                if (
                                                    params.useFips == true
                                                ) {
                                                    throw EndpointProviderException("S3 MRAP does not support FIPS")
                                                }
                                                if (
                                                    params.accelerate == true
                                                ) {
                                                    throw EndpointProviderException("S3 MRAP does not support S3 Accelerate")
                                                }
                                                if (
                                                    params.disableMultiRegionAccessPoints == true
                                                ) {
                                                    throw EndpointProviderException("Invalid configuration: Multi-Region Access Point ARNs are disabled.")
                                                }
                                                run {
                                                    val mrapPartition = partition(params.region)
                                                    if (
                                                        mrapPartition != null
                                                    ) {
                                                        if (
                                                            mrapPartition?.name == bucketArn?.partition
                                                        ) {
                                                            return Endpoint(
                                                                Url.parse("https://${accessPointName}.accesspoint.s3-global.${mrapPartition?.dnsSuffix}"),
                                                                attributes = attributesOf {
                                                                    SigningContextAttributeKey to listOf(
                                                                        sigV4A(
                                                                            serviceName = "s3",
                                                                            disableDoubleUriEncode = true,
                                                                            signingRegionSet = listOf(
                                                                                "*",
                                                                            ),
                                                                        ),
                                                                    )
                                                                },
                                                            )
                                                        }
                                                        throw EndpointProviderException("Client was configured for partition `${mrapPartition?.name}` but bucket referred to partition `${bucketArn?.partition}`")
                                                    }
                                                }
                                            }
                                            throw EndpointProviderException("Invalid Access Point Name")
                                        }
                                    }
                                    throw EndpointProviderException("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided")
                                }
                                if (
                                    bucketArn?.service == "s3-outposts"
                                ) {
                                    if (
                                        params.useDualStack == true
                                    ) {
                                        throw EndpointProviderException("S3 Outposts does not support Dual-stack")
                                    }
                                    if (
                                        params.useFips == true
                                    ) {
                                        throw EndpointProviderException("S3 Outposts does not support FIPS")
                                    }
                                    if (
                                        params.accelerate == true
                                    ) {
                                        throw EndpointProviderException("S3 Outposts does not support S3 Accelerate")
                                    }
                                    if (
                                        bucketArn?.resourceId?.getOrNull(4) != null
                                    ) {
                                        throw EndpointProviderException("Invalid Arn: Outpost Access Point ARN contains sub resources")
                                    }
                                    run {
                                        val outpostId = bucketArn?.resourceId?.getOrNull(1)
                                        if (
                                            outpostId != null
                                        ) {
                                            if (
                                                isValidHostLabel(outpostId, false)
                                            ) {
                                                if (
                                                    params.useArnRegion != null &&
                                                    params.useArnRegion == false &&
                                                    !(bucketArn?.region == "${params.region}")
                                                ) {
                                                    throw EndpointProviderException("Invalid configuration: region from ARN `${bucketArn?.region}` does not match client region `${params.region}` and UseArnRegion is `false`")
                                                }
                                                run {
                                                    val bucketPartition = partition(bucketArn?.region)
                                                    if (
                                                        bucketPartition != null
                                                    ) {
                                                        run {
                                                            val partitionResult = partition(params.region)
                                                            if (
                                                                partitionResult != null
                                                            ) {
                                                                if (
                                                                    bucketPartition?.name == partitionResult?.name
                                                                ) {
                                                                    if (
                                                                        isValidHostLabel(bucketArn?.region, true)
                                                                    ) {
                                                                        if (
                                                                            isValidHostLabel(bucketArn?.accountId, false)
                                                                        ) {
                                                                            run {
                                                                                val outpostType = bucketArn?.resourceId?.getOrNull(2)
                                                                                if (
                                                                                    outpostType != null
                                                                                ) {
                                                                                    run {
                                                                                        val accessPointName = bucketArn?.resourceId?.getOrNull(3)
                                                                                        if (
                                                                                            accessPointName != null
                                                                                        ) {
                                                                                            if (
                                                                                                outpostType == "accesspoint"
                                                                                            ) {
                                                                                                run {
                                                                                                    val url = parseUrl(params.endpoint)
                                                                                                    if (
                                                                                                        url != null &&
                                                                                                        params.endpoint != null
                                                                                                    ) {
                                                                                                        return Endpoint(
                                                                                                            Url.parse("https://${accessPointName}-${bucketArn?.accountId}.${outpostId}.${url?.authority}"),
                                                                                                            attributes = attributesOf {
                                                                                                                SigningContextAttributeKey to listOf(
                                                                                                                    sigV4(
                                                                                                                        serviceName = "s3-outposts",
                                                                                                                        disableDoubleUriEncode = true,
                                                                                                                        signingRegion = "${bucketArn?.region}",
                                                                                                                    ),
                                                                                                                )
                                                                                                            },
                                                                                                        )
                                                                                                    }
                                                                                                }
                                                                                                return Endpoint(
                                                                                                    Url.parse("https://${accessPointName}-${bucketArn?.accountId}.${outpostId}.s3-outposts.${bucketArn?.region}.${bucketPartition?.dnsSuffix}"),
                                                                                                    attributes = attributesOf {
                                                                                                        SigningContextAttributeKey to listOf(
                                                                                                            sigV4(
                                                                                                                serviceName = "s3-outposts",
                                                                                                                disableDoubleUriEncode = true,
                                                                                                                signingRegion = "${bucketArn?.region}",
                                                                                                            ),
                                                                                                        )
                                                                                                    },
                                                                                                )
                                                                                            }
                                                                                            throw EndpointProviderException("Expected an outpost type `accesspoint`, found ${outpostType}")
                                                                                        }
                                                                                    }
                                                                                    throw EndpointProviderException("Invalid ARN: expected an access point name")
                                                                                }
                                                                            }
                                                                            throw EndpointProviderException("Invalid ARN: Expected a 4-component resource")
                                                                        }
                                                                        throw EndpointProviderException("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `${bucketArn?.accountId}`")
                                                                    }
                                                                    throw EndpointProviderException("Invalid region in ARN: `${bucketArn?.region}` (invalid DNS name)")
                                                                }
                                                                throw EndpointProviderException("Client was configured for partition `${partitionResult?.name}` but ARN (`${params.bucket}`) has `${bucketPartition?.name}`")
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            throw EndpointProviderException("Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `${outpostId}`")
                                        }
                                    }
                                    throw EndpointProviderException("Invalid ARN: The Outpost Id was not set")
                                }
                                throw EndpointProviderException("Invalid ARN: Unrecognized format: ${params.bucket} (type: ${arnType})")
                            }
                        }
                        throw EndpointProviderException("Invalid ARN: No ARN type specified")
                    }
                }
                run {
                    val arnPrefix = substring(params.bucket, 0, 4, false)
                    if (
                        arnPrefix != null &&
                        arnPrefix == "arn:" &&
                        !(parseArn(params.bucket) != null)
                    ) {
                        throw EndpointProviderException("Invalid ARN: `${params.bucket}` was not a valid ARN")
                    }
                }
                if (
                    params.forcePathStyle == true &&
                    parseArn(params.bucket) != null
                ) {
                    throw EndpointProviderException("Path-style addressing cannot be used with ARN buckets")
                }
                run {
                    val uriEncodedBucket = uriEncode(params.bucket)
                    if (
                        uriEncodedBucket != null
                    ) {
                        run {
                            val partitionResult = partition(params.region)
                            if (
                                partitionResult != null
                            ) {
                                if (
                                    params.accelerate == false
                                ) {
                                    if (
                                        params.useDualStack == true &&
                                        !(params.endpoint != null) &&
                                        params.useFips == true &&
                                        params.region == "aws-global"
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3-fips.dualstack.us-east-1.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "us-east-1",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == true &&
                                        !(params.endpoint != null) &&
                                        params.useFips == true &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == true
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == true &&
                                        !(params.endpoint != null) &&
                                        params.useFips == true &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == false
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == false &&
                                        !(params.endpoint != null) &&
                                        params.useFips == true &&
                                        params.region == "aws-global"
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3-fips.us-east-1.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "us-east-1",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == false &&
                                        !(params.endpoint != null) &&
                                        params.useFips == true &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == true
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3-fips.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == false &&
                                        !(params.endpoint != null) &&
                                        params.useFips == true &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == false
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3-fips.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == true &&
                                        !(params.endpoint != null) &&
                                        params.useFips == false &&
                                        params.region == "aws-global"
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3.dualstack.us-east-1.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "us-east-1",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == true &&
                                        !(params.endpoint != null) &&
                                        params.useFips == false &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == true
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3.dualstack.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == true &&
                                        !(params.endpoint != null) &&
                                        params.useFips == false &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == false
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3.dualstack.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    run {
                                        val url = parseUrl(params.endpoint)
                                        if (
                                            url != null &&
                                            params.useDualStack == false &&
                                            params.endpoint != null &&
                                            params.useFips == false &&
                                            params.region == "aws-global"
                                        ) {
                                            return Endpoint(
                                                Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${uriEncodedBucket}"),
                                                attributes = attributesOf {
                                                    SigningContextAttributeKey to listOf(
                                                        sigV4(
                                                            serviceName = "s3",
                                                            disableDoubleUriEncode = true,
                                                            signingRegion = "us-east-1",
                                                        ),
                                                    )
                                                },
                                            )
                                        }
                                    }
                                    run {
                                        val url = parseUrl(params.endpoint)
                                        if (
                                            url != null &&
                                            params.useDualStack == false &&
                                            params.endpoint != null &&
                                            params.useFips == false &&
                                            !(params.region == "aws-global") &&
                                            params.useGlobalEndpoint == true
                                        ) {
                                            if (
                                                params.region == "us-east-1"
                                            ) {
                                                return Endpoint(
                                                    Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${uriEncodedBucket}"),
                                                    attributes = attributesOf {
                                                        SigningContextAttributeKey to listOf(
                                                            sigV4(
                                                                serviceName = "s3",
                                                                disableDoubleUriEncode = true,
                                                                signingRegion = "${params.region}",
                                                            ),
                                                        )
                                                    },
                                                )
                                            }
                                            return Endpoint(
                                                Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${uriEncodedBucket}"),
                                                attributes = attributesOf {
                                                    SigningContextAttributeKey to listOf(
                                                        sigV4(
                                                            serviceName = "s3",
                                                            disableDoubleUriEncode = true,
                                                            signingRegion = "${params.region}",
                                                        ),
                                                    )
                                                },
                                            )
                                        }
                                    }
                                    run {
                                        val url = parseUrl(params.endpoint)
                                        if (
                                            url != null &&
                                            params.useDualStack == false &&
                                            params.endpoint != null &&
                                            params.useFips == false &&
                                            !(params.region == "aws-global") &&
                                            params.useGlobalEndpoint == false
                                        ) {
                                            return Endpoint(
                                                Url.parse("${url?.scheme}://${url?.authority}${url?.normalizedPath}${uriEncodedBucket}"),
                                                attributes = attributesOf {
                                                    SigningContextAttributeKey to listOf(
                                                        sigV4(
                                                            serviceName = "s3",
                                                            disableDoubleUriEncode = true,
                                                            signingRegion = "${params.region}",
                                                        ),
                                                    )
                                                },
                                            )
                                        }
                                    }
                                    if (
                                        params.useDualStack == false &&
                                        !(params.endpoint != null) &&
                                        params.useFips == false &&
                                        params.region == "aws-global"
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "us-east-1",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == false &&
                                        !(params.endpoint != null) &&
                                        params.useFips == false &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == true
                                    ) {
                                        if (
                                            params.region == "us-east-1"
                                        ) {
                                            return Endpoint(
                                                Url.parse("https://s3.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                                attributes = attributesOf {
                                                    SigningContextAttributeKey to listOf(
                                                        sigV4(
                                                            serviceName = "s3",
                                                            disableDoubleUriEncode = true,
                                                            signingRegion = "${params.region}",
                                                        ),
                                                    )
                                                },
                                            )
                                        }
                                        return Endpoint(
                                            Url.parse("https://s3.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    if (
                                        params.useDualStack == false &&
                                        !(params.endpoint != null) &&
                                        params.useFips == false &&
                                        !(params.region == "aws-global") &&
                                        params.useGlobalEndpoint == false
                                    ) {
                                        return Endpoint(
                                            Url.parse("https://s3.${params.region}.${partitionResult?.dnsSuffix}/${uriEncodedBucket}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                }
                                throw EndpointProviderException("Path-style addressing cannot be used with S3 Accelerate")
                            }
                        }
                    }
                }
            }
            if (
                params.useObjectLambdaEndpoint != null &&
                params.useObjectLambdaEndpoint == true
            ) {
                run {
                    val partitionResult = partition(params.region)
                    if (
                        partitionResult != null
                    ) {
                        if (
                            isValidHostLabel(params.region, true)
                        ) {
                            if (
                                params.useDualStack == true
                            ) {
                                throw EndpointProviderException("S3 Object Lambda does not support Dual-stack")
                            }
                            if (
                                params.accelerate == true
                            ) {
                                throw EndpointProviderException("S3 Object Lambda does not support S3 Accelerate")
                            }
                            run {
                                val url = parseUrl(params.endpoint)
                                if (
                                    url != null &&
                                    params.endpoint != null
                                ) {
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3-object-lambda",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            if (
                                params.useFips == true
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-object-lambda-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3-object-lambda",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            return Endpoint(
                                Url.parse("https://s3-object-lambda.${params.region}.${partitionResult?.dnsSuffix}"),
                                attributes = attributesOf {
                                    SigningContextAttributeKey to listOf(
                                        sigV4(
                                            serviceName = "s3-object-lambda",
                                            disableDoubleUriEncode = true,
                                            signingRegion = "${params.region}",
                                        ),
                                    )
                                },
                            )
                        }
                        throw EndpointProviderException("Invalid region: region was not a valid DNS name.")
                    }
                }
            }
            if (
                !(params.bucket != null)
            ) {
                run {
                    val partitionResult = partition(params.region)
                    if (
                        partitionResult != null
                    ) {
                        if (
                            isValidHostLabel(params.region, true)
                        ) {
                            if (
                                params.useFips == true &&
                                params.useDualStack == true &&
                                !(params.endpoint != null) &&
                                params.region == "aws-global"
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-fips.dualstack.us-east-1.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "us-east-1",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == true &&
                                params.useDualStack == true &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == true
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == true &&
                                params.useDualStack == true &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == false
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-fips.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == true &&
                                params.useDualStack == false &&
                                !(params.endpoint != null) &&
                                params.region == "aws-global"
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-fips.us-east-1.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "us-east-1",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == true &&
                                params.useDualStack == false &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == true
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == true &&
                                params.useDualStack == false &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == false
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == false &&
                                params.useDualStack == true &&
                                !(params.endpoint != null) &&
                                params.region == "aws-global"
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3.dualstack.us-east-1.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "us-east-1",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == false &&
                                params.useDualStack == true &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == true
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == false &&
                                params.useDualStack == true &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == false
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3.dualstack.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            run {
                                val url = parseUrl(params.endpoint)
                                if (
                                    url != null &&
                                    params.useFips == false &&
                                    params.useDualStack == false &&
                                    params.endpoint != null &&
                                    params.region == "aws-global"
                                ) {
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "us-east-1",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            run {
                                val url = parseUrl(params.endpoint)
                                if (
                                    url != null &&
                                    params.useFips == false &&
                                    params.useDualStack == false &&
                                    params.endpoint != null &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == true
                                ) {
                                    if (
                                        params.region == "us-east-1"
                                    ) {
                                        return Endpoint(
                                            Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                            attributes = attributesOf {
                                                SigningContextAttributeKey to listOf(
                                                    sigV4(
                                                        serviceName = "s3",
                                                        disableDoubleUriEncode = true,
                                                        signingRegion = "${params.region}",
                                                    ),
                                                )
                                            },
                                        )
                                    }
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            run {
                                val url = parseUrl(params.endpoint)
                                if (
                                    url != null &&
                                    params.useFips == false &&
                                    params.useDualStack == false &&
                                    params.endpoint != null &&
                                    !(params.region == "aws-global") &&
                                    params.useGlobalEndpoint == false
                                ) {
                                    return Endpoint(
                                        Url.parse("${url?.scheme}://${url?.authority}${url?.path}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                            }
                            if (
                                params.useFips == false &&
                                params.useDualStack == false &&
                                !(params.endpoint != null) &&
                                params.region == "aws-global"
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "us-east-1",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == false &&
                                params.useDualStack == false &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == true
                            ) {
                                if (
                                    params.region == "us-east-1"
                                ) {
                                    return Endpoint(
                                        Url.parse("https://s3.${partitionResult?.dnsSuffix}"),
                                        attributes = attributesOf {
                                            SigningContextAttributeKey to listOf(
                                                sigV4(
                                                    serviceName = "s3",
                                                    disableDoubleUriEncode = true,
                                                    signingRegion = "${params.region}",
                                                ),
                                            )
                                        },
                                    )
                                }
                                return Endpoint(
                                    Url.parse("https://s3.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                            if (
                                params.useFips == false &&
                                params.useDualStack == false &&
                                !(params.endpoint != null) &&
                                !(params.region == "aws-global") &&
                                params.useGlobalEndpoint == false
                            ) {
                                return Endpoint(
                                    Url.parse("https://s3.${params.region}.${partitionResult?.dnsSuffix}"),
                                    attributes = attributesOf {
                                        SigningContextAttributeKey to listOf(
                                            sigV4(
                                                serviceName = "s3",
                                                disableDoubleUriEncode = true,
                                                signingRegion = "${params.region}",
                                            ),
                                        )
                                    },
                                )
                            }
                        }
                        throw EndpointProviderException("Invalid region: region was not a valid DNS name.")
                    }
                }
            }
        }
        throw EndpointProviderException("A region must be set when sending requests to S3.")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
