// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Describes how an uncompressed comma-separated values (CSV)-formatted input object is formatted.
 */
public class CsvInput private constructor(builder: Builder) {
    /**
     * Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default value is FALSE. Setting this value to TRUE may lower performance.
     */
    public val allowQuotedRecordDelimiter: kotlin.Boolean? = builder.allowQuotedRecordDelimiter
    /**
     * A single character used to indicate that a row should be ignored when the character is present at the start of that row. You can specify any character to indicate a comment line. The default character is `#`.
     *
     * Default: `#`
     */
    public val comments: kotlin.String? = builder.comments
    /**
     * A single character used to separate individual fields in a record. You can specify an arbitrary delimiter.
     */
    public val fieldDelimiter: kotlin.String? = builder.fieldDelimiter
    /**
     * Describes the first line of input. Valid values are:
     * + `NONE`: First line is not a header.
     * + `IGNORE`: First line is a header, but you can't use the header values to indicate the column in an expression. You can use column position (such as _1, _2, …) to indicate the column (`SELECT s._1 FROM OBJECT s`).
     * + `Use`: First line is a header, and you can use the header value to identify a column in an expression (`SELECT "name" FROM OBJECT`).
     */
    public val fileHeaderInfo: aws.sdk.kotlin.services.s3.model.FileHeaderInfo? = builder.fileHeaderInfo
    /**
     * A single character used for escaping when the field delimiter is part of the value. For example, if the value is `a, b`, Amazon S3 wraps this field value in quotation marks, as follows: `" a , b "`.
     *
     * Type: String
     *
     * Default: `"`
     *
     * Ancestors: `CSV`
     */
    public val quoteCharacter: kotlin.String? = builder.quoteCharacter
    /**
     * A single character used for escaping the quotation mark character inside an already escaped value. For example, the value `""" a , b """` is parsed as `" a , b "`.
     */
    public val quoteEscapeCharacter: kotlin.String? = builder.quoteEscapeCharacter
    /**
     * A single character used to separate individual records in the input. Instead of the default value, you can specify an arbitrary delimiter.
     */
    public val recordDelimiter: kotlin.String? = builder.recordDelimiter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.CsvInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CsvInput(")
        append("allowQuotedRecordDelimiter=$allowQuotedRecordDelimiter,")
        append("comments=$comments,")
        append("fieldDelimiter=$fieldDelimiter,")
        append("fileHeaderInfo=$fileHeaderInfo,")
        append("quoteCharacter=$quoteCharacter,")
        append("quoteEscapeCharacter=$quoteEscapeCharacter,")
        append("recordDelimiter=$recordDelimiter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowQuotedRecordDelimiter?.hashCode() ?: 0
        result = 31 * result + (comments?.hashCode() ?: 0)
        result = 31 * result + (fieldDelimiter?.hashCode() ?: 0)
        result = 31 * result + (fileHeaderInfo?.hashCode() ?: 0)
        result = 31 * result + (quoteCharacter?.hashCode() ?: 0)
        result = 31 * result + (quoteEscapeCharacter?.hashCode() ?: 0)
        result = 31 * result + (recordDelimiter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CsvInput

        if (allowQuotedRecordDelimiter != other.allowQuotedRecordDelimiter) return false
        if (comments != other.comments) return false
        if (fieldDelimiter != other.fieldDelimiter) return false
        if (fileHeaderInfo != other.fileHeaderInfo) return false
        if (quoteCharacter != other.quoteCharacter) return false
        if (quoteEscapeCharacter != other.quoteEscapeCharacter) return false
        if (recordDelimiter != other.recordDelimiter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.CsvInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default value is FALSE. Setting this value to TRUE may lower performance.
         */
        public var allowQuotedRecordDelimiter: kotlin.Boolean? = null
        /**
         * A single character used to indicate that a row should be ignored when the character is present at the start of that row. You can specify any character to indicate a comment line. The default character is `#`.
         *
         * Default: `#`
         */
        public var comments: kotlin.String? = null
        /**
         * A single character used to separate individual fields in a record. You can specify an arbitrary delimiter.
         */
        public var fieldDelimiter: kotlin.String? = null
        /**
         * Describes the first line of input. Valid values are:
         * + `NONE`: First line is not a header.
         * + `IGNORE`: First line is a header, but you can't use the header values to indicate the column in an expression. You can use column position (such as _1, _2, …) to indicate the column (`SELECT s._1 FROM OBJECT s`).
         * + `Use`: First line is a header, and you can use the header value to identify a column in an expression (`SELECT "name" FROM OBJECT`).
         */
        public var fileHeaderInfo: aws.sdk.kotlin.services.s3.model.FileHeaderInfo? = null
        /**
         * A single character used for escaping when the field delimiter is part of the value. For example, if the value is `a, b`, Amazon S3 wraps this field value in quotation marks, as follows: `" a , b "`.
         *
         * Type: String
         *
         * Default: `"`
         *
         * Ancestors: `CSV`
         */
        public var quoteCharacter: kotlin.String? = null
        /**
         * A single character used for escaping the quotation mark character inside an already escaped value. For example, the value `""" a , b """` is parsed as `" a , b "`.
         */
        public var quoteEscapeCharacter: kotlin.String? = null
        /**
         * A single character used to separate individual records in the input. Instead of the default value, you can specify an arbitrary delimiter.
         */
        public var recordDelimiter: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.CsvInput) : this() {
            this.allowQuotedRecordDelimiter = x.allowQuotedRecordDelimiter
            this.comments = x.comments
            this.fieldDelimiter = x.fieldDelimiter
            this.fileHeaderInfo = x.fileHeaderInfo
            this.quoteCharacter = x.quoteCharacter
            this.quoteEscapeCharacter = x.quoteEscapeCharacter
            this.recordDelimiter = x.recordDelimiter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.CsvInput = CsvInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
