// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Specifies the location where the bucket will be created.
 *
 * For directory buckets, the location type is Availability Zone. For more information about directory buckets, see [Directory buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html) in the *Amazon S3 User Guide*.
 *
 * This functionality is only supported by directory buckets.
 */
public class LocationInfo private constructor(builder: Builder) {
    /**
     * The name of the location where the bucket will be created.
     *
     * For directory buckets, the AZ ID of the Availability Zone where the bucket will be created. An example AZ ID value is `usw2-az2`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of location where the bucket will be created.
     */
    public val type: aws.sdk.kotlin.services.s3.model.LocationType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.LocationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocationInfo(")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocationInfo

        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.LocationInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the location where the bucket will be created.
         *
         * For directory buckets, the AZ ID of the Availability Zone where the bucket will be created. An example AZ ID value is `usw2-az2`.
         */
        public var name: kotlin.String? = null
        /**
         * The type of location where the bucket will be created.
         */
        public var type: aws.sdk.kotlin.services.s3.model.LocationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.LocationInfo) : this() {
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.LocationInfo = LocationInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
