// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



/**
 * Describes the parameters for Select job types.
 */
public class SelectParameters private constructor(builder: Builder) {
    /**
     * The expression that is used to query the object.
     */
    public val expression: kotlin.String = requireNotNull(builder.expression) { "A non-null value must be provided for expression" }
    /**
     * The type of the provided expression (for example, SQL).
     */
    public val expressionType: aws.sdk.kotlin.services.s3.model.ExpressionType = requireNotNull(builder.expressionType) { "A non-null value must be provided for expressionType" }
    /**
     * Describes the serialization format of the object.
     */
    public val inputSerialization: aws.sdk.kotlin.services.s3.model.InputSerialization? = builder.inputSerialization
    /**
     * Describes how the results of the Select job are serialized.
     */
    public val outputSerialization: aws.sdk.kotlin.services.s3.model.OutputSerialization? = builder.outputSerialization

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.SelectParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SelectParameters(")
        append("expression=$expression,")
        append("expressionType=$expressionType,")
        append("inputSerialization=$inputSerialization,")
        append("outputSerialization=$outputSerialization")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = expression.hashCode()
        result = 31 * result + (expressionType.hashCode())
        result = 31 * result + (inputSerialization?.hashCode() ?: 0)
        result = 31 * result + (outputSerialization?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SelectParameters

        if (expression != other.expression) return false
        if (expressionType != other.expressionType) return false
        if (inputSerialization != other.inputSerialization) return false
        if (outputSerialization != other.outputSerialization) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.SelectParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The expression that is used to query the object.
         */
        public var expression: kotlin.String? = null
        /**
         * The type of the provided expression (for example, SQL).
         */
        public var expressionType: aws.sdk.kotlin.services.s3.model.ExpressionType? = null
        /**
         * Describes the serialization format of the object.
         */
        public var inputSerialization: aws.sdk.kotlin.services.s3.model.InputSerialization? = null
        /**
         * Describes how the results of the Select job are serialized.
         */
        public var outputSerialization: aws.sdk.kotlin.services.s3.model.OutputSerialization? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.SelectParameters) : this() {
            this.expression = x.expression
            this.expressionType = x.expressionType
            this.inputSerialization = x.inputSerialization
            this.outputSerialization = x.outputSerialization
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.SelectParameters = SelectParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.InputSerialization] inside the given [block]
         */
        public fun inputSerialization(block: aws.sdk.kotlin.services.s3.model.InputSerialization.Builder.() -> kotlin.Unit) {
            this.inputSerialization = aws.sdk.kotlin.services.s3.model.InputSerialization.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.OutputSerialization] inside the given [block]
         */
        public fun outputSerialization(block: aws.sdk.kotlin.services.s3.model.OutputSerialization.Builder.() -> kotlin.Unit) {
            this.outputSerialization = aws.sdk.kotlin.services.s3.model.OutputSerialization.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (expression == null) expression = ""
            if (expressionType == null) expressionType = ExpressionType.SdkUnknown("no value provided")
            return this
        }
    }
}
