// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.Destination
import aws.sdk.kotlin.services.s3.model.StorageClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeDestinationDocument(reader: XmlTagReader): Destination {
    val builder = Destination.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Bucket com.amazonaws.s3#Destination$Bucket
            "Bucket" -> builder.bucket = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#BucketName`)" }
            // Account com.amazonaws.s3#Destination$Account
            "Account" -> builder.account = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#AccountId`)" }
            // StorageClass com.amazonaws.s3#Destination$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { StorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#StorageClass`)" }
            // AccessControlTranslation com.amazonaws.s3#Destination$AccessControlTranslation
            "AccessControlTranslation" -> builder.accessControlTranslation = deserializeAccessControlTranslationDocument(curr)
            // EncryptionConfiguration com.amazonaws.s3#Destination$EncryptionConfiguration
            "EncryptionConfiguration" -> builder.encryptionConfiguration = deserializeEncryptionConfigurationDocument(curr)
            // ReplicationTime com.amazonaws.s3#Destination$ReplicationTime
            "ReplicationTime" -> builder.replicationTime = deserializeReplicationTimeDocument(curr)
            // Metrics com.amazonaws.s3#Destination$Metrics
            "Metrics" -> builder.metrics = deserializeMetricsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
