// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.GetBucketIntelligentTieringConfigurationResponse
import aws.sdk.kotlin.services.s3.model.IntelligentTieringConfiguration
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetBucketIntelligentTieringConfigurationOperationDeserializer: HttpDeserialize<GetBucketIntelligentTieringConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetBucketIntelligentTieringConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetBucketIntelligentTieringConfigurationError(context, call)
        }
        val builder = GetBucketIntelligentTieringConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            builder.intelligentTieringConfiguration = deserializeIntelligentTieringConfigurationPayload(payload)
        }

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetBucketIntelligentTieringConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null && call.response.status == HttpStatusCode.NotFound) {
            S3ErrorDetails(code = "NotFound")
        } else {
            checkNotNull(payload){ "unable to parse error from empty response" }
            parseS3ErrorResponse(payload)
        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as 'restXml' error", ex).also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
