// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails
import aws.sdk.kotlin.services.s3.internal.parseS3ErrorResponse
import aws.sdk.kotlin.services.s3.internal.setS3ErrorMetadata
import aws.sdk.kotlin.services.s3.model.CommonPrefix
import aws.sdk.kotlin.services.s3.model.EncodingType
import aws.sdk.kotlin.services.s3.model.ListObjectsV2Response
import aws.sdk.kotlin.services.s3.model.Object
import aws.sdk.kotlin.services.s3.model.RequestCharged
import aws.sdk.kotlin.services.s3.model.S3Exception
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.HttpStatusCode
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListObjectsV2OperationDeserializer: HttpDeserialize<ListObjectsV2Response> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListObjectsV2Response {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListObjectsV2Error(context, call)
        }
        val builder = ListObjectsV2Response.Builder()

        builder.requestCharged = response.headers["x-amz-request-charged"]?.let { RequestCharged.fromValue(it) }

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListObjectsV2OperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListObjectsV2Error(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        if (payload == null && call.response.status == HttpStatusCode.NotFound) {
            S3ErrorDetails(code = "NotFound")
        } else {
            checkNotNull(payload){ "unable to parse error from empty response" }
            parseS3ErrorResponse(payload)
        }
    } catch (ex: Exception) {
        throw S3Exception("Failed to parse response as 'restXml' error", ex).also {
            setS3ErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NoSuchBucket" -> NoSuchBucketDeserializer().deserialize(context, wrappedCall)
        else -> S3Exception(errorDetails.message)
    }

    setS3ErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListObjectsV2OperationBody(builder: ListObjectsV2Response.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)

    loop@while (true) {
        val curr = root.nextTag() ?: break@loop
        when (curr.tagName) {
            // CommonPrefixes com.amazonaws.s3#ListObjectsV2Output$CommonPrefixes
            "CommonPrefixes" -> builder.commonPrefixes = run {
                val el = deserializeCommonPrefixDocument(curr)
                createOrAppend(builder.commonPrefixes, el)
            }
            // Contents com.amazonaws.s3#ListObjectsV2Output$Contents
            "Contents" -> builder.contents = run {
                val el = deserializeObjectDocument(curr)
                createOrAppend(builder.contents, el)
            }
            // ContinuationToken com.amazonaws.s3#ListObjectsV2Output$ContinuationToken
            "ContinuationToken" -> builder.continuationToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Token`)" }
            // Delimiter com.amazonaws.s3#ListObjectsV2Output$Delimiter
            "Delimiter" -> builder.delimiter = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Delimiter`)" }
            // EncodingType com.amazonaws.s3#ListObjectsV2Output$EncodingType
            "EncodingType" -> builder.encodingType = curr.tryData()
                .parse { EncodingType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#EncodingType`)" }
            // IsTruncated com.amazonaws.s3#ListObjectsV2Output$IsTruncated
            "IsTruncated" -> builder.isTruncated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.s3#IsTruncated`)" }
            // KeyCount com.amazonaws.s3#ListObjectsV2Output$KeyCount
            "KeyCount" -> builder.keyCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#KeyCount`)" }
            // MaxKeys com.amazonaws.s3#ListObjectsV2Output$MaxKeys
            "MaxKeys" -> builder.maxKeys = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#MaxKeys`)" }
            // Name com.amazonaws.s3#ListObjectsV2Output$Name
            "Name" -> builder.name = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#BucketName`)" }
            // NextContinuationToken com.amazonaws.s3#ListObjectsV2Output$NextContinuationToken
            "NextContinuationToken" -> builder.nextContinuationToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NextToken`)" }
            // Prefix com.amazonaws.s3#ListObjectsV2Output$Prefix
            "Prefix" -> builder.prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Prefix`)" }
            // StartAfter com.amazonaws.s3#ListObjectsV2Output$StartAfter
            "StartAfter" -> builder.startAfter = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#StartAfter`)" }
            else -> {}
        }
        curr.drop()
    }
}
