// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.EncodingType
import aws.sdk.kotlin.services.s3.model.ListObjectsV2Request
import aws.sdk.kotlin.services.s3.model.OptionalObjectAttributes
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ListObjectsV2OperationSerializer: HttpSerialize<ListObjectsV2Request> {
    override suspend fun serialize(context: ExecutionContext, input: ListObjectsV2Request): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            path.trailingSlash = true
            parameters.decodedParameters {
                add("list-type", "2")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.continuationToken != null) add("continuation-token", input.continuationToken)
                if (input.delimiter != null) add("delimiter", input.delimiter)
                if (input.encodingType != null) add("encoding-type", input.encodingType.value)
                if (input.fetchOwner != null) add("fetch-owner", "${input.fetchOwner}")
                if (input.maxKeys != null) add("max-keys", "${input.maxKeys}")
                if (input.prefix != null) add("prefix", input.prefix)
                if (input.startAfter != null) add("start-after", input.startAfter)
            }
        }

        builder.headers {
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.optionalObjectAttributes?.isNotEmpty() == true) appendAll("x-amz-optional-object-attributes", input.optionalObjectAttributes.map { "$it" })
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
        }

        return builder
    }
}
