// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlin.text.encodeToByteArray


internal class PutBucketPolicyOperationSerializer: HttpSerialize<PutBucketPolicyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutBucketPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.trailingSlash = true
            parameters.decodedParameters {
                add("policy", "")
            }
        }

        builder.headers {
            if (input.checksumAlgorithm != null) append("x-amz-sdk-checksum-algorithm", input.checksumAlgorithm.value)
            if (input.confirmRemoveSelfBucketAccess != null) append("x-amz-confirm-remove-self-bucket-access", "${input.confirmRemoveSelfBucketAccess}")
            if (input.contentMd5?.isNotEmpty() == true) append("Content-MD5", input.contentMd5)
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
        }

        if (input.policy != null) {
            builder.body = HttpBody.fromBytes(input.policy.encodeToByteArray())
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "text/plain")
        }
        return builder
    }
}
