// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.SessionCredentials
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeSessionCredentialsDocument(reader: XmlTagReader): SessionCredentials {
    val builder = SessionCredentials.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // AccessKeyId com.amazonaws.s3#SessionCredentials$AccessKeyId
            "AccessKeyId" -> builder.accessKeyId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#AccessKeyIdValue`)" }
            // SecretAccessKey com.amazonaws.s3#SessionCredentials$SecretAccessKey
            "SecretAccessKey" -> builder.secretAccessKey = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#SessionCredentialValue`)" }
            // SessionToken com.amazonaws.s3#SessionCredentials$SessionToken
            "SessionToken" -> builder.sessionToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#SessionCredentialValue`)" }
            // Expiration com.amazonaws.s3#SessionCredentials$Expiration
            "Expiration" -> builder.expiration = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3#SessionExpiration`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
