// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.Event
import aws.sdk.kotlin.services.s3.model.TopicConfiguration
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeTopicConfigurationDocument(reader: XmlTagReader): TopicConfiguration {
    val builder = TopicConfiguration.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Id com.amazonaws.s3#TopicConfiguration$Id
            "Id" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#NotificationId`)" }
            // TopicArn com.amazonaws.s3#TopicConfiguration$TopicArn
            "Topic" -> builder.topicArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#TopicArn`)" }
            // Events com.amazonaws.s3#TopicConfiguration$Events
            "Event" -> builder.events = run {
                val el = curr.tryData()
                    .parse { Event.fromValue(it) }
                    .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#Event`)" }
                createOrAppend(builder.events, el)
            }
            // Filter com.amazonaws.s3#TopicConfiguration$Filter
            "Filter" -> builder.filter = deserializeNotificationConfigurationFilterDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
