/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import java.io.Serializable;

public class ClientOptions
implements Serializable {
    private final boolean pingBeforeActivateConnection;
    private final boolean autoReconnect;
    private final boolean cancelCommandsOnReconnectFailure;
    private final boolean suspendReconnectOnProtocolFailure;

    public static ClientOptions copyOf(ClientOptions options) {
        return new ClientOptions(options);
    }

    private ClientOptions(Builder builder) {
        this.pingBeforeActivateConnection = builder.pingBeforeActivateConnection;
        this.cancelCommandsOnReconnectFailure = builder.cancelCommandsOnReconnectFailure;
        this.autoReconnect = builder.autoReconnect;
        this.suspendReconnectOnProtocolFailure = builder.suspendReconnectOnProtocolFailure;
    }

    private ClientOptions(ClientOptions original) {
        this.pingBeforeActivateConnection = original.pingBeforeActivateConnection;
        this.autoReconnect = original.autoReconnect;
        this.cancelCommandsOnReconnectFailure = original.cancelCommandsOnReconnectFailure;
        this.suspendReconnectOnProtocolFailure = original.suspendReconnectOnProtocolFailure;
    }

    protected ClientOptions() {
        this.pingBeforeActivateConnection = false;
        this.autoReconnect = true;
        this.cancelCommandsOnReconnectFailure = false;
        this.suspendReconnectOnProtocolFailure = false;
    }

    public boolean isPingBeforeActivateConnection() {
        return this.pingBeforeActivateConnection;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public boolean isCancelCommandsOnReconnectFailure() {
        return this.cancelCommandsOnReconnectFailure;
    }

    public boolean isSuspendReconnectOnProtocolFailure() {
        return this.suspendReconnectOnProtocolFailure;
    }

    public static class Builder {
        private boolean pingBeforeActivateConnection = false;
        private boolean autoReconnect = true;
        private boolean cancelCommandsOnReconnectFailure = false;
        private boolean suspendReconnectOnProtocolFailure = false;

        public Builder pingBeforeActivateConnection(boolean pingBeforeActivateConnection) {
            this.pingBeforeActivateConnection = pingBeforeActivateConnection;
            return this;
        }

        public Builder autoReconnect(boolean autoReconnect) {
            this.autoReconnect = autoReconnect;
            return this;
        }

        public Builder suspendReconnectOnProtocolFailure(boolean suspendReconnectOnProtocolFailure) {
            this.suspendReconnectOnProtocolFailure = suspendReconnectOnProtocolFailure;
            return this;
        }

        public Builder cancelCommandsOnReconnectFailure(boolean cancelCommandsOnReconnectFailure) {
            this.cancelCommandsOnReconnectFailure = cancelCommandsOnReconnectFailure;
            return this;
        }

        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }
}

