/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.AbstractInvocationHandler;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

class PooledConnectionInvocationHandler<T>
extends AbstractInvocationHandler {
    public static final Set<String> DISABLED_METHODS = ImmutableSet.of((Object)"auth", (Object)"select", (Object)"quit");
    private T connection;
    private final RedisConnectionPool<T> pool;

    public PooledConnectionInvocationHandler(T connection, RedisConnectionPool<T> pool) {
        this.connection = connection;
        this.pool = pool;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        if (DISABLED_METHODS.contains(method.getName())) {
            throw new UnsupportedOperationException("Calls to " + method.getName() + " are not supported on pooled connections");
        }
        if (this.connection == null) {
            throw new RedisException("Connection is deallocated and cannot be used anymore.");
        }
        if (method.getName().equals("close")) {
            this.pool.freeConnection(proxy);
            return null;
        }
        Method targetMethod = this.connection.getClass().getMethod(method.getName(), method.getParameterTypes());
        try {
            return targetMethod.invoke(this.connection, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public T getConnection() {
        return this.connection;
    }
}

