/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisClusterAsyncConnection;
import com.lambdaworks.redis.RedisClusterConnection;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.PooledClusterConnectionProvider;
import com.lambdaworks.redis.cluster.models.partitions.ClusterPartitionParser;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class RedisClusterClient
extends AbstractRedisClient {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClusterClient.class);
    private final RedisCodec<String, String> codec = new Utf8StringCodec();
    private Partitions partitions;
    private List<RedisURI> initialUris = Lists.newArrayList();

    private RedisClusterClient() {
    }

    public RedisClusterClient(RedisURI initialUri) {
        this(Collections.singletonList(Preconditions.checkNotNull((Object)initialUri, (Object)"RedisURI (initial uri) must not be null")));
    }

    public RedisClusterClient(List<RedisURI> initialUris) {
        this.initialUris = initialUris;
        Preconditions.checkNotNull(initialUris, (Object)"initialUris must not be null");
        Preconditions.checkArgument((!initialUris.isEmpty() ? 1 : 0) != 0, (Object)"initialUris must not be empty");
        this.setDefaultTimeout(this.getFirstUri().getTimeout(), this.getFirstUri().getUnit());
    }

    public RedisClusterConnection<String, String> connectCluster() {
        return this.connectCluster(this.codec);
    }

    public <K, V> RedisClusterConnection<K, V> connectCluster(RedisCodec<K, V> codec) {
        return (RedisClusterConnection)RedisClusterClient.syncHandler(this.connectClusterAsyncImpl(codec), RedisClusterConnection.class);
    }

    public RedisClusterAsyncConnection<String, String> connectClusterAsync() {
        return this.connectClusterAsyncImpl(this.codec, this.getSocketAddressSupplier());
    }

    public <K, V> RedisClusterAsyncConnection<K, V> connectClusterAsync(RedisCodec<K, V> codec) {
        return this.connectClusterAsyncImpl(codec, this.getSocketAddressSupplier());
    }

    protected RedisAsyncConnectionImpl<String, String> connectAsyncImpl(SocketAddress socketAddress) {
        return this.connectAsyncImpl(this.codec, socketAddress);
    }

    <K, V> RedisAsyncConnectionImpl<K, V> connectAsyncImpl(RedisCodec<K, V> codec, final SocketAddress socketAddress) {
        logger.debug("connectAsyncImpl(" + socketAddress + ")");
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        CommandHandler handler = new CommandHandler(this.clientOptions, queue);
        RedisAsyncConnectionImpl connection = this.newRedisAsyncConnectionImpl(handler, codec, this.timeout, this.unit);
        this.connectAsyncImpl(handler, connection, new Supplier<SocketAddress>(){

            public SocketAddress get() {
                return socketAddress;
            }
        });
        connection.registerCloseables(this.closeableResources, connection);
        return connection;
    }

    <K, V> RedisAsyncConnectionImpl<K, V> connectClusterAsyncImpl(RedisCodec<K, V> codec) {
        return this.connectClusterAsyncImpl(codec, this.getSocketAddressSupplier());
    }

    <K, V> RedisAsyncConnectionImpl<K, V> connectClusterAsyncImpl(RedisCodec<K, V> codec, Supplier<SocketAddress> socketAddressSupplier) {
        if (this.partitions == null) {
            this.initializePartitions();
        }
        logger.debug("connectCluster(" + socketAddressSupplier.get() + ")");
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        CommandHandler handler = new CommandHandler(this.clientOptions, queue);
        PooledClusterConnectionProvider<K, V> pooledClusterConnectionProvider = new PooledClusterConnectionProvider<K, V>(this, this.partitions, codec);
        ClusterDistributionChannelWriter clusterWriter = new ClusterDistributionChannelWriter(handler, pooledClusterConnectionProvider);
        RedisAsyncConnectionImpl connection = this.newRedisAsyncConnectionImpl(clusterWriter, codec, this.timeout, this.unit);
        this.connectAsyncImpl(handler, connection, socketAddressSupplier);
        connection.registerCloseables(this.closeableResources, connection, clusterWriter, pooledClusterConnectionProvider);
        if (this.getFirstUri().getPassword() != null) {
            connection.auth(new String(this.getFirstUri().getPassword()));
        }
        return connection;
    }

    public void reloadPartitions() {
        if (this.partitions == null) {
            this.initializePartitions();
        } else {
            Partitions loadedPartitions = this.loadPartitions();
            this.partitions.getPartitions().clear();
            this.partitions.getPartitions().addAll(loadedPartitions.getPartitions());
        }
    }

    protected void initializePartitions() {
        Partitions loadedPartitions;
        this.partitions = loadedPartitions = this.loadPartitions();
    }

    protected Partitions getPartitions() {
        return this.partitions;
    }

    protected Partitions loadPartitions() {
        String clusterNodes = null;
        RedisURI nodeUri = null;
        Exception lastException = null;
        for (RedisURI initialUri : this.initialUris) {
            try {
                RedisAsyncConnectionImpl<String, String> connection = this.connectAsyncImpl(initialUri.getResolvedAddress());
                nodeUri = initialUri;
                clusterNodes = (String)connection.clusterNodes().get();
                connection.close();
                break;
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (clusterNodes == null) {
            if (lastException == null) {
                throw new RedisException("Cannot retrieve initial cluster partitions from initial URIs " + this.initialUris);
            }
            throw new RedisException("Cannot retrieve initial cluster partitions from initial URIs " + this.initialUris, lastException);
        }
        Partitions loadedPartitions = ClusterPartitionParser.parse(clusterNodes);
        for (RedisClusterNode partition : loadedPartitions) {
            if (partition.getFlags().contains((Object)RedisClusterNode.NodeFlag.MYSELF)) {
                partition.setUri(nodeUri);
            }
            if (nodeUri == null || nodeUri.getPassword() == null) continue;
            partition.getUri().setPassword(new String(nodeUri.getPassword()));
        }
        return loadedPartitions;
    }

    protected <K, V> RedisAsyncConnectionImpl<K, V> newRedisAsyncConnectionImpl(RedisChannelWriter<K, V> channelWriter, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new RedisAsyncConnectionImpl<K, V>(channelWriter, codec, timeout, unit);
    }

    protected RedisURI getFirstUri() {
        Preconditions.checkState((!this.initialUris.isEmpty() ? 1 : 0) != 0, (Object)"initialUris must not be empty");
        return this.initialUris.get(0);
    }

    private Supplier<SocketAddress> getSocketAddressSupplier() {
        return new Supplier<SocketAddress>(){

            public SocketAddress get() {
                return RedisClusterClient.this.getFirstUri().getResolvedAddress();
            }
        };
    }
}

