/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.partitions;

import com.lambdaworks.redis.RedisURI;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class RedisClusterNode
implements Serializable {
    private RedisURI uri;
    private String nodeId;
    private boolean connected;
    private String slaveOf;
    private long pingSentTimestamp;
    private long pongReceivedTimestamp;
    private long configEpoch;
    private List<Integer> slots;
    private Set<NodeFlag> flags;

    public RedisClusterNode() {
    }

    public RedisClusterNode(RedisURI uri, String nodeId, boolean connected, String slaveOf, long pingSentTimestamp, long pongReceivedTimestamp, long configEpoch, List<Integer> slots, Set<NodeFlag> flags) {
        this.uri = uri;
        this.nodeId = nodeId;
        this.connected = connected;
        this.slaveOf = slaveOf;
        this.pingSentTimestamp = pingSentTimestamp;
        this.pongReceivedTimestamp = pongReceivedTimestamp;
        this.configEpoch = configEpoch;
        this.slots = slots;
        this.flags = flags;
    }

    public RedisURI getUri() {
        return this.uri;
    }

    public void setUri(RedisURI uri) {
        this.uri = uri;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String getSlaveOf() {
        return this.slaveOf;
    }

    public void setSlaveOf(String slaveOf) {
        this.slaveOf = slaveOf;
    }

    public long getPingSentTimestamp() {
        return this.pingSentTimestamp;
    }

    public void setPingSentTimestamp(long pingSentTimestamp) {
        this.pingSentTimestamp = pingSentTimestamp;
    }

    public long getPongReceivedTimestamp() {
        return this.pongReceivedTimestamp;
    }

    public void setPongReceivedTimestamp(long pongReceivedTimestamp) {
        this.pongReceivedTimestamp = pongReceivedTimestamp;
    }

    public long getConfigEpoch() {
        return this.configEpoch;
    }

    public void setConfigEpoch(long configEpoch) {
        this.configEpoch = configEpoch;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Integer> slots) {
        this.slots = slots;
    }

    public Set<NodeFlag> getFlags() {
        return this.flags;
    }

    public void setFlags(Set<NodeFlag> flags) {
        this.flags = flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisClusterNode)) {
            return false;
        }
        RedisClusterNode that = (RedisClusterNode)o;
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        return !(this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [uri=").append(this.uri);
        sb.append(", nodeId='").append(this.nodeId).append('\'');
        sb.append(", connected=").append(this.connected);
        sb.append(", slaveOf='").append(this.slaveOf).append('\'');
        sb.append(", pingSentTimestamp=").append(this.pingSentTimestamp);
        sb.append(", pongReceivedTimestamp=").append(this.pongReceivedTimestamp);
        sb.append(", configEpoch=").append(this.configEpoch);
        sb.append(", flags=").append(this.flags);
        if (this.slots != null) {
            sb.append(", slot count=").append(this.slots.size());
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum NodeFlag {
        NOFLAGS,
        MYSELF,
        SLAVE,
        MASTER,
        EVENTUAL_FAIL,
        FAIL,
        HANDSHAKE,
        NOADDR;

    }
}

