/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.cluster.RedisClusterClient;
import com.lambdaworks.redis.support.LettuceFactoryBeanSupport;
import java.net.URI;

public class RedisClusterClientFactoryBean
extends LettuceFactoryBeanSupport<RedisClusterClient> {
    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getRedisURI() == null) {
            URI uri = this.getUri();
            if (uri.getScheme().equals("redis-sentinel")) {
                throw new IllegalArgumentException("Sentinel mode not supported when using RedisClusterClient");
            }
            if (!uri.getScheme().equals("redis")) {
                throw new IllegalArgumentException("Only plain connections allowed when using RedisClusterClient");
            }
            RedisURI redisURI = RedisURI.create(uri);
            if (LettuceStrings.isNotEmpty(this.getPassword())) {
                redisURI.setPassword(this.getPassword());
            }
            this.setRedisURI(redisURI);
        }
        super.afterPropertiesSet();
    }

    protected void destroyInstance(RedisClusterClient instance) throws Exception {
        instance.shutdown();
    }

    public Class<?> getObjectType() {
        return RedisClusterClient.class;
    }

    protected RedisClusterClient createInstance() throws Exception {
        return new RedisClusterClient(this.getRedisURI());
    }
}

