/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.google.common.reflect.AbstractInvocationHandler;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TransparentPoolingInvocationHandler<T>
extends AbstractInvocationHandler {
    private RedisConnectionPool<T> pool;
    private final Map<Method, Method> methodCache = new ConcurrentHashMap<Method, Method>();

    public TransparentPoolingInvocationHandler(RedisConnectionPool<T> pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        Method targetMethod = this.getMethod(method);
        if (this.pool == null) {
            throw new RedisException("Connection pool is closed");
        }
        if (method.getName().equals("close")) {
            this.pool.close();
            this.pool = null;
            return null;
        }
        T connection = this.pool.allocateConnection();
        try {
            Object object = targetMethod.invoke(connection, args);
            return object;
        }
        finally {
            this.pool.freeConnection(connection);
        }
    }

    private Method getMethod(Method method) throws NoSuchMethodException {
        Method targetMethod = this.methodCache.get(method);
        if (targetMethod == null) {
            targetMethod = this.pool.getComponentType().getMethod(method.getName(), method.getParameterTypes());
            this.methodCache.put(method, targetMethod);
        }
        return targetMethod;
    }

    public RedisConnectionPool<T> getPool() {
        return this.pool;
    }
}

