/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper;

import com.baidu.unbiz.easymapper.Mapper;
import com.baidu.unbiz.easymapper.codegen.AtoBMapping;
import com.baidu.unbiz.easymapper.metadata.ClassMap;
import com.baidu.unbiz.easymapper.metadata.FieldMap;
import com.baidu.unbiz.easymapper.metadata.IntrospectorPropertyResolver;
import com.baidu.unbiz.easymapper.metadata.MapperKey;
import com.baidu.unbiz.easymapper.metadata.Property;
import com.baidu.unbiz.easymapper.metadata.PropertyResolver;
import com.baidu.unbiz.easymapper.metadata.Type;
import com.baidu.unbiz.easymapper.transformer.Transformer;
import com.baidu.unbiz.easymapper.util.MappedTypePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassMapBuilder<A, B>
implements MappedTypePair {
    private final Type<A> aType;
    private final Type<B> bType;
    private Map<String, Property> aProperties;
    private Map<String, Property> bProperties;
    private Map<String, MappingExtension> mappingExtensions;
    private Set<String> excludeProperties;
    private List<FieldMap> fieldsMapping;
    private boolean mapOnNull;
    private AtoBMapping<A, B> customMapping;
    private PropertyResolver propertyResolver;
    private Mapper mapper;

    public ClassMapBuilder(Type<A> aType, Type<B> bType, Mapper mapper) {
        this.aType = aType;
        this.bType = bType;
        this.mapper = mapper;
        this.propertyResolver = new IntrospectorPropertyResolver();
    }

    public ClassMapBuilder<A, B> field(String sourceField, String targetField) {
        this.putMappingExtension(sourceField, new MappingExtension(targetField));
        return this;
    }

    public <S, D> ClassMapBuilder<A, B> field(String sourceField, String targetField, Class<S> sourceType, Class<D> targetType, Transformer<S, D> transformer) {
        this.putMappingExtension(sourceField, new MappingExtension(targetField, transformer));
        return this;
    }

    public <S, D> ClassMapBuilder<A, B> field(String sourceField, String targetField, Transformer<S, D> transformer) {
        this.putMappingExtension(sourceField, new MappingExtension(targetField, transformer));
        return this;
    }

    public ClassMapBuilder<A, B> mapOnNull(boolean mapOnNull) {
        this.mapOnNull = mapOnNull;
        return this;
    }

    public ClassMapBuilder<A, B> exclude(String ... properties) {
        if (this.excludeProperties == null) {
            this.excludeProperties = new HashSet<String>();
        }
        if (properties != null) {
            this.excludeProperties.addAll(Arrays.asList(properties));
        }
        return this;
    }

    public ClassMapBuilder<A, B> customMapping(AtoBMapping<A, B> mapping) {
        this.customMapping = mapping;
        return this;
    }

    public ClassMap<A, B> build() {
        this.aProperties = this.propertyResolver.getProperties(this.aType);
        this.bProperties = this.propertyResolver.getProperties(this.bType);
        this.fieldsMapping = new ArrayList<FieldMap>();
        for (String propertyName : this.aProperties.keySet()) {
            if (propertyName.equals("class") || this.excludeProperties != null && this.excludeProperties.contains(propertyName)) continue;
            String bPropertyName = propertyName;
            Transformer<Object, Object> transformer = null;
            if (this.mappingExtensions != null && this.mappingExtensions.containsKey(propertyName)) {
                bPropertyName = this.mappingExtensions.get(propertyName).getDestinationName();
                transformer = this.mappingExtensions.get(propertyName).getTransformer();
            }
            if (!this.bProperties.containsKey(bPropertyName)) continue;
            FieldMap fieldMap = new FieldMap(this.aProperties.get(propertyName), this.bProperties.get(bPropertyName), this.mapOnNull, transformer);
            this.fieldsMapping.add(fieldMap);
        }
        return new ClassMap<A, B>(this.aType, this.bType, this.fieldsMapping, this.mapOnNull, this.customMapping);
    }

    public Mapper register() {
        this.mapper.registerClassMap(new MapperKey(this.aType, this.bType), this);
        return this.mapper;
    }

    public <A, B> B registerAndMap(A sourceObject, Class<B> targetClass) {
        this.register();
        return (B)this.mapper.map(sourceObject, targetClass);
    }

    public <A, B> B registerAndMap(A sourceObject, B targetObject) {
        this.register();
        return this.mapper.map(sourceObject, targetObject);
    }

    private void putMappingExtension(String sourceField, MappingExtension mappingExtension) {
        if (this.mappingExtensions == null) {
            this.mappingExtensions = new HashMap<String, MappingExtension>();
        }
        this.mappingExtensions.put(sourceField, mappingExtension);
    }

    @Override
    public Type<A> getAType() {
        return this.aType;
    }

    @Override
    public Type<B> getBType() {
        return this.bType;
    }

    class MappingExtension {
        private Transformer<Object, Object> transformer;
        private String destinationName;

        public MappingExtension(String destinationName) {
            this.destinationName = destinationName;
        }

        public MappingExtension(String destinationName, Transformer<Object, Object> transformer) {
            this.destinationName = destinationName;
            this.transformer = transformer;
        }

        public Transformer<Object, Object> getTransformer() {
            return this.transformer;
        }

        public String getDestinationName() {
            return this.destinationName;
        }
    }
}

