/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.unbiz.easymapper.codegen;

import com.baidu.unbiz.easymapper.Mapper;
import com.baidu.unbiz.easymapper.codegen.GeneratedAtoBMappingBase;
import com.baidu.unbiz.easymapper.codegen.SourceCodeContext;
import com.baidu.unbiz.easymapper.codegen.bytecode.ByteCodeManipulator;
import com.baidu.unbiz.easymapper.codegen.bytecode.JavassistByteCodeManipulator;
import com.baidu.unbiz.easymapper.mapping.DefaultMappingStrategy;
import com.baidu.unbiz.easymapper.metadata.ClassMap;
import com.baidu.unbiz.easymapper.metadata.FieldMap;
import com.baidu.unbiz.easymapper.metadata.VariableRef;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingCodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingCodeGenerator.class);
    private ByteCodeManipulator byteCodeManipulator = new JavassistByteCodeManipulator();
    private DefaultMappingStrategy mappingStrategy = new DefaultMappingStrategy();
    public static final GeneratedAtoBMappingBase ABSENT_MAPPING = new GeneratedAtoBMappingBase(){

        public void map(Object o, Object o2) {
        }
    };

    public GeneratedAtoBMappingBase build(ClassMap<?, ?> classMap, Mapper mapper) {
        try {
            SourceCodeContext sourceCodeContext = new SourceCodeContext(classMap.getMapperClassName(), GeneratedAtoBMappingBase.class);
            this.addMapMethod(sourceCodeContext, classMap);
            GeneratedAtoBMappingBase a2bMapping = (GeneratedAtoBMappingBase)this.byteCodeManipulator.compileClass(sourceCodeContext).newInstance();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Mapping code is\n{}", (Object)sourceCodeContext.toSourceFile());
            }
            a2bMapping.setTransformers(sourceCodeContext.getTransformers());
            a2bMapping.setMapper(mapper);
            a2bMapping.setCustomMapping(classMap.getCustomMapping());
            return a2bMapping;
        }
        catch (Exception e) {
            LOGGER.error("Generating mapping code with error: " + e.getLocalizedMessage(), (Throwable)e);
            return ABSENT_MAPPING;
        }
    }

    private Set<FieldMap> addMapMethod(SourceCodeContext code, ClassMap<?, ?> classMap) {
        LinkedHashSet<FieldMap> mappedFields = new LinkedHashSet<FieldMap>();
        StringBuilder out = new StringBuilder();
        out.append("\tpublic void map");
        out.append(String.format("(java.lang.Object a, java.lang.Object b) {\n\n", new Object[0]));
        out.append(String.format("%s source = ((%s)a);\n", classMap.getAType().getCanonicalName(), classMap.getaType().getCanonicalName()));
        out.append(String.format("%s destination = ((%s)b);", classMap.getbType().getCanonicalName(), classMap.getbType().getCanonicalName()));
        Iterator<FieldMap> i$ = classMap.getFieldsMapping().iterator();
        while (i$.hasNext()) {
            FieldMap currentFieldMap;
            FieldMap fieldMap = currentFieldMap = i$.next();
            mappedFields.add(currentFieldMap);
            String sourceCode = this.generateMappingCode(code, fieldMap);
            out.append(sourceCode);
        }
        out.append("\n\t\tif(customMapping != null) { \n\t\t\t customMapping.map").append("(source, destination);\n\t\t}");
        out.append("");
        out.append("\n\t}");
        code.addMethod(out.toString());
        return mappedFields;
    }

    private String generateMappingCode(SourceCodeContext code, FieldMap fieldMap) {
        VariableRef sourceProperty = new VariableRef(fieldMap.getSource(), "source");
        VariableRef destinationProperty = new VariableRef(fieldMap.getDestination(), "destination");
        if (!sourceProperty.isReadable() || !destinationProperty.isAssignable()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Skip {} due to source property is not readable or destination property is not assignable", (Object)fieldMap);
            }
            return "";
        }
        return this.mappingStrategy.generateMappingCode(fieldMap, sourceProperty, destinationProperty, code);
    }
}

